/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.placeholders.PlaceholderConverter;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.NBTConverter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;

public class JsonHelper {
    public static JsonArray GetArray(JsonObject json, String id) {
        if (json == null) {
            return new JsonArray();
        }
        if (json.has(id) && json.get(id).isJsonArray()) {
            return json.get(id).getAsJsonArray();
        }
        return new JsonArray();
    }

    public static JsonObject GetObject(JsonObject json, String id) {
        if (json == null) {
            return new JsonObject();
        }
        if (json.has(id) && json.get(id).isJsonObject()) {
            return json.get(id).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static String GetString(JsonObject json, String id, String def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isString()) {
            return json.get(id).getAsString();
        }
        return def;
    }

    public static Number GetNumber(JsonObject json, String id, Number def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsNumber();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static boolean GetBoolean(JsonObject json, String id, boolean def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsBoolean();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static ArrayList<JsonElement> GetUnderlyingArray(JsonArray array) {
        try {
            Field field = JsonArray.class.getDeclaredField("elements");
            field.setAccessible(true);
            return (ArrayList)field.get(array);
        }
        catch (Exception e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Unable to retrieve underlying JsonArray:", (Throwable)e);
            return null;
        }
    }

    public static JsonObject ReadFromFile(File file) {
        if (file == null || !file.exists()) {
            return new JsonObject();
        }
        try {
            InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
            fr.close();
            return json;
        }
        catch (Exception e) {
            QuestingAPI.getLogger().log(Level.ERROR, "An error occured while loading JSON from file:", (Throwable)e);
            int i = 0;
            File bkup = new File(file.getParent(), "malformed_" + file.getName() + i + ".json");
            while (bkup.exists()) {
                bkup = new File(file.getParent(), "malformed_" + file.getName() + ++i + ".json");
            }
            QuestingAPI.getLogger().log(Level.ERROR, "Creating backup at: " + bkup.getAbsolutePath());
            JsonHelper.CopyPaste(file, bkup);
            return new JsonObject();
        }
    }

    public static void WriteToFile(File file, JsonObject jObj) {
        try {
            if (!file.exists()) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jObj, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            QuestingAPI.getLogger().log(Level.ERROR, "An error occured while saving JSON to file:", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CopyPaste(File fileIn, File fileOut) {
        BufferedReader fr = null;
        BufferedWriter fw = null;
        try {
            int read;
            fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileIn), StandardCharsets.UTF_8));
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileOut), StandardCharsets.UTF_8));
            char[] buffer = new char[256];
            while ((read = fr.read(buffer)) != -1) {
                fw.write(buffer, 0, read);
            }
        }
        catch (Exception e1) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed copy paste", (Throwable)e1);
        }
        finally {
            try {
                fr.close();
                fw.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isItem(JsonObject json) {
        if (json != null && json.has("id") && json.has("Count") && json.has("Damage") && json.get("id").isJsonPrimitive()) {
            if (!json.get("id").getAsJsonPrimitive().isNumber()) {
                return Item.field_150901_e.func_148741_d((Object)new ResourceLocation(json.get("id").getAsString()));
            }
            return Item.field_150901_e.func_148754_a(json.get("id").getAsNumber().intValue()) != null;
        }
        return false;
    }

    public static boolean isFluid(JsonObject json) {
        return json != null && json.has("FluidName") && json.has("Amount") && FluidRegistry.getFluid((String)JsonHelper.GetString(json, "FluidName", "")) != null;
    }

    public static boolean isEntity(JsonObject json) {
        NBTTagCompound tags = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        return tags.func_74764_b("id") && EntityList.field_75625_b.containsKey(tags.func_74779_i("id"));
    }

    public static BigItemStack JsonToItemStack(JsonObject json) {
        if (json == null || !json.has("id") || !json.get("id").isJsonPrimitive()) {
            return new BigItemStack(Blocks.field_150348_b);
        }
        JsonPrimitive jID = json.get("id").getAsJsonPrimitive();
        int count = JsonHelper.GetNumber(json, "Count", 1).intValue();
        String oreDict = JsonHelper.GetString(json, "OreDict", "");
        int damage = JsonHelper.GetNumber(json, "Damage", Short.MAX_VALUE).intValue();
        damage = damage >= 0 ? damage : Short.MAX_VALUE;
        Item item = jID.isNumber() ? (Item)Item.field_150901_e.func_148754_a(jID.getAsInt()) : (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(jID.getAsString()));
        NBTTagCompound tags = null;
        if (json.has("tag")) {
            tags = NBTConverter.JSONtoNBT_Object(JsonHelper.GetObject(json, "tag"), new NBTTagCompound(), true);
        }
        return PlaceholderConverter.convertItem(item, jID.getAsString(), count, damage, oreDict, tags);
    }

    public static JsonObject ItemStackToJson(BigItemStack stack, JsonObject json) {
        if (stack == null) {
            return json;
        }
        json.addProperty("id", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.getBaseStack().func_77973_b())).toString());
        json.addProperty("Count", (Number)stack.stackSize);
        json.addProperty("OreDict", stack.oreDict);
        json.addProperty("Damage", (Number)stack.getBaseStack().func_77952_i());
        if (stack.HasTagCompound()) {
            json.add("tag", (JsonElement)NBTConverter.NBTtoJSON_Compound(stack.GetTagCompound(), new JsonObject(), true));
        }
        return json;
    }

    public static FluidStack JsonToFluidStack(JsonObject json) {
        String name = JsonHelper.GetString(json, "FluidName", "water");
        int amount = JsonHelper.GetNumber(json, "Amount", 1000).intValue();
        NBTTagCompound tags = null;
        if (json.has("Tag")) {
            tags = NBTConverter.JSONtoNBT_Object(JsonHelper.GetObject(json, "Tag"), new NBTTagCompound(), true);
        }
        Fluid fluid = FluidRegistry.getFluid((String)name);
        return PlaceholderConverter.convertFluid(fluid, name, amount, tags);
    }

    public static JsonObject FluidStackToJson(FluidStack stack, JsonObject json) {
        if (stack == null) {
            return json;
        }
        json.addProperty("FluidName", FluidRegistry.getFluidName((FluidStack)stack));
        json.addProperty("Amount", (Number)stack.amount);
        if (stack.tag != null) {
            json.add("Tag", (JsonElement)NBTConverter.NBTtoJSON_Compound(stack.tag, new JsonObject(), true));
        }
        return json;
    }

    public static Entity JsonToEntity(JsonObject json, World world) {
        return JsonHelper.JsonToEntity(json, world, true);
    }

    public static Entity JsonToEntity(JsonObject json, World world, boolean allowPlaceholder) {
        NBTTagCompound tags = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        Entity entity = null;
        if (tags.func_74764_b("id") && EntityList.field_75625_b.containsKey(tags.func_74779_i("id"))) {
            entity = EntityList.func_75615_a((NBTTagCompound)tags, (World)world);
        }
        return PlaceholderConverter.convertEntity(entity, world, tags);
    }

    public static JsonObject EntityToJson(Entity entity, JsonObject json) {
        if (entity == null) {
            return json;
        }
        NBTTagCompound tags = new NBTTagCompound();
        entity.func_70039_c(tags);
        String id = EntityList.func_75621_b((Entity)entity);
        tags.func_74778_a("id", id);
        NBTConverter.NBTtoJSON_Compound(tags, json, true);
        return json;
    }
}

