/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    public static final String REGEX_NUMBER = "[^\\.0123456789-]";

    public static void RenderItemStack(Minecraft mc, ItemStack stack, int x, int y, String text) {
        RenderUtils.RenderItemStack(mc, stack, x, y, text, Color.WHITE);
    }

    public static void RenderItemStack(Minecraft mc, ItemStack stack, int x, int y, String text, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderUtils.RenderItemStack(mc, stack, x, y, text, new Color(r, g, b));
    }

    public static void RenderItemStack(Minecraft mc, ItemStack stack, int x, int y, String text, Color color) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        ItemStack rStack = stack;
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            ArrayList tmp = new ArrayList();
            stack.func_77973_b().func_150895_a(stack.func_77973_b(), CreativeTabs.field_78027_g, tmp);
            if (tmp.size() > 0) {
                rStack = (ItemStack)tmp.get((int)(Minecraft.func_71386_F() / 1000L % (long)tmp.size()));
            }
        }
        GlStateManager.func_179094_E();
        RenderItem itemRender = mc.func_175599_af();
        float preZ = itemRender.field_77023_b;
        try {
            GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
            itemRender.field_77023_b = 200.0f;
            FontRenderer font = null;
            if (rStack != null) {
                font = rStack.func_77973_b().getFontRenderer(rStack);
            }
            if (font == null) {
                font = mc.field_71466_p;
            }
            itemRender.func_180450_b(rStack, x, y);
            itemRender.func_180453_a(font, rStack, x, y, text);
            RenderHelper.func_74518_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
        itemRender.field_77023_b = preZ;
        GlStateManager.func_179121_F();
    }

    public static void RenderEntity(int posX, int posY, int scale, float rotation, float pitch, Entity entity) {
        try {
            GlStateManager.func_179142_g();
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            GlStateManager.func_179109_b((float)posX, (float)posY, (float)100.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            float f3 = entity.field_70177_z;
            float f4 = entity.field_70125_A;
            RenderHelper.func_74519_b();
            GlStateManager.func_179137_b((double)0.0, (double)entity.func_70033_W(), (double)0.0);
            RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
            rendermanager.func_178631_a(180.0f);
            rendermanager.func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
            entity.field_70177_z = f3;
            entity.field_70125_A = f4;
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void DrawLine(int x1, int y1, int x2, int y2, float width, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)x1, (float)y1);
        GL11.glVertex2f((float)x2, (float)y2);
        GL11.glEnd();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void drawSplitString(FontRenderer renderer, String string, int x, int y, int width, int color, boolean shadow) {
        RenderUtils.drawSplitString(renderer, string, x, y, width, color, shadow, 0, renderer.func_78271_c(string, width).size() - 1);
    }

    public static void drawSplitString(FontRenderer renderer, String string, int x, int y, int width, int color, boolean shadow, int start, int end) {
        if (renderer == null || string == null || string.length() <= 0 || start > end) {
            return;
        }
        string = string.replaceAll("\r", "");
        List list = renderer.func_78271_c(string, width);
        for (int i = start; i <= end; ++i) {
            if (i < 0 || i >= list.size()) continue;
            renderer.func_175065_a((String)list.get(i), (float)x, (float)(y + renderer.field_78288_b * (i - start)), color, shadow);
        }
    }

    public static void guiScissor(Minecraft mc, int x, int y, int w, int h) {
        ScaledResolution r = new ScaledResolution(mc);
        int f = r.func_78325_e();
        GL11.glScissor((int)(x * f), (int)((r.func_78328_b() - y - h) * f), (int)(w * f), (int)(h * f));
    }

    public static List<String> splitStringWithoutFormat(String str, int wrapWidth, FontRenderer font) {
        ArrayList<String> list = new ArrayList<String>();
        String lastFormat = "";
        String[] nlSplit = str.split("\n");
        for (int i = 0; i < nlSplit.length; ++i) {
            String s = nlSplit[i] + (i + 1 < nlSplit.length ? "\n" : "");
            while (font.func_78256_a(s) >= wrapWidth) {
                lastFormat = FontRenderer.func_78282_e((String)(lastFormat + s));
                int n = RenderUtils.sizeStringToWidth(lastFormat + s, wrapWidth, font);
                n -= lastFormat.length();
                n = Math.max(1, n);
                String subTxt = s.substring(0, n);
                list.add(subTxt);
                s = s.replaceFirst(Pattern.quote(subTxt), "");
            }
            list.add(s);
        }
        return list;
    }

    private static int sizeStringToWidth(String str, int wrapWidth, FontRenderer font) {
        int k;
        int i = str.length();
        int j = 0;
        int l = -1;
        boolean flag = false;
        for (k = 0; k < i; ++k) {
            char c0 = str.charAt(k);
            switch (c0) {
                case '\n': {
                    --k;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    j += font.func_78263_a(c0);
                    if (!flag) break;
                    ++j;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (k >= i - 1) break;
                    if ((c1 = str.charAt(++k)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !RenderUtils.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            if (c0 == '\n') {
                l = ++k;
                break;
            }
            if (j > wrapWidth) break;
        }
        return k != i && l != -1 && l < k ? l : k;
    }

    private static boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }
}

