/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.blocks;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.blocks.SSItemHandler;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.Level;

public class TileSubmitStation
extends TileEntity
implements IFluidHandler,
ISidedInventory,
ITickable,
IFluidTankProperties {
    private final IItemHandler itemHandler;
    private final IFluidHandler fluidHandler;
    private ItemStack[] itemStack = new ItemStack[2];
    boolean needsUpdate = false;
    public UUID owner;
    public int questID;
    public int taskID;

    public TileSubmitStation() {
        this.itemHandler = new SSItemHandler(this);
        this.fluidHandler = this;
    }

    public IQuest getQuest() {
        if (this.questID < 0) {
            return null;
        }
        return QuestDatabase.INSTANCE.getValue(this.questID);
    }

    public ITask getRawTask() {
        IQuest q = this.getQuest();
        if (q == null || this.taskID < 0 || this.taskID >= q.getTasks().size()) {
            return null;
        }
        return q.getTasks().getValue(this.taskID);
    }

    public IItemTask getItemTask() {
        ITask t = this.getRawTask();
        return t == null ? null : (t instanceof IItemTask ? (IItemTask)((Object)t) : null);
    }

    public IFluidTask getFluidTask() {
        ITask t = this.getRawTask();
        return t == null ? null : (t instanceof IFluidTask ? (IFluidTask)((Object)t) : null);
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int idx) {
        if (idx < 0 || idx >= this.itemStack.length) {
            return null;
        }
        return this.itemStack[idx];
    }

    public ItemStack func_70298_a(int idx, int amount) {
        if (idx < 0 || idx >= this.itemStack.length || this.itemStack[idx] == null) {
            return null;
        }
        if (amount >= this.itemStack[idx].field_77994_a) {
            ItemStack itemstack = this.itemStack[idx];
            this.itemStack[idx] = null;
            return itemstack;
        }
        this.itemStack[idx].field_77994_a -= amount;
        ItemStack cpy = this.itemStack[idx].func_77946_l();
        cpy.field_77994_a = amount;
        return cpy;
    }

    public void func_70299_a(int idx, ItemStack stack) {
        if (idx < 0 || idx >= this.itemStack.length) {
            return;
        }
        this.itemStack[idx] = stack;
    }

    public String func_70005_c_() {
        return BetterQuesting.submitStation.func_149732_F();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.owner == null || player.func_110124_au().equals(this.owner);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int idx, ItemStack stack) {
        if (idx != 0) {
            return false;
        }
        IItemTask t = this.getItemTask();
        return t != null && this.itemStack[1] == null && !((ITask)((Object)t)).isComplete(this.owner) && t.canAcceptItem(this.owner, stack);
    }

    public int fill(FluidStack fluid, boolean doFill) {
        IQuest q = this.getQuest();
        IFluidTask t = this.getFluidTask();
        if (q == null || t == null || fluid == null) {
            return 0;
        }
        FluidStack remainder = null;
        int amount = fluid.amount;
        if (doFill) {
            remainder = t.submitFluid(this.owner, fluid);
            if (((ITask)((Object)t)).isComplete(this.owner)) {
                PacketSender.INSTANCE.sendToAll(q.getSyncPacket());
                this.reset();
                this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
            } else {
                this.needsUpdate = true;
            }
        }
        return remainder != null ? amount - remainder.amount : amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill() {
        return true;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        IFluidTask t = this.getFluidTask();
        return t != null && !((ITask)((Object)t)).isComplete(this.owner) && t.canAcceptFluid(this.owner, new FluidStack(fluid, 1));
    }

    public boolean canDrain() {
        return false;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return false;
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public FluidStack getContents() {
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this};
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IQuest q = this.getQuest();
        IItemTask t = this.getItemTask();
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            if (this.owner != null && q != null && t != null && this.owner != null && this.itemStack[0] != null && this.itemStack[1] == null) {
                ItemStack inStack = this.itemStack[0].func_77946_l();
                if (t.canAcceptItem(this.owner, inStack)) {
                    this.itemStack[0] = t.submitItem(this.owner, inStack);
                    if (((ITask)((Object)t)).isComplete(this.owner)) {
                        PacketSender.INSTANCE.sendToAll(q.getSyncPacket());
                        this.reset();
                        this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
                    } else {
                        this.needsUpdate = true;
                    }
                } else {
                    this.itemStack[1] = inStack;
                    this.itemStack[0] = null;
                }
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
                if (q != null && !this.field_145850_b.field_72995_K) {
                    PacketSender.INSTANCE.sendToAll(q.getSyncPacket());
                }
            } else if (t != null && ((ITask)((Object)t)).isComplete(this.owner)) {
                this.reset();
                this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
            }
        }
    }

    public void setupTask(UUID owner, IQuest quest, ITask task) {
        if (owner == null || quest == null || task == null) {
            this.reset();
            return;
        }
        this.questID = QuestDatabase.INSTANCE.getKey(quest);
        this.taskID = quest.getTasks().getKey(task);
        if (this.questID < 0 || this.taskID < 0) {
            this.reset();
            return;
        }
        this.owner = owner;
        this.func_70296_d();
    }

    public boolean isSetup() {
        return this.owner != null && this.questID < 0 && this.taskID < 0;
    }

    public void reset() {
        this.owner = null;
        this.questID = -1;
        this.taskID = -1;
        this.func_70296_d();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void SyncTile(NBTTagCompound data) {
        if (!this.field_145850_b.field_72995_K) {
            this.func_145839_a(data);
            this.func_70296_d();
            this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
        } else {
            NBTTagCompound payload = new NBTTagCompound();
            NBTTagCompound tileData = new NBTTagCompound();
            this.func_189515_b(tileData);
            payload.func_74782_a("tile", (NBTBase)tileData);
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.EDIT_STATION.GetLocation(), payload));
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.itemStack[0] = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("input"));
        this.itemStack[1] = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("ouput"));
        try {
            this.owner = UUID.fromString(tags.func_74779_i("owner"));
        }
        catch (Exception e) {
            this.reset();
            return;
        }
        this.questID = tags.func_74764_b("questID") ? tags.func_74762_e("questID") : -1;
        int n = this.taskID = tags.func_74764_b("task") ? tags.func_74762_e("task") : -1;
        if (this.isSetup()) {
            BetterQuesting.logger.log(Level.ERROR, "One or more tags were missing!", (Throwable)new Exception());
            this.reset();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74778_a("owner", this.owner != null ? this.owner.toString() : "");
        tags.func_74768_a("questID", this.questID);
        tags.func_74768_a("task", this.taskID);
        tags.func_74782_a("input", (NBTBase)(this.itemStack[0] != null ? this.itemStack[0].func_77955_b(new NBTTagCompound()) : new NBTTagCompound()));
        tags.func_74782_a("output", (NBTBase)(this.itemStack[1] != null ? this.itemStack[1].func_77955_b(new NBTTagCompound()) : new NBTTagCompound()));
        return tags;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.itemStack[index];
        this.itemStack[index] = null;
        return stack;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemStack = new ItemStack[2];
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(BetterQuesting.submitStation.func_149732_F());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return (T)super.getCapability(capability, facing);
    }
}

