/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingText;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.editors.GuiQuestEditor;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.QuestSettings;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiQuestInstance
extends GuiScreenThemed
implements INeedsRefresh {
    int id = -1;
    IQuest quest;
    int selTaskId = 0;
    ITask selTask = null;
    IGuiEmbedded taskRender = null;
    int selRewardId = 0;
    IReward selReward = null;
    IGuiEmbedded rewardRender = null;
    GuiButtonThemed btnTLeft;
    GuiButtonThemed btnTRight;
    GuiButtonThemed btnRLeft;
    GuiButtonThemed btnRRight;
    GuiButtonThemed btnClaim;
    NBTTagList choiceData = new NBTTagList();

    public GuiQuestInstance(GuiScreen parent, IQuest quest) {
        super(parent, I18n.func_135052_a((String)quest.getUnlocalisedName(), (Object[])new Object[0]));
        this.quest = quest;
        this.id = QuestDatabase.INSTANCE.getKey(quest);
    }

    @Override
    public void refreshGui() {
        IQuest tmp = QuestDatabase.INSTANCE.getValue(this.id);
        if (tmp == this.quest) {
            return;
        }
        this.quest = tmp;
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        this.func_73866_w_();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (QuestSettings.INSTANCE.canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g)) {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146128_h = this.field_146294_l / 2 - 100;
            ((GuiButton)this.field_146292_n.get((int)0)).field_146120_f = 100;
        }
        GuiButtonThemed btnEdit = new GuiButtonThemed(4, this.field_146294_l / 2, this.guiTop + this.sizeY - 16, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.edit", (Object[])new Object[0]), true);
        btnEdit.field_146124_l = btnEdit.field_146125_m = QuestSettings.INSTANCE.canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        this.field_146292_n.add(btnEdit);
        this.setTitle(I18n.func_135052_a((String)this.quest.getUnlocalisedName(), (Object[])new Object[0]));
        this.embedded.add(new GuiScrollingText(this.field_146297_k, this.guiLeft + 16, this.guiTop + 32, this.sizeX / 2 - 24, this.quest.getRewards().size() > 0 ? this.sizeY / 2 - 48 : this.sizeY - 64, I18n.func_135052_a((String)this.quest.getUnlocalisedDescription(), (Object[])new Object[0])));
        this.btnTLeft = new GuiButtonThemed(1, this.guiLeft + this.sizeX / 4 * 3 - 70, this.guiTop + this.sizeY - 48, 20, 20, "<", true);
        this.btnTLeft.field_146124_l = this.selTaskId > 0;
        this.btnTRight = new GuiButtonThemed(3, this.guiLeft + this.sizeX / 4 * 3 + 50, this.guiTop + this.sizeY - 48, 20, 20, ">", true);
        this.btnTRight.field_146124_l = this.selTaskId < this.quest.getTasks().size() - 1;
        this.btnRLeft = new GuiButtonThemed(6, this.guiLeft + this.sizeX / 4 - 70, this.guiTop + this.sizeY - 48, 20, 20, "<", true);
        this.btnRLeft.field_146125_m = this.quest.getRewards().size() > 0;
        this.btnRLeft.field_146124_l = this.btnRLeft.field_146125_m && this.selRewardId > 0;
        this.btnRRight = new GuiButtonThemed(7, this.guiLeft + this.sizeX / 4 + 50, this.guiTop + this.sizeY - 48, 20, 20, ">", true);
        this.btnRRight.field_146125_m = this.quest.getRewards().size() > 0;
        this.btnRRight.field_146124_l = this.btnRRight.field_146125_m && this.selRewardId < this.quest.getRewards().size() - 1;
        GuiButtonThemed btnDetect = new GuiButtonThemed(2, this.guiLeft + this.sizeX / 4 * 3 - 50, this.guiTop + this.sizeY - 48, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.detect_submit", (Object[])new Object[0]), true);
        btnDetect.field_146124_l = this.quest.canSubmit((EntityPlayer)this.field_146297_k.field_71439_g);
        this.btnClaim = new GuiButtonThemed(5, this.guiLeft + this.sizeX / 4 - 50, this.guiTop + this.sizeY - 48, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.claim", (Object[])new Object[0]), true);
        this.btnClaim.field_146125_m = this.quest.getRewards().size() > 0;
        this.btnClaim.field_146124_l = this.btnClaim.field_146125_m && this.quest.canClaim((EntityPlayer)this.field_146297_k.field_71439_g);
        this.field_146292_n.add(this.btnTLeft);
        this.field_146292_n.add(this.btnTRight);
        this.field_146292_n.add(this.btnRLeft);
        this.field_146292_n.add(this.btnRRight);
        this.field_146292_n.add(btnDetect);
        this.field_146292_n.add(this.btnClaim);
        this.refreshEmbedded();
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        int nameWidth;
        super.drawBackPanel(mx, my, partialTick);
        RenderUtils.DrawLine(this.guiLeft + this.sizeX / 2, this.guiTop + 32, this.guiLeft + this.sizeX / 2, this.guiTop + this.sizeY - 24, 1.0f, this.getTextColor());
        if (this.selTask != null) {
            int tSize = this.quest.getTasks().size();
            String tTitle = I18n.func_135052_a((String)this.selTask.getUnlocalisedName(), (Object[])new Object[0]);
            if (tSize > 1) {
                tTitle = this.selTaskId + 1 + "/" + tSize + " " + tTitle;
            }
            tTitle = TextFormatting.UNDERLINE + tTitle;
            nameWidth = this.field_146289_q.func_78256_a(tTitle);
            this.field_146289_q.func_78276_b(tTitle, this.guiLeft + this.sizeX / 4 * 3 - nameWidth / 2, this.guiTop + 32, this.getTextColor());
        }
        if (this.selReward != null) {
            int rSize = this.quest.getRewards().size();
            String rTitle = I18n.func_135052_a((String)this.selReward.getUnlocalisedName(), (Object[])new Object[0]);
            if (rSize > 1) {
                rTitle = this.selRewardId + 1 + "/" + rSize + " " + rTitle;
            }
            rTitle = TextFormatting.UNDERLINE + rTitle;
            nameWidth = this.field_146289_q.func_78256_a(rTitle);
            this.field_146289_q.func_78276_b(rTitle, this.guiLeft + this.sizeX / 4 * 1 - nameWidth / 2, this.guiTop + this.sizeY / 2 - 12, this.getTextColor());
        }
    }

    @Override
    public void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn.field_146127_k == 1) {
            --this.selTaskId;
            this.btnTLeft.field_146124_l = this.selTaskId > 0;
            this.btnTRight.field_146124_l = this.selTaskId < this.quest.getTasks().size() - 1;
            this.embedded.remove(this.taskRender);
            this.taskRender = null;
            this.refreshEmbedded();
        } else if (btn.field_146127_k == 2) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("questID", QuestDatabase.INSTANCE.getKey(this.quest).intValue());
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.DETECT.GetLocation(), tags));
        } else if (btn.field_146127_k == 3) {
            ++this.selTaskId;
            this.btnTLeft.field_146124_l = this.selTaskId > 0;
            this.btnTRight.field_146124_l = this.selTaskId < this.quest.getTasks().size() - 1;
            this.refreshEmbedded();
        } else if (btn.field_146127_k == 4) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestEditor((GuiScreen)this, this.quest));
        } else if (btn.field_146127_k == 5) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("questID", QuestDatabase.INSTANCE.getKey(this.quest).intValue());
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.CLAIM.GetLocation(), tags));
        } else if (btn.field_146127_k == 6) {
            --this.selRewardId;
            this.btnRLeft.field_146124_l = this.selRewardId > 0;
            this.btnRRight.field_146124_l = this.selRewardId < this.quest.getRewards().size() - 1;
            this.refreshEmbedded();
        } else if (btn.field_146127_k == 7) {
            ++this.selRewardId;
            this.btnRLeft.field_146124_l = this.selRewardId > 0;
            this.btnRRight.field_146124_l = this.selRewardId < this.quest.getRewards().size() - 1;
            this.refreshEmbedded();
        }
    }

    @Override
    protected void func_73869_a(char character, int keyCode) throws IOException {
        super.func_73869_a(character, keyCode);
        this.btnClaim.field_146124_l = this.quest.canClaim((EntityPlayer)this.field_146297_k.field_71439_g);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.btnClaim.field_146124_l = this.quest.canClaim((EntityPlayer)this.field_146297_k.field_71439_g);
    }

    private void refreshEmbedded() {
        this.embedded.remove(this.taskRender);
        this.taskRender = null;
        this.embedded.remove(this.rewardRender);
        this.rewardRender = null;
        int tSize = this.quest.getTasks().size();
        if (this.taskRender == null && tSize > 0) {
            this.selTask = this.quest.getTasks().getAllValues().get(this.selTaskId % tSize);
            if (this.selTask != null) {
                this.taskRender = this.selTask.getTaskGui(this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 48, this.sizeX / 2 - 24, this.sizeY - 96, this.quest);
                if (this.taskRender != null) {
                    this.embedded.add(this.taskRender);
                }
            }
        }
        int rSize = this.quest.getRewards().size();
        if (this.rewardRender == null && rSize > 0) {
            this.selReward = this.quest.getRewards().getAllValues().get(this.selRewardId % rSize);
            if (this.selReward != null) {
                this.rewardRender = this.selReward.getRewardGui(this.guiLeft + 16, this.guiTop + this.sizeY / 2, this.sizeX / 2 - 24, this.sizeY / 2 - 48, this.quest);
                if (this.rewardRender != null) {
                    this.embedded.add(this.rewardRender);
                }
            }
        }
    }
}

