/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingButtons;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.GuiQuestInstance;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPrerequisiteEditor
extends GuiScreenThemed
implements IVolatileScreen,
INeedsRefresh {
    private int questID = -1;
    private IQuest quest;
    private GuiBigTextField searchBox;
    private List<Integer> searchResults = new ArrayList<Integer>();
    private GuiScrollingButtons dbBtnList;
    private GuiScrollingButtons prBtnList;

    public GuiPrerequisiteEditor(GuiScreen parent, IQuest quest) {
        super(parent, "betterquesting.title.pre_requisites");
        this.quest = quest;
        this.questID = QuestDatabase.INSTANCE.getKey(quest);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
        }
        int btnWidth = this.sizeX / 2 - 16;
        int sx = this.sizeX - 32;
        this.searchBox = new GuiBigTextField(this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 48, btnWidth - 16, 20);
        this.searchBox.setWatermark(I18n.func_135052_a((String)"betterquesting.gui.search", (Object[])new Object[0]));
        this.field_146292_n.add(new GuiButtonThemed(1, this.guiLeft + 16 + sx / 4 * 3 - 50, this.guiTop + this.sizeY - 48, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.new", (Object[])new Object[0]), true));
        this.prBtnList = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + 16, this.guiTop + 48, btnWidth - 8, this.sizeY - 96);
        this.dbBtnList = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 68, btnWidth - 8, this.sizeY - 116);
        this.embedded.add(this.prBtnList);
        this.embedded.add(this.dbBtnList);
        this.RefreshSearch();
        this.RefreshColumns();
    }

    @Override
    public void refreshGui() {
        IQuest tmp = QuestDatabase.INSTANCE.getValue(this.questID);
        if (tmp == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        this.quest = tmp;
        this.RefreshSearch();
        this.RefreshColumns();
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        super.drawBackPanel(mx, my, partialTick);
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        super.func_73863_a(mx, my, partialTick);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = this.sizeX - 32;
        String txt = I18n.func_135052_a((String)(this.quest == null ? "ERROR" : this.quest.getUnlocalisedName()), (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_175065_a(txt, (float)(this.guiLeft + 16 + sx / 4 - this.field_146297_k.field_71466_p.func_78256_a(txt) / 2), (float)(this.guiTop + 32), this.getTextColor(), false);
        txt = I18n.func_135052_a((String)"betterquesting.gui.database", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_175065_a(txt, (float)(this.guiLeft + 16 + sx / 4 * 3 - this.field_146297_k.field_71466_p.func_78256_a(txt) / 2), (float)(this.guiTop + 32), this.getTextColor(), false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.searchBox.drawTextBox(mx, my, partialTick);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            this.createQuest();
        } else if (button.field_146127_k > 1) {
            int column = button.field_146127_k & 7;
            int id = (button.field_146127_k >> 3) - 2;
            IQuest q = QuestDatabase.INSTANCE.getValue(id);
            if (id < 0 || q == null) {
                return;
            }
            if (column == 0 || column == 3) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestInstance((GuiScreen)this, q));
            } else if (column == 1) {
                this.quest.getPrerequisites().remove(q);
                this.SendChanges();
            } else if (column == 4) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74768_a("action", EnumPacketAction.REMOVE.ordinal());
                tags.func_74768_a("questID", id);
                PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
            } else if (column == 2) {
                this.quest.getPrerequisites().add(q);
                this.SendChanges();
            }
        }
    }

    public void createQuest() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("action", EnumPacketAction.ADD.ordinal());
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tag));
    }

    public void SendChanges() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject base = new JsonObject();
        base.add("config", (JsonElement)this.quest.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        base.add("progress", (JsonElement)this.quest.writeToJson(new JsonObject(), EnumSaveType.PROGRESS));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        tags.func_74768_a("questID", QuestDatabase.INSTANCE.getKey(this.quest).intValue());
        tags.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
    }

    public void RefreshColumns() {
        int bID;
        this.prBtnList.getEntryList().clear();
        for (IQuest prq : this.quest.getPrerequisites()) {
            int qID = QuestDatabase.INSTANCE.getKey(prq);
            int btnWidth = this.prBtnList.getListWidth();
            bID = 2 + qID << 3;
            GuiButtonThemed btn1 = new GuiButtonThemed(bID + 0, 0, 0, btnWidth - 20, 20, I18n.func_135052_a((String)prq.getUnlocalisedName(), (Object[])new Object[0]));
            GuiButtonThemed btn2 = new GuiButtonThemed(bID + 1, 0, 0, 20, 20, TextFormatting.YELLOW + ">");
            this.prBtnList.addButtonRow(btn1, btn2);
        }
        this.dbBtnList.getEntryList().clear();
        Iterator<Object> iterator = this.searchResults.iterator();
        while (iterator.hasNext()) {
            int qID = (Integer)iterator.next();
            IQuest dbQ = QuestDatabase.INSTANCE.getValue(qID);
            if (dbQ == null) continue;
            int bWidth = this.dbBtnList.getListWidth();
            bID = 2 + qID << 3;
            GuiButtonThemed btn3 = new GuiButtonThemed(bID + 2, 0, 0, 20, 20, TextFormatting.GREEN + "<");
            btn3.field_146124_l = dbQ != null && this.quest != dbQ && !this.quest.getPrerequisites().contains(dbQ);
            GuiButtonThemed btn4 = new GuiButtonThemed(bID + 3, 0, 0, bWidth - 40, 20, I18n.func_135052_a((String)dbQ.getUnlocalisedName(), (Object[])new Object[0]));
            GuiButtonThemed btn5 = new GuiButtonThemed(bID + 4, 0, 0, 20, 20, "" + TextFormatting.BOLD + TextFormatting.RED + "x");
            this.dbBtnList.addButtonRow(btn3, btn4, btn5);
        }
    }

    @Override
    protected void func_73869_a(char character, int num) throws IOException {
        super.func_73869_a(character, num);
        String prevTxt = this.searchBox.func_146179_b();
        this.searchBox.func_146201_a(character, num);
        if (!this.searchBox.func_146179_b().equalsIgnoreCase(prevTxt)) {
            this.RefreshSearch();
            this.RefreshColumns();
        }
    }

    public void RefreshSearch() {
        this.searchResults.clear();
        String query = this.searchBox.func_146179_b().toLowerCase();
        for (int id : QuestDatabase.INSTANCE.getAllKeys()) {
            IQuest q = QuestDatabase.INSTANCE.getValue(id);
            if (query.length() > 0 && !q.getUnlocalisedName().toLowerCase().contains(query) && !I18n.func_135052_a((String)q.getUnlocalisedName(), (Object[])new Object[0]).toLowerCase().contains(query) && !query.equalsIgnoreCase("" + id)) continue;
            this.searchResults.add(id);
        }
    }

    public void func_73864_a(int mx, int my, int type) throws IOException {
        super.func_73864_a(mx, my, type);
        this.searchBox.func_146192_a(mx, my, type);
        if (type != 0) {
            return;
        }
        GuiButtonThemed btn1 = this.prBtnList.getButtonUnderMouse(mx, my);
        if (btn1 != null && btn1.func_146116_c(this.field_146297_k, mx, my)) {
            btn1.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn1);
            return;
        }
        GuiButtonThemed btn2 = this.dbBtnList.getButtonUnderMouse(mx, my);
        if (btn2 != null && btn2.func_146116_c(this.field_146297_k, mx, my)) {
            btn2.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn2);
            return;
        }
    }
}

