/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.events.JsonDocEvent;
import betterquesting.api.jdoc.JsonDocBasic;
import betterquesting.api.misc.ICallback;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.NBTConverter;
import betterquesting.client.gui.editors.GuiPrerequisiteEditor;
import betterquesting.client.gui.editors.json.scrolling.GuiJsonEditor;
import betterquesting.client.gui.editors.rewards.GuiRewardEditor;
import betterquesting.client.gui.editors.tasks.GuiTaskEditor;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiQuestEditor
extends GuiScreenThemed
implements ICallback<String>,
IVolatileScreen,
INeedsRefresh {
    private JsonObject lastEdit;
    private int id = -1;
    private IQuest quest;
    private GuiTextField titleField;
    private GuiBigTextField descField;
    private GuiButtonThemed btnMain;
    private GuiButtonThemed btnLogic;
    private GuiButtonThemed btnVis;

    public GuiQuestEditor(GuiScreen parent, IQuest quest) {
        super(parent, I18n.func_135052_a((String)"betterquesting.title.edit_quest", (Object[])new Object[]{I18n.func_135052_a((String)quest.getUnlocalisedName(), (Object[])new Object[0])}));
        this.quest = quest;
        this.id = QuestDatabase.INSTANCE.getKey(quest);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.setTitle(I18n.func_135052_a((String)"betterquesting.title.edit_quest", (Object[])new Object[]{I18n.func_135052_a((String)this.quest.getUnlocalisedName(), (Object[])new Object[0])}));
        if (this.lastEdit != null) {
            JsonObject prog = new JsonObject();
            this.quest.writeToJson(prog, EnumSaveType.PROGRESS);
            this.quest.readFromJson(this.lastEdit, EnumSaveType.CONFIG);
            this.quest.readFromJson(prog, EnumSaveType.PROGRESS);
            this.lastEdit = null;
            this.SendChanges();
        }
        this.titleField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 99, this.field_146295_m / 2 - 68 + 1, 198, 18);
        this.titleField.func_146203_f(Integer.MAX_VALUE);
        this.titleField.func_146180_a(this.quest.getUnlocalisedName());
        this.descField = new GuiBigTextField(this.field_146289_q, this.field_146294_l / 2 - 99, this.field_146295_m / 2 - 28 + 1, 198, 18).enableBigEdit(this);
        this.descField.func_146203_f(Integer.MAX_VALUE);
        this.descField.func_146180_a(this.quest.getUnlocalisedDescription());
        GuiButtonThemed btn = new GuiButtonThemed(1, this.field_146294_l / 2, this.field_146295_m / 2 + 28, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.rewards", (Object[])new Object[0]), true);
        this.field_146292_n.add(btn);
        btn = new GuiButtonThemed(2, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 28, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.tasks", (Object[])new Object[0]), true);
        this.field_146292_n.add(btn);
        btn = new GuiButtonThemed(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 48, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.requirements", (Object[])new Object[0]), true);
        this.field_146292_n.add(btn);
        btn = new GuiButtonThemed(4, this.field_146294_l / 2, this.field_146295_m / 2 + 68, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.advanced", (Object[])new Object[0]), true);
        this.field_146292_n.add(btn);
        this.btnMain = new GuiButtonThemed(5, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 8, 200, 20, I18n.func_135052_a((String)"betterquesting.btn.is_main", (Object[])new Object[0]) + ": " + this.quest.getProperties().getProperty(NativeProps.MAIN), true);
        this.field_146292_n.add(this.btnMain);
        this.btnLogic = new GuiButtonThemed(6, this.field_146294_l / 2, this.field_146295_m / 2 + 48, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.logic", (Object[])new Object[0]) + ": " + (Object)((Object)this.quest.getProperties().getProperty(NativeProps.LOGIC_QUEST)), true);
        this.field_146292_n.add(this.btnLogic);
        this.btnVis = new GuiButtonThemed(7, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 68, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.show", (Object[])new Object[0]) + ": " + (Object)((Object)this.quest.getProperties().getProperty(NativeProps.VISIBILITY)), true);
        this.field_146292_n.add(this.btnVis);
    }

    @Override
    public void refreshGui() {
        this.quest = QuestDatabase.INSTANCE.getValue(this.id);
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        this.lastEdit = null;
        this.titleField.func_146180_a(this.quest.getUnlocalisedName());
        this.descField.func_146180_a(this.quest.getUnlocalisedDescription());
        this.btnMain.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.is_main", (Object[])new Object[0]) + ": " + this.quest.getProperties().getProperty(NativeProps.MAIN);
        this.btnLogic.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.logic", (Object[])new Object[0]) + ": " + (Object)((Object)this.quest.getProperties().getProperty(NativeProps.LOGIC_QUEST));
        this.btnVis.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.show", (Object[])new Object[0]) + ": " + (Object)((Object)this.quest.getProperties().getProperty(NativeProps.VISIBILITY));
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        super.func_73863_a(mx, my, partialTick);
        this.titleField.func_146194_f();
        this.descField.drawTextBox(mx, my, partialTick);
        this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.name", (Object[])new Object[0]), (float)(this.field_146294_l / 2 - 100), (float)(this.field_146295_m / 2 - 80), this.getTextColor(), false);
        this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.description", (Object[])new Object[0]), (float)(this.field_146294_l / 2 - 100), (float)(this.field_146295_m / 2 - 40), this.getTextColor(), false);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiRewardEditor((GuiScreen)this, this.quest));
        } else if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiTaskEditor((GuiScreen)this, this.quest));
        } else if (button.field_146127_k == 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPrerequisiteEditor((GuiScreen)this, this.quest));
        } else if (button.field_146127_k == 4) {
            this.lastEdit = new JsonObject();
            this.quest.writeToJson(this.lastEdit, EnumSaveType.CONFIG);
            JsonDocEvent event = new JsonDocEvent(new JsonDocBasic(null, "jdoc.betterquesting.quest"));
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonEditor((GuiScreen)this, this.lastEdit, event.getJdocResult()));
        } else if (button.field_146127_k == 5) {
            boolean main = this.quest.getProperties().getProperty(NativeProps.MAIN) == false;
            this.quest.getProperties().setProperty(NativeProps.MAIN, main);
            button.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.is_main", (Object[])new Object[0]) + ": " + main;
            this.SendChanges();
        } else if (button.field_146127_k == 6) {
            EnumLogic[] logicList = EnumLogic.values();
            EnumLogic logic = this.quest.getProperties().getProperty(NativeProps.LOGIC_QUEST);
            logic = logicList[(logic.ordinal() + 1) % logicList.length];
            this.quest.getProperties().setProperty(NativeProps.LOGIC_QUEST, logic);
            button.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.logic", (Object[])new Object[0]) + ": " + (Object)((Object)logic);
            this.SendChanges();
        } else if (button.field_146127_k == 7) {
            EnumQuestVisibility[] visList = EnumQuestVisibility.values();
            EnumQuestVisibility vis = this.quest.getProperties().getProperty(NativeProps.VISIBILITY);
            vis = visList[(vis.ordinal() + 1) % visList.length];
            this.quest.getProperties().setProperty(NativeProps.VISIBILITY, vis);
            button.field_146126_j = I18n.func_135052_a((String)"betterquesting.btn.show", (Object[])new Object[0]) + ": " + (Object)((Object)vis);
            this.SendChanges();
        }
    }

    @Override
    protected void func_73869_a(char character, int keyCode) throws IOException {
        super.func_73869_a(character, keyCode);
        this.titleField.func_146201_a(character, keyCode);
        this.descField.func_146201_a(character, keyCode);
    }

    protected void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        this.titleField.func_146192_a(mx, my, click);
        this.descField.func_146192_a(mx, my, click);
        boolean flag = false;
        if (!this.titleField.func_146206_l() && !this.titleField.func_146179_b().equals(this.quest.getUnlocalisedName())) {
            this.quest.getProperties().setProperty(NativeProps.NAME, this.titleField.func_146179_b());
            flag = true;
        }
        if (!this.descField.func_146206_l() && !this.descField.func_146179_b().equals(this.quest.getUnlocalisedDescription())) {
            this.quest.getProperties().setProperty(NativeProps.DESC, this.descField.func_146179_b());
            flag = true;
        }
        if (flag) {
            this.SendChanges();
        }
    }

    public void SendChanges() {
        JsonObject base = new JsonObject();
        base.add("config", (JsonElement)this.quest.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        base.add("progress", (JsonElement)this.quest.writeToJson(new JsonObject(), EnumSaveType.PROGRESS));
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tags.func_74768_a("questID", this.id);
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
    }

    @Override
    public void setValue(String text) {
        if (this.descField != null) {
            this.descField.func_146180_a(text);
        }
        this.quest.getProperties().setProperty(NativeProps.DESC, text);
        this.SendChanges();
    }
}

