/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.QuestLineButtonTree;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.client.toolbox.IToolboxTab;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.GuiQuestLinesEmbedded;
import betterquesting.client.toolbox.ToolboxRegistry;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiQuestLineDesigner
extends GuiScreenThemed
implements IVolatileScreen,
INeedsRefresh {
    private List<IToolboxTab> tabList = new ArrayList<IToolboxTab>();
    private int lineID = -1;
    private IQuestLine qLine;
    private GuiQuestLinesEmbedded qlGui;
    private int tabIndex = 0;
    private IToolboxTab toolTab = null;
    private IGuiEmbedded tabGui = null;

    public GuiQuestLineDesigner(GuiScreen parent, IQuestLine qLine) {
        super(parent, "betterquesting.title.designer");
        this.qLine = qLine;
        this.lineID = QuestLineDatabase.INSTANCE.getKey(qLine);
    }

    public GuiQuestLinesEmbedded getEmbeddedGui() {
        return this.qlGui;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.sizeX -= 96;
        ((GuiButton)this.field_146292_n.get((int)0)).field_146128_h = this.guiLeft + this.sizeX / 2 - 100;
        GuiQuestLinesEmbedded oldGui = this.qlGui;
        this.qlGui = new GuiQuestLinesEmbedded(this.guiLeft + 16, this.guiTop + 16, this.sizeX - 32, this.sizeY - 32);
        this.qlGui.setQuestLine(new QuestLineButtonTree(this.qLine), true);
        if (oldGui != null) {
            this.embedded.remove(oldGui);
            this.qlGui.copySettings(oldGui);
        }
        this.qlGui.clampScroll();
        this.embedded.add(this.qlGui);
        this.tabList.clear();
        this.tabList.addAll(ToolboxRegistry.INSTANCE.getAllTools());
        this.tabIndex = MathHelper.func_76125_a((int)this.tabIndex, (int)0, (int)Math.max(0, this.tabList.size() - 1));
        for (IToolboxTab tab : this.tabList) {
            tab.initTools(this.qlGui);
        }
        if (this.tabList.size() > 0) {
            this.toolTab = this.tabList.get(this.tabIndex);
            this.tabGui = this.toolTab.getTabGui(this.guiLeft + this.sizeX + 16, this.guiTop + 32, 64, this.sizeY - 48);
            if (this.tabGui != null) {
                this.embedded.add(this.tabGui);
            }
        }
        GuiButtonThemed btnLeft = new GuiButtonThemed(1, this.guiLeft + this.sizeX, this.guiTop + 16, 16, 16, "<", true);
        GuiButtonThemed btnRight = new GuiButtonThemed(2, this.guiLeft + this.sizeX + 80, this.guiTop + 16, 16, 16, ">", true);
        if (this.tabList.size() <= 1) {
            btnLeft.field_146124_l = false;
            btnRight.field_146124_l = false;
        }
        this.field_146292_n.add(btnLeft);
        this.field_146292_n.add(btnRight);
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        this.func_146276_q_();
        this.currentTheme().getRenderer().drawThemedPanel(this.guiLeft + this.sizeX, this.guiTop, 96, this.sizeY);
        this.currentTheme().getRenderer().drawThemedPanel(this.guiLeft, this.guiTop, this.sizeX, this.sizeY);
        String tmp = I18n.func_135052_a((String)"betterquesting.title.designer", (Object[])new Object[0]);
        this.field_146289_q.func_175065_a(TextFormatting.BOLD + tmp, (float)(this.guiLeft + this.sizeX / 2 - this.field_146289_q.func_78256_a(tmp) / 2), (float)(this.guiTop + 18), this.getTextColor(), false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (IGuiEmbedded e : this.embedded) {
            GlStateManager.func_179094_E();
            e.drawBackground(mx, my, partialTick);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderUtils.DrawLine(this.guiLeft + this.sizeX + 16, this.guiTop + 32, this.guiLeft + this.sizeX + 80, this.guiTop + 32, partialTick, this.getTextColor());
        if (this.toolTab != null) {
            String tabTitle = TextFormatting.UNDERLINE + I18n.func_135052_a((String)this.toolTab.getUnlocalisedName(), (Object[])new Object[0]);
            this.field_146289_q.func_175065_a(tabTitle, (float)(this.guiLeft + this.sizeX + 48 - this.field_146289_q.func_78256_a(tabTitle) / 2), (float)(this.guiTop + 16 + 2), this.getTextColor(), false);
        }
    }

    @Override
    public void refreshGui() {
        this.qLine = QuestLineDatabase.INSTANCE.getValue(this.lineID);
        if (this.qLine == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        this.qlGui.setQuestLine(new QuestLineButtonTree(this.qLine), false);
        this.qlGui.setActiveTool(this.qlGui.getActiveTool());
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        int ts = this.tabList.size();
        if (ts > 1) {
            boolean flag = false;
            if (button.field_146127_k == 1) {
                this.tabIndex = ((this.tabIndex - 1) % ts + ts) % ts;
                flag = true;
            } else if (button.field_146127_k == 2) {
                this.tabIndex = (this.tabIndex + 1) % ts;
                flag = true;
            }
            if (flag) {
                this.toolTab = this.tabList.get(this.tabIndex);
                if (this.tabGui != null) {
                    this.embedded.remove(this.tabGui);
                }
                this.tabGui = this.toolTab.getTabGui(this.guiLeft + this.sizeX + 16, this.guiTop + 32, 64, this.sizeY - 48);
                if (this.tabGui != null) {
                    this.embedded.add(this.tabGui);
                }
            }
        }
    }
}

