/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingText;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.misc.ICallback;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTextEditor
extends GuiScreenThemed
implements IVolatileScreen {
    private ICallback<String> host;
    private String text = "";
    private int listScroll = 0;
    private int maxRows = 0;
    private GuiScrollingText scrollingText;
    private int cursorPosition;

    public GuiTextEditor(GuiScreen parent, String text) {
        super(parent, "betterquesting.title.edit_text");
        this.text = text;
    }

    public GuiTextEditor setHost(ICallback<String> host) {
        this.host = host;
        return this;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.maxRows = (this.sizeY - 48) / 20;
        for (int i = 0; i < this.maxRows; ++i) {
            GuiButtonThemed btn = new GuiButtonThemed(i + 1, this.guiLeft + 16, this.guiTop + 32 + i * 20, 100, 20, "NULL", true);
            this.field_146292_n.add(btn);
        }
        this.scrollingText = new GuiScrollingText(this.field_146297_k, this.guiLeft + 132, this.guiTop + 32, this.sizeX - 148, this.sizeY - 64);
        this.scrollingText.SetText(this.text);
        this.embedded.add(this.scrollingText);
        this.cursorPosition = this.text.length();
        this.RefreshColumns();
    }

    @Override
    public void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn.field_146127_k > 0) {
            int n1 = btn.field_146127_k - 1;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.listScroll;
            if (n2 == 0 && n3 >= 0 && n3 < TextFormatting.values().length) {
                String tmp = TextFormatting.values()[n3].toString();
                this.writeText(tmp);
            }
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (this.host != null) {
            this.host.setValue(this.text);
        }
    }

    public void moveCursorBy(int p_146182_1_) {
        this.setCursorPosition(this.cursorPosition + p_146182_1_);
    }

    public void setCursorPosition(int p_146190_1_) {
        this.cursorPosition = p_146190_1_;
        int j = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setSelectionPos(int p_146199_1_) {
        int j = this.text.length();
        if (p_146199_1_ > j) {
            p_146199_1_ = j;
        }
        if (p_146199_1_ < 0) {
            p_146199_1_ = 0;
        }
    }

    public void deleteFromCursor(int p_146175_1_) {
        if (this.text.length() != 0) {
            boolean flag = p_146175_1_ < 0;
            int j = flag ? this.cursorPosition + p_146175_1_ : this.cursorPosition;
            int k = flag ? this.cursorPosition : this.cursorPosition + p_146175_1_;
            String s = "";
            if (j >= 0) {
                s = this.text.substring(0, j);
            }
            if (k < this.text.length()) {
                s = s + this.text.substring(k);
            }
            this.text = s;
            if (flag) {
                this.moveCursorBy(p_146175_1_);
            }
        }
    }

    @Override
    public void func_73869_a(char p_146201_1_, int p_146201_2_) {
        switch (p_146201_1_) {
            case '\u0001': {
                this.setCursorPositionEnd();
                this.setSelectionPos(0);
                return;
            }
            case '\u0016': {
                this.writeText(GuiScreen.func_146277_j());
                return;
            }
        }
        switch (p_146201_2_) {
            case 14: {
                this.deleteFromCursor(-1);
                return;
            }
            case 28: 
            case 156: {
                this.writeText("\n");
                return;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return;
            }
            case 203: {
                this.moveCursorBy(-1);
                return;
            }
            case 205: {
                this.moveCursorBy(1);
                return;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return;
            }
            case 211: {
                this.deleteFromCursor(1);
                return;
            }
        }
        this.writeText(ChatAllowedCharacters.func_71565_a((String)Character.toString(p_146201_1_)));
    }

    public void writeText(String raw) {
        String s1 = "";
        String s2 = raw;
        int i = this.cursorPosition;
        if (this.text.length() > 0) {
            s1 = s1 + this.text.substring(0, i);
        }
        s1 = s1 + s2;
        int l = s2.length();
        if (this.text.length() > 0 && i < this.text.length()) {
            s1 = s1 + this.text.substring(i);
        }
        this.text = s1;
        this.moveCursorBy(l);
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        int s;
        super.func_73863_a(mx, my, partialTick);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.guiLeft + 116, this.guiTop + 32, 248, 0, 8, 20);
        for (s = 20; s < (this.maxRows - 1) * 20; s += 20) {
            this.func_73729_b(this.guiLeft + 116, this.guiTop + 32 + s, 248, 20, 8, 20);
        }
        this.func_73729_b(this.guiLeft + 116, this.guiTop + 32 + s, 248, 40, 8, 20);
        this.func_73729_b(this.guiLeft + 116, this.guiTop + 32 + (int)Math.max(0.0f, (float)s * (float)this.listScroll / (float)(TextFormatting.values().length - this.maxRows)), 248, 60, 8, 20);
        String s1 = this.text.substring(0, this.cursorPosition);
        String s2 = this.text.substring(this.cursorPosition);
        if (this.field_146289_q.func_78260_a()) {
            s1 = s1 + "_";
        } else if (Minecraft.func_71386_F() / 500L % 2L == 0L) {
            s1.substring(0, this.cursorPosition);
            s1 = s1 + "_";
        } else {
            s1 = s1 + " ";
        }
        this.scrollingText.SetText(s1 + s2);
    }

    @Override
    public void mouseScroll(int mx, int my, int scroll) {
        super.mouseScroll(mx, my, scroll);
        if (scroll != 0 && this.isWithin(mx, my, this.guiLeft, this.guiTop, 116, this.sizeY)) {
            this.listScroll = Math.max(0, MathHelper.func_76125_a((int)(this.listScroll + scroll), (int)0, (int)(TextFormatting.values().length - this.maxRows)));
            this.RefreshColumns();
        }
    }

    public void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        if (this.isWithin(mx, my, this.guiLeft + 132, this.guiTop + 32, this.sizeX - 148, this.sizeY - 64, false)) {
            this.setCursorPosition(this.scrollingText.getCursorPos(mx, my));
        }
    }

    public void RefreshColumns() {
        this.listScroll = Math.max(0, MathHelper.func_76125_a((int)this.listScroll, (int)0, (int)(TextFormatting.values().length - this.maxRows)));
        List btnList = this.field_146292_n;
        for (int i = 1; i < btnList.size(); ++i) {
            GuiButton btn = (GuiButton)btnList.get(i);
            int n1 = btn.field_146127_k - 1;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.listScroll;
            if (n2 != 0) continue;
            if (n3 >= 0 && n3 < TextFormatting.values().length) {
                btn.field_146126_j = TextFormatting.values()[n3].func_96297_d();
                btn.field_146125_m = true;
                btn.field_146124_l = true;
                continue;
            }
            btn.field_146126_j = "NULL";
            btn.field_146125_m = false;
            btn.field_146124_l = false;
        }
    }
}

