/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonStorage;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingButtons;
import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.RenderUtils;
import betterquesting.core.BetterQuesting;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class GuiJsonEntitySelection
extends GuiScreenThemed {
    private Entity entity;
    private ICallback<Entity> callback;
    private final List<String> entityNames = new ArrayList<String>();
    private GuiBigTextField searchField;
    private GuiScrollingButtons btnList;
    private String searchTxt = "";
    private Iterator<String> searching = null;

    public GuiJsonEntitySelection(GuiScreen parent, ICallback<Entity> callback, Entity entity) {
        super(parent, "betterquesting.title.select_entity");
        this.entity = entity;
        this.callback = callback;
        if (this.entity == null) {
            this.entity = new EntityPig((World)Minecraft.func_71410_x().field_71441_e);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.entityNames.addAll(EntityList.field_75625_b.keySet());
        Collections.sort(this.entityNames);
        this.searchField = new GuiBigTextField(this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 2 + 1, this.guiTop + 33, this.sizeX / 2 - 18, 14);
        this.searchField.setWatermark(I18n.func_135052_a((String)"betterquesting.gui.search", (Object[])new Object[0]));
        this.searchField.func_146203_f(Integer.MAX_VALUE);
        this.btnList = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + this.sizeX / 2, this.guiTop + 48, this.sizeX / 2 - 16, this.sizeY - 80);
        this.embedded.add(this.btnList);
        this.searching = this.entityNames.iterator();
        this.updateSearch();
    }

    public void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        this.searchField.func_146192_a(mx, my, click);
        GuiButtonThemed btn = this.btnList.getButtonUnderMouse(mx, my);
        if (btn != null && btn.func_146116_c(this.field_146297_k, mx, my) && click == 0) {
            btn.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn);
        }
    }

    @Override
    public void func_146284_a(GuiButton button) {
        Entity tmpE;
        if (button.field_146127_k == 0 && this.callback != null) {
            this.callback.setValue(this.entity);
        } else if (button.field_146127_k == 1 && (tmpE = EntityList.func_75620_a((String)((String)((GuiButtonStorage)button).getStored()), (World)this.field_146297_k.field_71441_e)) != null) {
            try {
                tmpE.func_70020_e(new NBTTagCompound());
                tmpE.field_70128_L = false;
                this.entity = tmpE;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Failed to init selected entity", (Throwable)e);
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        this.updateSearch();
        super.func_73863_a(mx, my, partialTick);
        this.searchField.drawTextBox(mx, my, partialTick);
        if (this.entity != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float angle = (float)Minecraft.func_71386_F() % 30000.0f / 30000.0f * 360.0f;
            float scale = 64.0f;
            if (this.entity.field_70131_O * scale > (float)this.sizeY / 2.0f) {
                scale = (float)this.sizeY / 2.0f / this.entity.field_70131_O;
            }
            if (this.entity.field_70130_N * scale > (float)this.sizeX / 4.0f) {
                scale = (float)this.sizeX / 4.0f / this.entity.field_70130_N;
            }
            try {
                RenderUtils.RenderEntity(this.guiLeft + this.sizeX / 4, this.guiTop + this.sizeY / 2 + MathHelper.func_76123_f((float)(this.entity.field_70131_O / 2.0f * scale)), (int)scale, angle, 0.0f, this.entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GlStateManager.func_179121_F();
        }
    }

    private void updateSearch() {
        if (this.searching == null) {
            return;
        }
        if (!this.searching.hasNext()) {
            this.searching = null;
            return;
        }
        int pass = 0;
        int btnWidth = this.btnList.getListWidth();
        while (this.searching.hasNext() && pass < 64) {
            String key = this.searching.next();
            boolean abs = Modifier.isAbstract(((Class)EntityList.field_75625_b.get(key)).getModifiers());
            if (abs || !key.toLowerCase().contains(this.searchTxt)) continue;
            GuiButtonStorage<String> btn = new GuiButtonStorage<String>(1, 0, 0, btnWidth, 20, key);
            btn.setStored(key);
            this.btnList.addButtonRow(btn);
        }
    }

    @Override
    public void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        this.searchField.func_146201_a(c, keyCode);
        if (!this.searchField.func_146179_b().equalsIgnoreCase(this.searchTxt)) {
            this.btnList.getEntryList().clear();
            this.searchTxt = this.searchField.func_146179_b().toLowerCase();
            this.searching = this.entityNames.iterator();
        }
    }
}

