/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiNumberField;
import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.editors.json.scrolling.GuiScrollingFluidGrid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiJsonFluidSelection
extends GuiScreenThemed {
    private FluidStack stackSelect;
    private ICallback<FluidStack> callback;
    private GuiBigTextField searchBox;
    private GuiNumberField numberBox;
    private GuiScrollingFluidGrid fluidGrid;
    private FluidStack ttStack;
    Iterator<Fluid> searching = null;
    String searchTxt = "";

    public GuiJsonFluidSelection(GuiScreen parent, ICallback<FluidStack> callback, FluidStack stack) {
        super(parent, "betterquesting.title.select_fluid");
        this.stackSelect = stack;
        this.callback = callback;
        if (this.stackSelect == null) {
            this.stackSelect = new FluidStack(FluidRegistry.WATER, 1000);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchBox = new GuiBigTextField(this.field_146289_q, this.guiLeft + this.sizeX / 2 + 9, this.guiTop + 33, this.sizeX / 2 - 26, 14);
        this.searchBox.setWatermark(I18n.func_135052_a((String)"betterquesting.gui.search", (Object[])new Object[0]));
        this.searchBox.func_146203_f(Integer.MAX_VALUE);
        this.fluidGrid = new GuiScrollingFluidGrid(this.field_146297_k, this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 48, this.sizeX / 2 - 24, this.sizeY - 80);
        this.embedded.add(this.fluidGrid);
        this.numberBox = new GuiNumberField(this.field_146289_q, this.guiLeft + 76, this.guiTop + 57, 100, 16);
        if (this.stackSelect != null) {
            this.numberBox.func_146180_a("" + this.stackSelect.amount);
        }
        this.searching = FluidRegistry.getRegisteredFluids().values().iterator();
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        super.drawBackPanel(mx, my, partialTick);
        this.ttStack = null;
        int btnWidth = this.sizeX / 2 - 16;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.selection", (Object[])new Object[0]), (float)(this.guiLeft + 24), (float)(this.guiTop + 36), this.getTextColor(), false);
        this.field_146289_q.func_175065_a("x", (float)(this.guiLeft + 64), (float)(this.guiTop + 60), this.getTextColor(), false);
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b((this.guiLeft + 24) / 2, (this.guiTop + 48) / 2, 0, 48, 18, 18);
        if (this.stackSelect != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                TextureAtlasSprite fluidTx = this.field_146297_k.func_147117_R().func_110572_b(this.stackSelect.getFluid().getStill().toString());
                fluidTx = fluidTx != null ? fluidTx : this.field_146297_k.func_147117_R().func_110572_b("missingno");
                this.func_175175_a((this.guiLeft + 26) / 2, (this.guiTop + 50) / 2, fluidTx, 16, 16);
            }
            catch (Exception fluidTx) {
                // empty catch block
            }
            if (this.isWithin(mx, my, 25, 49, 32, 32)) {
                this.ttStack = this.stackSelect;
            }
        }
        GlStateManager.func_179121_F();
        this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), (float)(this.guiLeft + 24), (float)(this.guiTop + this.sizeY / 2 - 12), this.getTextColor(), false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_146297_k.field_71439_g != null) {
            ItemStack[] invoStacks = this.field_146297_k.field_71439_g.field_71071_by.field_70462_a;
            int isx = 162;
            int isy = 72;
            float scale = Math.min((float)(btnWidth - 16) / (float)isx, ((float)this.sizeY / 2.0f - 32.0f) / (float)isy);
            int ipx = this.guiLeft + 16 + btnWidth / 2 - (int)((float)(isx / 2) * scale);
            int ipy = this.guiTop + this.sizeY / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)ipx, (float)ipy, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            for (int i = 0; i < invoStacks.length && i < 36; ++i) {
                int x = i % 9 * 18;
                int y = (i - i % 9) / 9 * 18;
                this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
                GlStateManager.func_179097_i();
                this.func_73729_b(x, y, 0, 48, 18, 18);
                GlStateManager.func_179126_j();
                ItemStack stack = invoStacks[i];
                if (stack == null) continue;
                RenderUtils.RenderItemStack(this.field_146297_k, stack, x + 1, y + 1, "" + (stack.field_77994_a > 1 ? Integer.valueOf(stack.field_77994_a) : ""));
                FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
                if (!this.isWithin(mx, my, ipx + (int)((float)(x + 1) * scale), ipy + (int)((float)(y + 1) * scale), (int)(16.0f * scale), (int)(16.0f * scale), false) || fluidStack == null) continue;
                this.ttStack = fluidStack;
            }
            GlStateManager.func_179121_F();
        }
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
        this.searchBox.drawTextBox(mx, my, partialTick);
        this.numberBox.func_146194_f();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        this.doSearch();
        super.func_73863_a(mx, my, partialTick);
        if (this.ttStack != null) {
            ArrayList<String> tTip = new ArrayList<String>();
            tTip.add(this.ttStack.getLocalizedName());
            tTip.add(TextFormatting.GRAY + "" + this.ttStack.amount + " mB");
            this.drawTooltip(tTip, mx, my);
        }
    }

    @Override
    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && this.callback != null) {
            this.callback.setValue(this.stackSelect);
        }
        super.func_146284_a(button);
    }

    public void func_73864_a(int mx, int my, int type) throws IOException {
        FluidStack gStack = this.fluidGrid.getStackUnderMouse(mx, my);
        this.searchBox.func_146192_a(mx, my, type);
        this.numberBox.func_146192_a(mx, my, type);
        int btnWidth = this.sizeX / 2 - 16;
        int isx = 162;
        int isy = 72;
        float scale = Math.min((float)(btnWidth - 16) / (float)isx, ((float)this.sizeY / 2.0f - 32.0f) / (float)isy);
        int ipx = this.guiLeft + 16 + btnWidth / 2 - (int)((float)(isx / 2) * scale);
        int ipy = this.guiTop + this.sizeY / 2;
        if (gStack != null) {
            this.stackSelect = gStack.copy();
            this.numberBox.func_146180_a("" + this.stackSelect.amount);
        } else if (this.field_146297_k.field_71439_g != null && this.isWithin(mx, my, ipx, ipy, (int)(162.0f * scale), (int)(72.0f * scale), false)) {
            int idxSize = (int)(18.0f * scale);
            int sx = (mx - ipx) / idxSize;
            int sy = (my - ipy) / idxSize;
            int index = sx + sy * 9;
            if (index >= 0 && index < this.field_146297_k.field_71439_g.field_71071_by.field_70462_a.length) {
                FluidStack fluidStack;
                ItemStack invoStack = this.field_146297_k.field_71439_g.field_71071_by.field_70462_a[index];
                FluidStack fluidStack2 = fluidStack = invoStack == null ? null : FluidUtil.getFluidContained((ItemStack)invoStack);
                if (fluidStack != null) {
                    this.stackSelect = fluidStack.copy();
                    this.numberBox.func_146180_a("" + this.stackSelect.amount);
                }
            }
        } else if (!this.numberBox.func_146206_l() && this.stackSelect != null && this.stackSelect.amount != this.numberBox.getNumber().intValue()) {
            int i = Math.max(1, this.numberBox.getNumber().intValue());
            this.numberBox.func_146180_a("" + i);
            this.stackSelect.amount = i;
        }
        super.func_73864_a(mx, my, type);
    }

    public void doSearch() {
        if (this.searching == null) {
            return;
        }
        if (!this.searching.hasNext()) {
            this.searching = null;
            return;
        }
        int pass = 0;
        while (this.searching.hasNext() && pass < 256) {
            Fluid baseFluid = this.searching.next();
            if (baseFluid == null) continue;
            ++pass;
            if (baseFluid.getUnlocalizedName() == null || FluidRegistry.getDefaultFluidName((Fluid)baseFluid) == null || !baseFluid.getUnlocalizedName().toLowerCase().contains(this.searchTxt) && !I18n.func_135052_a((String)baseFluid.getUnlocalizedName(), (Object[])new Object[0]).toLowerCase().contains(this.searchTxt) && !FluidRegistry.getDefaultFluidName((Fluid)baseFluid).toLowerCase().contains(this.searchTxt)) continue;
            this.fluidGrid.getFluidList().add(new FluidStack(baseFluid, 1000));
        }
    }

    @Override
    protected void func_73869_a(char character, int num) throws IOException {
        super.func_73869_a(character, num);
        String prevTxt = this.searchBox.func_146179_b();
        this.searchBox.func_146201_a(character, num);
        this.numberBox.func_146201_a(character, num);
        if (!this.searchBox.func_146179_b().equalsIgnoreCase(prevTxt)) {
            this.fluidGrid.getFluidList().clear();
            this.searchTxt = this.searchBox.func_146179_b().toLowerCase();
            this.searching = FluidRegistry.getRegisteredFluids().values().iterator();
        }
    }
}

