/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.controls.GuiNumberField;
import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.editors.json.scrolling.GuiScrollingItemGrid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class GuiJsonItemSelection
extends GuiScreenThemed {
    private BigItemStack stackSelect;
    private ICallback<BigItemStack> callback;
    private GuiBigTextField searchBox;
    private GuiNumberField numberBox;
    private GuiButtonThemed btnOreDict;
    private int oreDictIdx = 0;
    private GuiScrollingItemGrid itemGrid;
    private BigItemStack ttStack = null;
    public String searchTxt = "";
    public Iterator<Item> searching = null;

    public GuiJsonItemSelection(GuiScreen parent, ICallback<BigItemStack> callback, BigItemStack stack) {
        super(parent, "betterquesting.title.select_item");
        this.stackSelect = stack;
        this.callback = callback;
        if (this.stackSelect == null) {
            this.stackSelect = new BigItemStack(Blocks.field_150348_b);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchBox = new GuiBigTextField(this.field_146289_q, this.guiLeft + this.sizeX / 2 + 9, this.guiTop + 33, this.sizeX / 2 - 26, 14);
        this.searchBox.setWatermark(I18n.func_135052_a((String)"betterquesting.gui.search", (Object[])new Object[0]));
        this.searchBox.func_146203_f(Integer.MAX_VALUE);
        this.itemGrid = new GuiScrollingItemGrid(this.field_146297_k, this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 48, this.sizeX / 2 - 24, this.sizeY - 80);
        this.embedded.add(this.itemGrid);
        this.numberBox = new GuiNumberField(this.field_146289_q, this.guiLeft + 77, this.guiTop + 49, 98, 14);
        if (this.stackSelect != null) {
            this.numberBox.func_146180_a("" + this.stackSelect.stackSize);
        }
        this.searching = Item.field_150901_e.iterator();
        this.btnOreDict = new GuiButtonThemed(3, this.guiLeft + 76, this.guiTop + 64, 100, 20, "OreDict: " + (this.stackSelect.oreDict.length() <= 0 ? "NONE" : this.stackSelect.oreDict), true);
        this.field_146292_n.add(this.btnOreDict);
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        super.drawBackPanel(mx, my, partialTick);
        this.ttStack = null;
        int btnWidth = this.sizeX / 2 - 16;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.selection", (Object[])new Object[0]), (float)(this.guiLeft + 24), (float)(this.guiTop + 36), this.getTextColor(), false);
        this.field_146289_q.func_175065_a("x", (float)(this.guiLeft + 65), (float)(this.guiTop + 52), this.getTextColor(), false);
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b((this.guiLeft + 24) / 2, (this.guiTop + 48) / 2, 0, 48, 18, 18);
        if (this.stackSelect != null) {
            GlStateManager.func_179126_j();
            RenderUtils.RenderItemStack(this.field_146297_k, this.stackSelect.getBaseStack(), (this.guiLeft + 26) / 2, (this.guiTop + 50) / 2, "");
            GlStateManager.func_179097_i();
            if (this.isWithin(mx, my, 25, 49, 32, 32)) {
                this.ttStack = this.stackSelect;
            }
        }
        GlStateManager.func_179121_F();
        this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), (float)(this.guiLeft + 24), (float)(this.guiTop + this.sizeY / 2 - 12), this.getTextColor(), false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_146297_k.field_71439_g != null) {
            ItemStack[] invoStacks = this.field_146297_k.field_71439_g.field_71071_by.field_70462_a;
            int isx = 162;
            int isy = 72;
            float scale = Math.min((float)(btnWidth - 16) / (float)isx, ((float)this.sizeY / 2.0f - 32.0f) / (float)isy);
            int ipx = this.guiLeft + 16 + btnWidth / 2 - (int)((float)(isx / 2) * scale);
            int ipy = this.guiTop + this.sizeY / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)ipx, (float)ipy, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            for (int i = 0; i < invoStacks.length && i < 36; ++i) {
                int x = i % 9 * 18;
                int y = (i - i % 9) / 9 * 18;
                this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179097_i();
                this.func_73729_b(x, y, 0, 48, 18, 18);
                GlStateManager.func_179126_j();
                ItemStack stack = invoStacks[i];
                if (stack == null) continue;
                RenderUtils.RenderItemStack(this.field_146297_k, stack, x + 1, y + 1, "" + (stack.field_77994_a > 1 ? Integer.valueOf(stack.field_77994_a) : ""));
                if (!this.isWithin(mx, my, ipx + (int)((float)(x + 1) * scale), ipy + (int)((float)(y + 1) * scale), (int)(16.0f * scale), (int)(16.0f * scale), false)) continue;
                this.ttStack = new BigItemStack(stack);
            }
            GlStateManager.func_179121_F();
        }
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
        this.searchBox.drawTextBox(mx, my, partialTick);
        this.numberBox.func_146194_f();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        this.doSearch();
        super.func_73863_a(mx, my, partialTick);
        if (this.ttStack != null) {
            GlStateManager.func_179094_E();
            try {
                this.drawHoveringText(this.ttStack.getBaseStack().func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x), mx, my, this.field_146289_q);
            }
            catch (Exception e) {
                this.ttStack = null;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && this.callback != null) {
            this.callback.setValue(this.stackSelect);
        } else if (button.field_146127_k == 3 && this.stackSelect != null) {
            int[] oreId = OreDictionary.getOreIDs((ItemStack)this.stackSelect.getBaseStack());
            ++this.oreDictIdx;
            if (oreId.length <= 0 || this.oreDictIdx >= oreId.length || this.oreDictIdx < -1) {
                this.oreDictIdx = -1;
                this.stackSelect.oreDict = "";
                button.field_146126_j = "OreDict: NONE";
            } else {
                this.oreDictIdx %= oreId.length;
                this.stackSelect.oreDict = OreDictionary.getOreName((int)oreId[this.oreDictIdx]);
                button.field_146126_j = "OreDict: " + this.stackSelect.oreDict;
            }
        }
        super.func_146284_a(button);
    }

    public void func_73864_a(int mx, int my, int type) throws IOException {
        ItemStack gStack = this.itemGrid.getStackUnderMouse(mx, my);
        this.searchBox.func_146192_a(mx, my, type);
        this.numberBox.func_146192_a(mx, my, type);
        int btnWidth = this.sizeX / 2 - 16;
        int isx = 162;
        int isy = 72;
        float scale = Math.min((float)(btnWidth - 16) / (float)isx, ((float)this.sizeY / 2.0f - 32.0f) / (float)isy);
        int ipx = this.guiLeft + 16 + btnWidth / 2 - (int)((float)(isx / 2) * scale);
        int ipy = this.guiTop + this.sizeY / 2;
        if (gStack != null) {
            this.stackSelect = new BigItemStack(gStack.func_77946_l());
            this.numberBox.func_146180_a("" + this.stackSelect.stackSize);
            this.oreDictIdx = -1;
            this.btnOreDict.field_146126_j = "OreDict: NONE";
            return;
        }
        if (this.field_146297_k.field_71439_g != null && this.isWithin(mx, my, ipx, ipy, (int)(162.0f * scale), (int)(72.0f * scale), false)) {
            ItemStack invoStack;
            int idxSize = (int)(18.0f * scale);
            int sx = (mx - ipx) / idxSize;
            int sy = (my - ipy) / idxSize;
            int index = sx + sy * 9;
            if (index >= 0 && index < this.field_146297_k.field_71439_g.field_71071_by.field_70462_a.length && (invoStack = this.field_146297_k.field_71439_g.field_71071_by.field_70462_a[index]) != null) {
                this.stackSelect = new BigItemStack(invoStack.func_77946_l());
                this.numberBox.func_146180_a("" + this.stackSelect.stackSize);
                this.oreDictIdx = -1;
                this.btnOreDict.field_146126_j = "OreDict: NONE";
            }
            return;
        }
        if (!this.numberBox.func_146206_l() && this.stackSelect != null && this.stackSelect.stackSize != this.numberBox.getNumber().intValue()) {
            int i = Math.max(1, this.numberBox.getNumber().intValue());
            this.numberBox.func_146180_a("" + i);
            this.stackSelect.stackSize = i;
        }
        super.func_73864_a(mx, my, type);
    }

    public void doSearch() {
        if (this.searching == null) {
            return;
        }
        if (!this.searching.hasNext()) {
            this.searching = null;
            return;
        }
        int pass = 0;
        while (this.searching.hasNext() && pass < 256) {
            Item baseItem = this.searching.next();
            if (baseItem == null) continue;
            ++pass;
            ArrayList<ItemStack> subList = new ArrayList<ItemStack>();
            if (baseItem == Items.field_151134_bR) {
                for (Enchantment enchant : Enchantment.field_185264_b) {
                    if (enchant == null) continue;
                    Items.field_151134_bR.func_92113_a(enchant, subList);
                }
            } else {
                try {
                    baseItem.func_150895_a(baseItem, CreativeTabs.field_78027_g, subList);
                }
                catch (Exception e) {
                    subList.add(new ItemStack(baseItem));
                }
            }
            if (baseItem.func_77658_a() == null || Item.field_150901_e.func_177774_c((Object)baseItem) == null) continue;
            if (baseItem.func_77658_a().toLowerCase().contains(this.searchTxt) || I18n.func_135052_a((String)baseItem.func_77658_a(), (Object[])new Object[0]).toLowerCase().contains(this.searchTxt) || ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)baseItem)).toString().toLowerCase().contains(this.searchTxt)) {
                this.itemGrid.getItemList().addAll(subList);
                continue;
            }
            for (ItemStack subItem : subList) {
                try {
                    if (subItem == null || subItem.func_77977_a() == null) continue;
                    if (subItem.func_77977_a().toLowerCase().contains(this.searchTxt) || subItem.func_82833_r().toLowerCase().contains(this.searchTxt)) {
                        this.itemGrid.getItemList().add(subItem);
                        continue;
                    }
                    List toolTips = subItem.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
                    for (String line : toolTips) {
                        if (!line.toLowerCase().contains(this.searchTxt)) continue;
                        this.itemGrid.getItemList().add(subItem);
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    protected void func_73869_a(char character, int num) throws IOException {
        super.func_73869_a(character, num);
        String prevTxt = this.searchBox.func_146179_b();
        this.searchBox.func_146201_a(character, num);
        this.numberBox.func_146201_a(character, num);
        if (!this.searchBox.func_146179_b().equalsIgnoreCase(prevTxt)) {
            this.itemGrid.getItemList().clear();
            this.searchTxt = this.searchBox.func_146179_b().toLowerCase();
            this.searching = Item.field_150901_e.iterator();
        }
    }
}

