/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonJson;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.controls.GuiNumberField;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.client.gui.editors.json.GuiJsonAdd;
import betterquesting.client.gui.editors.json.GuiJsonArray;
import betterquesting.client.gui.editors.json.GuiJsonTypeMenu;
import betterquesting.client.gui.editors.json.JsonControlSet;
import betterquesting.client.gui.editors.json.TextCallbackJsonObject;
import betterquesting.core.BetterQuesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;

@Deprecated
@SideOnly(value=Side.CLIENT)
public class GuiJsonObject
extends GuiScreenThemed
implements IVolatileScreen {
    private int scrollPos = 0;
    private int maxRows = 0;
    private final JsonObject settings;
    private boolean allowEdit = true;
    private IJsonDoc jdoc = null;
    private HashMap<String, JsonControlSet> editables = new HashMap();

    @Deprecated
    public GuiJsonObject(GuiScreen parent, JsonObject settings) {
        this(parent, settings, null);
    }

    public GuiJsonObject(GuiScreen parent, JsonObject settings, IJsonDoc jdoc) {
        super(parent, "betterquesting.title.json_object");
        this.settings = settings;
        this.jdoc = jdoc;
    }

    public GuiJsonObject SetEditMode(boolean state) {
        this.allowEdit = state;
        return this;
    }

    @Override
    public void func_73866_w_() {
        String lTitle;
        String ulTitle;
        super.func_73866_w_();
        if (this.jdoc != null && !(ulTitle = this.jdoc.getUnlocalisedTitle()).equals(lTitle = I18n.func_135052_a((String)ulTitle, (Object[])new Object[0]))) {
            this.setTitle(I18n.func_135052_a((String)this.jdoc.getUnlocalisedTitle(), (Object[])new Object[0]));
        }
        this.editables = new HashMap();
        this.maxRows = (this.sizeY - 84) / 20;
        ((GuiButton)this.field_146292_n.get((int)0)).field_146128_h = this.field_146294_l / 2 - 100;
        ((GuiButton)this.field_146292_n.get((int)0)).field_146120_f = 100;
        this.field_146292_n.add(new GuiButtonThemed(1, this.field_146294_l / 2, this.guiTop + this.sizeY - 16, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.new", (Object[])new Object[0]), true));
        this.field_146292_n.add(new GuiButtonThemed(2, this.field_146294_l / 2, this.guiTop + 32 + this.maxRows * 20, 20, 20, "<", true));
        this.field_146292_n.add(new GuiButtonThemed(3, this.guiLeft + this.sizeX - 36, this.guiTop + 32 + this.maxRows * 20, 20, 20, ">", true));
        Keyboard.enableRepeatEvents((boolean)true);
        for (Map.Entry entry : this.settings.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                GuiTextField txtBox;
                JsonPrimitive jPrim = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                if (jPrim.isNumber()) {
                    txtBox = new GuiNumberField(this.field_146289_q, 32, -9999, 128, 16);
                    txtBox.func_146180_a("" + jPrim.getAsNumber());
                } else {
                    if (jPrim.isBoolean()) {
                        GuiButtonJson<JsonPrimitive> button = new GuiButtonJson<JsonPrimitive>(this.field_146292_n.size(), -9999, -9999, 128, 20, jPrim, true);
                        this.field_146292_n.add(button);
                        this.editables.put((String)entry.getKey(), new JsonControlSet(this.field_146292_n, button, false, this.allowEdit));
                        continue;
                    }
                    txtBox = new GuiBigTextField(this.field_146289_q, 32, -9999, 128, 16).enableBigEdit(new TextCallbackJsonObject(this.settings, (String)entry.getKey()));
                    txtBox.func_146203_f(Integer.MAX_VALUE);
                    txtBox.func_146180_a(jPrim.getAsString());
                }
                this.editables.put((String)entry.getKey(), new JsonControlSet(this.field_146292_n, txtBox, false, this.allowEdit));
                continue;
            }
            GuiButtonJson<JsonElement> button = new GuiButtonJson<JsonElement>(this.field_146292_n.size(), -9999, -9999, 128, 20, (JsonElement)entry.getValue(), true);
            this.field_146292_n.add(button);
            this.editables.put((String)entry.getKey(), new JsonControlSet(this.field_146292_n, button, false, this.allowEdit));
        }
    }

    @Override
    public void func_146284_a(GuiButton button) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (button.field_146127_k != 0) break block5;
                            this.field_146297_k.func_147108_a(this.parent);
                            break block6;
                        }
                        if (button.field_146127_k != 1) break block7;
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonAdd((GuiScreen)this, this.settings));
                        break block6;
                    }
                    if (button.field_146127_k != 2) break block8;
                    this.scrollPos = this.scrollPos > 0 ? --this.scrollPos : 0;
                    break block6;
                }
                if (button.field_146127_k != 3) break block9;
                int maxShow = (this.sizeY - 84) / 20;
                if ((this.scrollPos + 1) * maxShow >= this.editables.size()) break block6;
                ++this.scrollPos;
                break block6;
            }
            for (String key : this.editables.keySet()) {
                IJsonDoc childDoc;
                JsonControlSet controls = this.editables.get(key);
                if (controls == null) continue;
                if (button == controls.removeButton) {
                    this.settings.remove(key);
                    this.field_146292_n.remove(controls.jsonDisplay);
                    this.field_146292_n.remove(controls.addButton);
                    this.field_146292_n.remove(controls.removeButton);
                    this.editables.remove(key);
                    break;
                }
                if (button != controls.jsonDisplay || !(button instanceof GuiButtonJson)) continue;
                GuiButtonJson jsonButton = (GuiButtonJson)button;
                Object element = jsonButton.getStored();
                IJsonDoc iJsonDoc = childDoc = this.jdoc == null ? null : this.jdoc.getChildDoc(key);
                if (jsonButton.isItem() || jsonButton.isEntity() || jsonButton.isFluid()) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonTypeMenu((GuiScreen)this, element.getAsJsonObject()));
                    break;
                }
                if (element.isJsonObject()) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonObject(this, element.getAsJsonObject(), childDoc).SetEditMode(this.allowEdit));
                    break;
                }
                if (element.isJsonArray()) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonArray(this, element.getAsJsonArray(), childDoc).SetEditMode(this.allowEdit));
                    break;
                }
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isBoolean()) break;
                JsonPrimitive jBool = new JsonPrimitive(Boolean.valueOf(!element.getAsBoolean()));
                this.settings.add(key, (JsonElement)jBool);
                jsonButton.field_146126_j = "" + jBool.getAsBoolean();
                jsonButton.setStored(jBool);
                break;
            }
        }
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        super.func_73863_a(mx, my, partialTick);
        String[] keys = this.editables.keySet().toArray(new String[0]);
        String keyDesc = null;
        for (int i = 0; i < keys.length; ++i) {
            String ulKey;
            String lKey;
            JsonControlSet controls = this.editables.get(keys[i]);
            if (controls == null) continue;
            int n = i - this.scrollPos * this.maxRows;
            int posX = this.guiLeft + this.sizeX / 2;
            int posY = -9999;
            if (n < 0 || n >= this.maxRows) {
                controls.Disable();
                continue;
            }
            posY = this.guiTop + 32 + n * 20;
            controls.drawControls(this, posX, posY, this.sizeX / 2 - 16, 20, mx, my, partialTick);
            String keyName = keys[i];
            if (this.jdoc != null && !(lKey = I18n.func_135052_a((String)(ulKey = this.jdoc.getUnlocalisedName(keys[i])), (Object[])new Object[0])).equalsIgnoreCase(ulKey)) {
                keyName = lKey;
                if (this.isWithin(mx, my, this.guiLeft, posY, this.sizeX / 2, 20, false)) {
                    keyDesc = I18n.func_135052_a((String)this.jdoc.getUnlocalisedDesc(keys[i]), (Object[])new Object[0]);
                }
            }
            this.field_146289_q.func_175065_a(keyName, (float)(this.guiLeft + this.sizeX / 2 - this.field_146289_q.func_78256_a(keyName) - 8), (float)(posY + 4), this.getTextColor(), false);
        }
        int mxPage = Math.max(MathHelper.func_76123_f((float)((float)this.editables.size() / (float)this.maxRows)), 1);
        String txt = this.scrollPos + 1 + "/" + mxPage;
        this.field_146289_q.func_78276_b(txt, this.guiLeft + 16 + (this.sizeX - 32) / 4 * 3 - this.field_146289_q.func_78256_a(txt) / 2, this.guiTop + 32 + this.maxRows * 20 + 6, this.getTextColor());
        if (keyDesc != null) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(keyDesc);
            this.drawTooltip(tooltip, mx, my);
        }
    }

    public void func_73864_a(int x, int y, int type) throws IOException {
        super.func_73864_a(x, y, type);
        for (JsonControlSet controls : this.editables.values()) {
            controls.mouseClick(this, x, y, type);
        }
    }

    @Override
    protected void func_73869_a(char character, int num) throws IOException {
        super.func_73869_a(character, num);
        for (Map.Entry<String, JsonControlSet> entry : this.editables.entrySet()) {
            if (!(entry.getValue().jsonDisplay instanceof GuiTextField)) continue;
            GuiTextField textField = (GuiTextField)entry.getValue().jsonDisplay;
            textField.func_146201_a(character, num);
            if (this.settings.getAsJsonPrimitive(entry.getKey()).isNumber()) {
                if (textField instanceof GuiNumberField) {
                    this.settings.add(entry.getKey(), (JsonElement)new JsonPrimitive(((GuiNumberField)textField).getNumber()));
                    continue;
                }
                try {
                    this.settings.add(entry.getKey(), (JsonElement)new JsonPrimitive(NumberFormat.getInstance().parse(textField.func_146179_b())));
                }
                catch (Exception e) {
                    BetterQuesting.logger.log(Level.ERROR, "Unable to parse number format for JsonObject!", (Throwable)e);
                    this.settings.add(entry.getKey(), (JsonElement)new JsonPrimitive(textField.func_146179_b()));
                }
                continue;
            }
            this.settings.add(entry.getKey(), (JsonElement)new JsonPrimitive(textField.func_146179_b()));
        }
    }
}

