/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.client.gui.editors.json.GuiJsonEntitySelection;
import betterquesting.client.gui.editors.json.GuiJsonFluidSelection;
import betterquesting.client.gui.editors.json.GuiJsonItemSelection;
import betterquesting.client.gui.editors.json.callback.JsonEntityCallback;
import betterquesting.client.gui.editors.json.callback.JsonFluidCallback;
import betterquesting.client.gui.editors.json.callback.JsonItemCallback;
import betterquesting.client.gui.editors.json.scrolling.GuiJsonEditor;
import com.google.gson.JsonObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiJsonTypeMenu
extends GuiScreenThemed
implements IVolatileScreen {
    private final JsonObject json;
    private FluidStack fluid;
    private BigItemStack stack;
    private Entity entity;
    private EditType lastType = EditType.NONE;
    private JsonItemCallback itemCallback;
    private JsonFluidCallback fluidCallback;
    private JsonEntityCallback entityCallback;

    public GuiJsonTypeMenu(GuiScreen parent, JsonObject json) {
        super(parent, "betterquesting.title.json_object");
        this.json = json;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.fluid = null;
        this.stack = null;
        this.entity = null;
        if (this.json != null) {
            if (JsonHelper.isItem(this.json)) {
                this.stack = JsonHelper.JsonToItemStack(this.json);
            }
            if (this.stack == null && JsonHelper.isEntity(this.json)) {
                this.entity = EntityList.func_75615_a((NBTTagCompound)NBTConverter.JSONtoNBT_Object(this.json.getAsJsonObject(), new NBTTagCompound(), true), (World)Minecraft.func_71410_x().field_71441_e);
            }
            if (this.stack == null && this.entity == null && JsonHelper.isFluid(this.json)) {
                this.fluid = JsonHelper.JsonToFluidStack(this.json);
            }
        } else {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        if (this.stack == null) {
            this.stack = new BigItemStack(Blocks.field_150348_b);
        }
        if (this.entity == null) {
            this.entity = new EntityPig((World)Minecraft.func_71410_x().field_71441_e);
        }
        if (this.fluid == null) {
            this.fluid = new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (this.lastType == EditType.ITEM) {
            this.json.entrySet().clear();
            JsonHelper.ItemStackToJson(this.stack, this.json);
        } else if (this.lastType == EditType.FLUID) {
            this.json.entrySet().clear();
            JsonHelper.FluidStackToJson(this.fluid, this.json);
        } else if (this.lastType == EditType.ENTITY) {
            this.json.entrySet().clear();
            JsonHelper.EntityToJson(this.entity, this.json);
        }
        if (this.lastType != EditType.NONE) {
            this.field_146297_k.func_147108_a(this.parent);
        }
        GuiButtonThemed editButton = new GuiButtonThemed(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 40, 200, 20, I18n.func_135052_a((String)"betterquesting.btn.raw_nbt", (Object[])new Object[0]), true);
        GuiButtonThemed itemButton = new GuiButtonThemed(1, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 20, 200, 20, I18n.func_135052_a((String)"betterquesting.btn.item", (Object[])new Object[0]), true);
        GuiButtonThemed fluidButton = new GuiButtonThemed(4, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 0, 200, 20, I18n.func_135052_a((String)"betterquesting.btn.fluid", (Object[])new Object[0]), true);
        GuiButtonThemed entityButton = new GuiButtonThemed(2, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 20, 200, 20, I18n.func_135052_a((String)"betterquesting.btn.entity", (Object[])new Object[0]), true);
        this.field_146292_n.add(itemButton);
        this.field_146292_n.add(entityButton);
        this.field_146292_n.add(editButton);
        this.field_146292_n.add(fluidButton);
        this.itemCallback = new JsonItemCallback(this.json, this.stack);
        this.fluidCallback = new JsonFluidCallback(this.json, this.fluid);
        this.entityCallback = new JsonEntityCallback(this.json, this.entity);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            this.lastType = EditType.ITEM;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonItemSelection(this, this.itemCallback, this.stack));
        } else if (button.field_146127_k == 2) {
            this.lastType = EditType.ENTITY;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonEntitySelection(this, this.entityCallback, this.entity));
        } else if (button.field_146127_k == 3) {
            this.lastType = EditType.NONE;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonEditor((GuiScreen)this, this.json, null));
        } else if (button.field_146127_k == 4) {
            this.lastType = EditType.FLUID;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonFluidSelection(this, this.fluidCallback, this.fluid));
        } else {
            this.lastType = EditType.NONE;
            super.func_146284_a(button);
        }
    }

    static enum EditType {
        NONE,
        ITEM,
        ENTITY,
        FLUID;

    }
}

