/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json.callback;

import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.JsonHelper;
import com.google.gson.JsonObject;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class JsonFluidCallback
implements ICallback<FluidStack> {
    private FluidStack baseStack = new FluidStack(FluidRegistry.WATER, 1000);
    private final JsonObject json;

    public JsonFluidCallback(JsonObject json) {
        this(json, new FluidStack(FluidRegistry.WATER, 1000));
    }

    public JsonFluidCallback(JsonObject json, FluidStack stack) {
        this.json = json;
        this.baseStack = stack;
    }

    @Override
    public void setValue(FluidStack stack) {
        this.baseStack = stack != null ? stack : new FluidStack(FluidRegistry.WATER, 1000);
        this.json.entrySet().clear();
        JsonHelper.FluidStackToJson(this.baseStack, this.json);
    }

    public JsonObject getJsonObject() {
        return this.json;
    }

    public FluidStack getFluidStack() {
        return this.baseStack;
    }
}

