/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json.scrolling;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.misc.ICallback;
import betterquesting.client.gui.editors.json.scrolling.GuiScrollingJson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class GuiJsonEditor
extends GuiScreenThemed {
    private final JsonElement json;
    private final IJsonDoc jDoc;
    private ICallback<JsonObject> joCallback;
    private ICallback<JsonArray> jaCallback;

    public GuiJsonEditor(GuiScreen parent, JsonObject json, IJsonDoc jDoc) {
        this(parent, json, jDoc, null);
    }

    public GuiJsonEditor(GuiScreen parent, JsonObject json, IJsonDoc jDoc, ICallback<JsonObject> callback) {
        super(parent, "betterquesting.title.json_object");
        this.json = json;
        this.jDoc = jDoc;
        this.joCallback = callback;
    }

    public GuiJsonEditor(GuiScreen parent, JsonArray json, IJsonDoc jDoc) {
        this(parent, json, jDoc, null);
    }

    public GuiJsonEditor(GuiScreen parent, JsonArray json, IJsonDoc jDoc, ICallback<JsonArray> callback) {
        super(parent, "betterquesting.title.json_array");
        this.json = json;
        this.jDoc = jDoc;
        this.jaCallback = callback;
    }

    @Override
    public void func_73866_w_() {
        String lTitle;
        String ulTitle;
        super.func_73866_w_();
        if (this.jDoc != null && !(ulTitle = this.jDoc.getUnlocalisedTitle()).equals(lTitle = I18n.func_135052_a((String)ulTitle, (Object[])new Object[0]))) {
            this.setTitle(I18n.func_135052_a((String)this.jDoc.getUnlocalisedTitle(), (Object[])new Object[0]));
        }
        GuiScrollingJson gsj = new GuiScrollingJson(this.field_146297_k, this.guiLeft + 16, this.guiTop + 32, this.sizeX - 32, this.sizeY - 64);
        if (this.json.isJsonObject()) {
            gsj.setJson(this.json.getAsJsonObject(), this.jDoc);
        } else {
            gsj.setJson(this.json.getAsJsonArray(), this.jDoc);
        }
        gsj.refresh();
        this.embedded.add(gsj);
    }

    @Override
    public void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn.field_146127_k == 0) {
            if (this.json.isJsonObject() && this.joCallback != null) {
                this.joCallback.setValue(this.json.getAsJsonObject());
            } else if (this.json.isJsonArray() && this.jaCallback != null) {
                this.jaCallback.setValue(this.json.getAsJsonArray());
            }
        }
    }
}

