/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json.scrolling;

import betterquesting.api.client.gui.lists.GuiScrollingBase;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.client.gui.editors.json.scrolling.ScrollingJsonEntry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class GuiScrollingJson
extends GuiScrollingBase<ScrollingJsonEntry> {
    private JsonElement json;
    private boolean allowEdit = true;
    private IJsonDoc jDoc;
    private int posX;

    public GuiScrollingJson(Minecraft mc, int x, int y, int w, int h) {
        super(mc, x, y, w, h);
        this.posX = x;
    }

    public GuiScrollingJson setEditMode(boolean allowEdit) {
        this.allowEdit = allowEdit;
        return this;
    }

    public GuiScrollingJson setJson(JsonObject json, IJsonDoc jDoc) {
        this.jDoc = jDoc;
        this.setJsonInternal((JsonElement)json);
        return this;
    }

    public GuiScrollingJson setJson(JsonArray json, IJsonDoc jDoc) {
        this.jDoc = jDoc;
        this.setJsonInternal((JsonElement)json);
        return this;
    }

    private void setJsonInternal(JsonElement json) {
        this.json = json;
        this.refresh();
    }

    @Override
    public void onKeyTyped(char c, int keyCode) {
        super.onKeyTyped(c, keyCode);
        for (int i = this.getEntryList().size() - 1; i >= 0; --i) {
            ScrollingJsonEntry sje = (ScrollingJsonEntry)this.getEntryList().get(i);
            sje.onKeyTyped(c, keyCode);
        }
    }

    public void refresh() {
        if (this.json == null) {
            return;
        }
        int width = this.getListWidth();
        this.getEntryList().clear();
        if (this.json.isJsonArray()) {
            JsonArray ja = this.json.getAsJsonArray();
            for (int i = 0; i < ja.size(); ++i) {
                ScrollingJsonEntry sje = new ScrollingJsonEntry(this, ja, i, this.jDoc, this.allowEdit);
                sje.setupEntry(this.posX, width);
                this.getEntryList().add(sje);
            }
            ScrollingJsonEntry sje = new ScrollingJsonEntry(this, ja, ja.size(), null, this.allowEdit);
            sje.setupEntry(this.posX, width);
            this.getEntryList().add(sje);
        } else if (this.json.isJsonObject()) {
            JsonObject jo = this.json.getAsJsonObject();
            for (Map.Entry entry : jo.entrySet()) {
                ScrollingJsonEntry sje = new ScrollingJsonEntry(this, jo, (String)entry.getKey(), this.jDoc, this.allowEdit);
                sje.setupEntry(this.posX, width);
                this.getEntryList().add(sje);
            }
            ScrollingJsonEntry sje = new ScrollingJsonEntry(this, jo, "", null, this.allowEdit);
            sje.setupEntry(this.posX, width);
            this.getEntryList().add(sje);
        }
    }
}

