/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json.scrolling;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.lists.IScrollingEntry;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class ScrollingFluidGrid
extends GuiElement
implements IScrollingEntry {
    private final List<FluidStack> itemList = new ArrayList<FluidStack>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private int posX = 0;
    private int posY = 0;
    private int columns = 1;
    private int rows = 1;
    private int upperBounds = 0;
    private int lowerBounds = 0;

    public ScrollingFluidGrid(int top, int bottom) {
        this.upperBounds = top;
        this.lowerBounds = bottom;
    }

    public List<FluidStack> getFluidList() {
        return this.itemList;
    }

    @Override
    public void drawBackground(int mx, int my, int px, int py, int width) {
        this.posX = px;
        this.posY = py;
        if (this.itemList.size() < 0) {
            return;
        }
        this.columns = Math.max(1, width / 18);
        this.rows = MathHelper.func_76123_f((float)((float)this.itemList.size() / (float)this.columns));
        int sr = (this.upperBounds - py) / 18;
        int er = MathHelper.func_76123_f((float)((float)(this.lowerBounds - py) / 18.0f));
        for (int j = sr; j < this.rows && j < er; ++j) {
            int idx;
            for (int i = 0; i < this.columns && (idx = j * this.columns + i) < this.itemList.size(); ++i) {
                FluidStack stack = this.itemList.get(idx);
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.field_71446_o.func_110577_a(ScrollingFluidGrid.currentTheme().getGuiTexture());
                this.drawTexturedModalRect(px + i * 18, py + j * 18, 0, 48, 18, 18);
                GlStateManager.func_179126_j();
                try {
                    this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                    TextureAtlasSprite fluidTx = this.mc.func_147117_R().func_110572_b(stack.getFluid().getStill().toString());
                    fluidTx = fluidTx != null ? fluidTx : this.mc.func_147117_R().func_110572_b("missingno");
                    this.drawTexturedModelRectFromIcon(px + i * 18 + 1, py + j * 18 + 1, fluidTx, 16, 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GlStateManager.func_179097_i();
                GlStateManager.func_179121_F();
            }
        }
    }

    @Override
    public void drawForeground(int mx, int my, int px, int py, int width) {
        FluidStack stack = this.getStackUnderMouse(mx, my);
        if (stack != null) {
            ArrayList<String> tt = new ArrayList<String>();
            tt.add(stack.getLocalizedName());
            tt.add(ChatFormatting.GRAY + "" + stack.amount + "mB");
            this.drawTooltip(tt, mx, my, this.mc.field_71466_p);
        }
    }

    @Override
    public void onMouseClick(int mx, int my, int px, int py, int click, int index) {
    }

    public FluidStack getStackUnderMouse(int mx, int my) {
        int idx = this.mouseToIndex(mx, my);
        if (idx < 0 || idx >= this.itemList.size()) {
            return null;
        }
        return this.itemList.get(idx);
    }

    private int mouseToIndex(int mx, int my) {
        int ii = (mx - this.posX) / 18;
        int jj = (my - this.posY) / 18;
        if (ii >= this.columns || jj >= this.rows) {
            return -1;
        }
        return jj * this.columns + ii;
    }

    @Override
    public int getHeight() {
        return this.rows * 18;
    }

    @Override
    public boolean canDrawOutsideBox(boolean isForeground) {
        return isForeground;
    }
}

