/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json.scrolling;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.lists.IScrollingEntry;
import betterquesting.api.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class ScrollingItemGrid
extends GuiElement
implements IScrollingEntry {
    private final List<ItemStack> itemList = new ArrayList<ItemStack>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private int posX = 0;
    private int posY = 0;
    private int columns = 1;
    private int rows = 1;
    private int upperBounds = 0;
    private int lowerBounds = 0;

    public ScrollingItemGrid(int top, int bottom) {
        this.upperBounds = top;
        this.lowerBounds = bottom;
    }

    public List<ItemStack> getItemList() {
        return this.itemList;
    }

    @Override
    public void drawBackground(int mx, int my, int px, int py, int width) {
        this.posX = px;
        this.posY = py;
        if (this.itemList.size() < 0) {
            return;
        }
        this.columns = Math.max(1, width / 18);
        this.rows = MathHelper.func_76123_f((float)((float)this.itemList.size() / (float)this.columns));
        int sr = (this.upperBounds - py) / 18;
        int er = MathHelper.func_76123_f((float)((float)(this.lowerBounds - py) / 18.0f));
        for (int j = sr; j < this.rows && j < er; ++j) {
            int idx;
            for (int i = 0; i < this.columns && (idx = j * this.columns + i) < this.itemList.size(); ++i) {
                ItemStack stack = this.itemList.get(idx);
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.field_71446_o.func_110577_a(ScrollingItemGrid.currentTheme().getGuiTexture());
                this.drawTexturedModalRect(px + i * 18, py + j * 18, 0, 48, 18, 18);
                GlStateManager.func_179126_j();
                RenderUtils.RenderItemStack(this.mc, stack, px + i * 18 + 1, py + j * 18 + 1, stack.field_77994_a > 1 ? "" + stack.field_77994_a : "");
                GlStateManager.func_179097_i();
                GlStateManager.func_179121_F();
            }
        }
    }

    @Override
    public void drawForeground(int mx, int my, int px, int py, int width) {
        ItemStack stack = this.getStackUnderMouse(mx, my);
        if (stack != null) {
            this.drawTooltip(stack.func_82840_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71474_y.field_82882_x), mx, my, this.mc.field_71466_p);
        }
    }

    @Override
    public void onMouseClick(int mx, int my, int px, int py, int click, int index) {
    }

    public ItemStack getStackUnderMouse(int mx, int my) {
        int idx = this.mouseToIndex(mx, my);
        if (idx < 0 || idx >= this.itemList.size()) {
            return null;
        }
        return this.itemList.get(idx);
    }

    private int mouseToIndex(int mx, int my) {
        int ii = (mx - this.posX) / 18;
        int jj = (my - this.posY) / 18;
        if (ii >= this.columns || jj >= this.rows) {
            return -1;
        }
        return jj * this.columns + ii;
    }

    @Override
    public int getHeight() {
        return this.rows * 18;
    }

    @Override
    public boolean canDrawOutsideBox(boolean isForeground) {
        return isForeground;
    }
}

