/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.json.scrolling;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonJson;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.controls.GuiNumberField;
import betterquesting.api.client.gui.lists.IScrollingEntry;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.utils.JsonHelper;
import betterquesting.client.gui.editors.json.GuiJsonAdd;
import betterquesting.client.gui.editors.json.GuiJsonEntitySelection;
import betterquesting.client.gui.editors.json.GuiJsonFluidSelection;
import betterquesting.client.gui.editors.json.GuiJsonItemSelection;
import betterquesting.client.gui.editors.json.GuiJsonTypeMenu;
import betterquesting.client.gui.editors.json.TextCallbackJsonArray;
import betterquesting.client.gui.editors.json.TextCallbackJsonObject;
import betterquesting.client.gui.editors.json.callback.JsonEntityCallback;
import betterquesting.client.gui.editors.json.callback.JsonFluidCallback;
import betterquesting.client.gui.editors.json.callback.JsonItemCallback;
import betterquesting.client.gui.editors.json.scrolling.GuiJsonEditor;
import betterquesting.client.gui.editors.json.scrolling.GuiScrollingJson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ScrollingJsonEntry
extends GuiElement
implements IScrollingEntry {
    private final GuiScrollingJson host;
    private final JsonElement json;
    private final IJsonDoc jDoc;
    private String name = "";
    private String desc = "";
    private String key = "";
    private int idx = -1;
    private JsonElement je;
    private boolean allowEdit = true;
    private GuiTextField txtMain;
    private GuiButtonThemed btnMain;
    private GuiButtonThemed btnAdv;
    private GuiButtonThemed btnAdd;
    private GuiButtonThemed btnDel;
    private final Minecraft mc;
    private List<GuiButtonThemed> btnList = new ArrayList<GuiButtonThemed>();

    public ScrollingJsonEntry(GuiScrollingJson host, JsonObject json, String key, IJsonDoc jDoc, boolean allowEdit) {
        String uln;
        String ln;
        this.mc = Minecraft.func_71410_x();
        this.host = host;
        this.json = json;
        this.key = key;
        this.jDoc = jDoc;
        this.name = key;
        if (jDoc != null && !(ln = I18n.func_135052_a((String)(uln = jDoc.getUnlocalisedName(this.name)), (Object[])new Object[0])).equalsIgnoreCase(uln)) {
            this.name = ln;
            this.desc = jDoc == null ? "" : I18n.func_135052_a((String)jDoc.getUnlocalisedDesc(key), (Object[])new Object[0]);
        }
        this.je = json.get(key);
        this.allowEdit = allowEdit;
    }

    public ScrollingJsonEntry(GuiScrollingJson host, JsonArray json, int index, IJsonDoc jDoc, boolean allowEdit) {
        this.mc = Minecraft.func_71410_x();
        this.host = host;
        this.json = json;
        this.idx = index;
        this.jDoc = jDoc;
        this.je = index < 0 || index >= json.size() ? null : json.get(index);
        this.allowEdit = allowEdit;
        this.name = this.je == null ? "" : "#" + index;
    }

    public void setupEntry(int px, int width) {
        this.btnList.clear();
        int margin = px + width / 3;
        int ctrlSpace = MathHelper.func_76123_f((float)((float)width / 3.0f * 2.0f));
        int n = 0;
        if (this.allowEdit && this.je != null) {
            n = 20;
            this.btnDel = new GuiButtonThemed(3, px + width - n, 0, 20, 20, "x");
            this.btnDel.packedFGColour = Color.RED.getRGB();
            this.btnList.add(this.btnDel);
        }
        if (this.allowEdit) {
            n = 40;
            this.btnAdd = new GuiButtonThemed(2, px + width - n, 0, 20, 20, "+");
            this.btnAdd.packedFGColour = Color.GREEN.getRGB();
            this.btnList.add(this.btnAdd);
        }
        if (this.je == null) {
            return;
        }
        if (this.je.isJsonArray()) {
            this.btnMain = new GuiButtonJson<JsonArray>(0, margin, 0, ctrlSpace - n, 20, this.je.getAsJsonArray(), false);
            this.btnList.add(this.btnMain);
        } else if (this.je.isJsonObject()) {
            JsonObject jo = this.je.getAsJsonObject();
            if (JsonHelper.isItem(jo) || JsonHelper.isFluid(jo) || JsonHelper.isEntity(jo)) {
                this.btnAdv = new GuiButtonThemed(1, px + width - (n += 20), 0, 20, 20, "...");
                this.btnList.add(this.btnAdv);
            }
            this.btnMain = new GuiButtonJson<JsonObject>(0, margin, 0, ctrlSpace - n, 20, this.je.getAsJsonObject(), false);
            this.btnList.add(this.btnMain);
        } else if (this.je.isJsonPrimitive()) {
            JsonPrimitive jp = this.je.getAsJsonPrimitive();
            if (jp.isBoolean()) {
                this.btnMain = new GuiButtonJson<JsonPrimitive>(0, margin, 0, ctrlSpace - n, 20, jp, false);
                this.btnList.add(this.btnMain);
            } else if (jp.isNumber()) {
                GuiNumberField num = new GuiNumberField(this.mc.field_71466_p, margin + 1, 0, ctrlSpace - n - 2, 18);
                num.func_146203_f(Integer.MAX_VALUE);
                num.func_146180_a(jp.getAsNumber().toString());
                this.txtMain = num;
            } else {
                GuiBigTextField txt = new GuiBigTextField(this.mc.field_71466_p, margin + 1, 1, ctrlSpace - n - 2, 18);
                txt.func_146203_f(Integer.MAX_VALUE);
                txt.func_146180_a(jp.getAsString());
                if (this.json.isJsonObject()) {
                    txt.enableBigEdit(new TextCallbackJsonObject(this.json.getAsJsonObject(), this.key));
                } else if (this.json.isJsonArray()) {
                    txt.enableBigEdit(new TextCallbackJsonArray(this.json.getAsJsonArray(), this.idx));
                }
                this.txtMain = txt;
            }
        }
    }

    @Override
    public void drawBackground(int mx, int my, int px, int py, int width) {
        int margin = px + width / 3;
        for (GuiButtonThemed btn : this.btnList) {
            btn.field_146129_i = py;
            btn.func_146112_a(this.mc, mx, my);
        }
        if (this.txtMain != null) {
            this.txtMain.field_146210_g = py + 1;
            this.txtMain.func_146194_f();
        }
        int length = this.mc.field_71466_p.func_78256_a(this.name);
        this.mc.field_71466_p.func_175065_a(this.name, (float)(margin - 8 - length), (float)(py + 6), ScrollingJsonEntry.getTextColor(), false);
    }

    @Override
    public void drawForeground(int mx, int my, int px, int py, int width) {
        if (mx >= px && mx < px + width / 3 && my >= py && my < py + 20 && this.desc != null && this.desc.length() > 0) {
            ArrayList<String> tTip = new ArrayList<String>();
            tTip.add(this.desc);
            this.drawTooltip(tTip, mx, my, this.mc.field_71466_p);
        }
    }

    @Override
    public void onMouseClick(int mx, int my, int px, int py, int click, int index) {
        if (this.txtMain != null) {
            this.txtMain.func_146192_a(mx, my, click);
        }
        for (GuiButtonThemed btn : this.btnList) {
            if (!btn.func_146116_c(this.mc, mx, my)) continue;
            btn.func_146113_a(this.mc.func_147118_V());
            this.onActionPerformed(btn);
        }
    }

    public void onActionPerformed(GuiButtonThemed btn) {
        if (this.je != null && btn.field_146127_k == 3) {
            if (this.json.isJsonObject()) {
                this.json.getAsJsonObject().remove(this.key);
                this.host.getEntryList().remove(this);
                this.host.refresh();
                return;
            }
            if (this.json.isJsonArray()) {
                JsonHelper.GetUnderlyingArray(this.json.getAsJsonArray()).remove(this.idx);
                this.host.getEntryList().remove(this);
                this.host.refresh();
                return;
            }
        }
        if (btn.field_146127_k == 2) {
            if (this.json.isJsonArray()) {
                this.mc.func_147108_a((GuiScreen)new GuiJsonAdd(this.mc.field_71462_r, this.json.getAsJsonArray(), this.idx));
                return;
            }
            if (this.json.isJsonObject()) {
                this.mc.func_147108_a((GuiScreen)new GuiJsonAdd(this.mc.field_71462_r, this.json.getAsJsonObject()));
                return;
            }
        } else if (this.je != null && this.je.isJsonObject()) {
            IJsonDoc childDoc;
            JsonObject jo = this.je.getAsJsonObject();
            IJsonDoc iJsonDoc = childDoc = this.jDoc == null ? null : this.jDoc.getChildDoc(this.key);
            if (btn.field_146127_k == 0) {
                if (!(JsonHelper.isItem(jo) || JsonHelper.isFluid(jo) || JsonHelper.isEntity(jo))) {
                    this.mc.func_147108_a((GuiScreen)new GuiJsonEditor(this.mc.field_71462_r, jo, childDoc));
                } else if (JsonHelper.isItem(jo)) {
                    this.mc.func_147108_a((GuiScreen)new GuiJsonItemSelection(this.mc.field_71462_r, new JsonItemCallback(jo), JsonHelper.JsonToItemStack(jo)));
                } else if (JsonHelper.isFluid(jo)) {
                    this.mc.func_147108_a((GuiScreen)new GuiJsonFluidSelection(this.mc.field_71462_r, new JsonFluidCallback(jo), JsonHelper.JsonToFluidStack(jo)));
                } else if (JsonHelper.isEntity(jo)) {
                    this.mc.func_147108_a((GuiScreen)new GuiJsonEntitySelection(this.mc.field_71462_r, new JsonEntityCallback(jo), JsonHelper.JsonToEntity(jo, (World)this.mc.field_71441_e, true)));
                }
            } else if (btn.field_146127_k == 1) {
                this.mc.func_147108_a((GuiScreen)new GuiJsonTypeMenu(this.mc.field_71462_r, jo));
            }
        } else if (this.je != null && this.je.isJsonArray()) {
            this.mc.func_147108_a((GuiScreen)new GuiJsonEditor(this.mc.field_71462_r, this.je.getAsJsonArray(), this.jDoc));
        } else if (this.je != null && this.je.isJsonPrimitive() && this.je.getAsJsonPrimitive().isBoolean()) {
            if (this.json.isJsonObject()) {
                this.json.getAsJsonObject().addProperty(this.key, Boolean.valueOf(!this.je.getAsBoolean()));
                this.host.refresh();
                return;
            }
            if (this.json.isJsonArray()) {
                JsonHelper.GetUnderlyingArray(this.json.getAsJsonArray()).set(this.idx, (JsonElement)new JsonPrimitive(Boolean.valueOf(!this.je.getAsBoolean())));
                this.host.refresh();
                return;
            }
        }
    }

    public void onKeyTyped(char c, int keyCode) {
        if (this.txtMain != null) {
            this.txtMain.func_146201_a(c, keyCode);
            if (this.json.isJsonArray()) {
                ArrayList<JsonElement> list = JsonHelper.GetUnderlyingArray(this.json.getAsJsonArray());
                if (this.txtMain instanceof GuiNumberField) {
                    list.set(this.idx, (JsonElement)new JsonPrimitive(((GuiNumberField)this.txtMain).getNumber()));
                } else {
                    list.set(this.idx, (JsonElement)new JsonPrimitive(this.txtMain.func_146179_b()));
                }
            } else if (this.json.isJsonObject()) {
                if (this.txtMain instanceof GuiNumberField) {
                    this.json.getAsJsonObject().addProperty(this.key, ((GuiNumberField)this.txtMain).getNumber());
                } else {
                    this.json.getAsJsonObject().addProperty(this.key, this.txtMain.func_146179_b());
                }
            }
        }
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public boolean canDrawOutsideBox(boolean isForeground) {
        return isForeground;
    }
}

