/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.rewards;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.ICallback;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.NBTConverter;
import betterquesting.client.gui.editors.json.scrolling.GuiJsonEditor;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GuiRewardEditDefault
extends GuiScreenThemed
implements ICallback<JsonObject> {
    private final IQuest quest;
    private final int qID;
    private final int rID;
    private final JsonObject json;
    private boolean isDone = false;

    public GuiRewardEditDefault(GuiScreen parent, IQuest quest, IReward reward) {
        super(parent, reward.getUnlocalisedName());
        this.quest = quest;
        this.qID = QuestDatabase.INSTANCE.getKey(quest);
        this.rID = quest.getRewards().getKey(reward);
        this.json = reward.writeToJson(new JsonObject(), EnumSaveType.CONFIG);
        this.isDone = false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.isDone) {
            this.isDone = true;
            IReward reward = this.quest.getRewards().getValue(this.rID);
            if (reward != null) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiJsonEditor((GuiScreen)this, this.json, reward.getDocumentation(), this));
            } else {
                this.field_146297_k.func_147108_a(this.parent);
            }
        } else {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    @Override
    public void setValue(JsonObject value) {
        IReward reward = this.quest.getRewards().getValue(this.rID);
        if (reward != null) {
            reward.readFromJson(value, EnumSaveType.CONFIG);
            this.SendChanges();
        }
    }

    public void SendChanges() {
        JsonObject base = new JsonObject();
        base.add("config", (JsonElement)this.quest.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        base.add("progress", (JsonElement)this.quest.writeToJson(new JsonObject(), EnumSaveType.PROGRESS));
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tags.func_74768_a("questID", this.qID);
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
    }
}

