/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.tasks;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingButtons;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.IFactory;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.editors.tasks.GuiTaskEditDefault;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.tasks.TaskRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTaskEditor
extends GuiScreenThemed
implements IVolatileScreen,
INeedsRefresh {
    private List<IFactory<? extends ITask>> taskTypes = new ArrayList<IFactory<? extends ITask>>();
    private List<Integer> taskIDs = new ArrayList<Integer>();
    private IQuest quest;
    private int qId = -1;
    private GuiScrollingButtons btnsLeft;
    private GuiScrollingButtons btnsRight;

    public GuiTaskEditor(GuiScreen parent, IQuest quest) {
        super(parent, I18n.func_135052_a((String)"betterquesting.title.edit_tasks", (Object[])new Object[]{I18n.func_135052_a((String)quest.getUnlocalisedName(), (Object[])new Object[0])}));
        this.quest = quest;
        this.qId = QuestDatabase.INSTANCE.getKey(quest);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.taskTypes = TaskRegistry.INSTANCE.getAll();
        this.taskIDs = this.quest.getTasks().getAllKeys();
        this.btnsLeft = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + 16, this.guiTop + 32, this.sizeX / 2 - 24, this.sizeY - 64);
        this.btnsRight = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 32, this.sizeX / 2 - 24, this.sizeY - 64);
        this.embedded.add(this.btnsLeft);
        this.embedded.add(this.btnsRight);
        this.RefreshColumns();
    }

    @Override
    public void refreshGui() {
        IQuest tmp = QuestDatabase.INSTANCE.getValue(this.qId);
        if (tmp == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        this.quest = tmp;
        this.taskIDs = this.quest.getTasks().getAllKeys();
        this.RefreshColumns();
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        super.drawBackPanel(mx, my, partialTick);
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        int column = button.field_146127_k & 3;
        int id = (button.field_146127_k >> 2) - 1;
        if (id < 0) {
            return;
        }
        if (column == 0) {
            ITask task = this.quest.getTasks().getValue(id);
            GuiScreen editor = task.getTaskEditor(this, this.quest);
            if (editor != null) {
                this.field_146297_k.func_147108_a(editor);
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiTaskEditDefault(this, this.quest, task));
            }
        } else if (column == 1) {
            this.quest.getTasks().removeKey(id);
            this.SendChanges();
        } else if (column == 2 && id >= 0 && id < this.taskTypes.size()) {
            this.quest.getTasks().add(TaskRegistry.INSTANCE.createTask(this.taskTypes.get(id).getRegistryName()), this.quest.getTasks().nextKey());
            this.SendChanges();
        }
    }

    public void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        if (click != 0) {
            return;
        }
        GuiButtonThemed btn1 = this.btnsLeft.getButtonUnderMouse(mx, my);
        if (btn1 != null && btn1.func_146116_c(this.field_146297_k, mx, my)) {
            btn1.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn1);
            return;
        }
        GuiButtonThemed btn2 = this.btnsRight.getButtonUnderMouse(mx, my);
        if (btn2 != null && btn2.func_146116_c(this.field_146297_k, mx, my)) {
            btn2.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn2);
            return;
        }
    }

    public void SendChanges() {
        JsonObject base = new JsonObject();
        base.add("config", (JsonElement)this.quest.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        base.add("progress", (JsonElement)this.quest.writeToJson(new JsonObject(), EnumSaveType.PROGRESS));
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tags.func_74768_a("questID", QuestDatabase.INSTANCE.getKey(this.quest).intValue());
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
    }

    public void RefreshColumns() {
        this.btnsLeft.getEntryList().clear();
        this.btnsRight.getEntryList().clear();
        for (int tID : this.taskIDs) {
            int btnWidth = this.btnsLeft.getListWidth();
            int bID = 1 + tID << 2;
            GuiButtonThemed btn1 = new GuiButtonThemed(bID + 0, 0, 0, btnWidth - 20, 20, I18n.func_135052_a((String)this.quest.getTasks().getValue(tID).getUnlocalisedName(), (Object[])new Object[0]));
            GuiButtonThemed btn2 = new GuiButtonThemed(bID + 1, 0, 0, 20, 20, "" + TextFormatting.RED + TextFormatting.BOLD + "x");
            this.btnsLeft.addButtonRow(btn1, btn2);
        }
        for (int i = 0; i < this.taskTypes.size(); ++i) {
            int btnWidth = this.btnsRight.getListWidth();
            int bID = 1 + i << 2;
            GuiButtonThemed btn1 = new GuiButtonThemed(bID + 2, 0, 0, btnWidth, 20, this.taskTypes.get(i).getRegistryName().toString());
            this.btnsRight.addButtonRow(btn1);
        }
    }
}

