/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.misc;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class GuiQuestingHelp
extends GuiScreenThemed {
    GuiScrollingText curPage = null;
    static ArrayList<HelpTopic> helpTopics = new ArrayList();
    int leftScroll = 0;
    int maxRows = 0;

    public GuiQuestingHelp(GuiScreen parent) {
        super(parent, "item.betterquesting.guide.name");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.maxRows = (this.sizeY - 64) / 20;
        for (int i = 0; i < this.maxRows; ++i) {
            this.field_146292_n.add(new GuiButtonThemed(i + 1, this.guiLeft + 16, this.guiTop + 32 + i * 20, 100, 20, "NULL", true));
        }
        this.curPage = new GuiScrollingText(this.field_146297_k, this.guiLeft + 124, this.guiTop + 32, this.sizeX - 148, this.sizeY - 64, "");
        this.embedded.add(this.curPage);
        this.RefreshColumns();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        int s;
        super.func_73863_a(mx, my, partialTick);
        this.func_73729_b(this.guiLeft + 116, this.guiTop + 32, 248, 0, 8, 20);
        for (s = 20; s < (this.maxRows - 1) * 20; s += 20) {
            this.func_73729_b(this.guiLeft + 116, this.guiTop + 32 + s, 248, 20, 8, 20);
        }
        this.func_73729_b(this.guiLeft + 116, this.guiTop + 32 + s, 248, 40, 8, 20);
        this.func_73729_b(this.guiLeft + 116, this.guiTop + 32 + (int)Math.max(0.0f, (float)s * (float)this.leftScroll / (float)(helpTopics.size() - this.maxRows)), 248, 60, 8, 20);
    }

    @Override
    public void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn.field_146127_k > 0) {
            int n1 = btn.field_146127_k - 1;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.leftScroll;
            if (n2 == 0) {
                if (n3 >= 0 && n3 < helpTopics.size()) {
                    this.curPage.SetText(helpTopics.get(n3).getParagraph());
                } else {
                    this.curPage.SetText("");
                }
                this.RefreshColumns();
            }
        }
    }

    @Override
    public void mouseScroll(int mx, int my, int scroll) {
        super.mouseScroll(mx, my, scroll);
        if (scroll != 0 && this.isWithin(mx, my, this.guiLeft, this.guiTop, this.sizeX / 2, this.sizeY)) {
            this.leftScroll = Math.max(0, MathHelper.func_76125_a((int)(this.leftScroll + scroll), (int)0, (int)(helpTopics.size() - this.maxRows)));
            this.RefreshColumns();
        }
    }

    public void RefreshColumns() {
        this.leftScroll = Math.max(0, MathHelper.func_76125_a((int)this.leftScroll, (int)0, (int)(helpTopics.size() - this.maxRows)));
        List btnList = this.field_146292_n;
        for (int i = 1; i < btnList.size(); ++i) {
            GuiButton btn = (GuiButton)btnList.get(i);
            int n1 = btn.field_146127_k - 1;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.leftScroll;
            if (n2 == 0) {
                if (n3 >= 0 && n3 < helpTopics.size()) {
                    btn.field_146126_j = I18n.func_135052_a((String)helpTopics.get(n3).getButton(), (Object[])new Object[0]);
                    btn.field_146125_m = true;
                    btn.field_146124_l = true;
                    continue;
                }
                btn.field_146126_j = "NULL";
                btn.field_146125_m = false;
                btn.field_146124_l = false;
                continue;
            }
            if (n2 != 1) continue;
            btn.field_146125_m = n3 >= 0 && n3 < helpTopics.size();
            btn.field_146124_l = btn.field_146125_m;
        }
    }

    public static void registerTopic(String btn, String paragraph) {
        helpTopics.add(new HelpTopic(btn, paragraph));
    }

    static {
        GuiQuestingHelp.registerTopic("betterquesting.btn.help1", "betterquesting.help.page1");
        GuiQuestingHelp.registerTopic("betterquesting.btn.help2", "betterquesting.help.page2");
        GuiQuestingHelp.registerTopic("betterquesting.btn.help3", "betterquesting.help.page3");
        GuiQuestingHelp.registerTopic("betterquesting.btn.help4", "betterquesting.help.page4");
        GuiQuestingHelp.registerTopic("betterquesting.btn.help5", "betterquesting.help.page5");
        GuiQuestingHelp.registerTopic("betterquesting.btn.help6", "betterquesting.help.page6");
        GuiQuestingHelp.registerTopic("betterquesting.btn.help7", "betterquesting.help.page7");
        GuiQuestingHelp.registerTopic("betterquesting.btn.help8", "betterquesting.help.page8");
    }

    public static class HelpTopic {
        String btn;
        String txt;

        public HelpTopic(String btn, String txt) {
            this.btn = btn;
            this.txt = txt;
        }

        public String getButton() {
            return I18n.func_135052_a((String)this.btn, (Object[])new Object[0]);
        }

        public String getParagraph() {
            return I18n.func_135052_a((String)this.txt, (Object[])new Object[0]);
        }
    }
}

