/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.party;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.party.GuiNoParty;
import betterquesting.client.gui.party.GuiPartyInvite;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiManageParty
extends GuiScreenThemed
implements INeedsRefresh {
    private ItemStack heart;
    private int lives = 1;
    private IParty party;
    private EnumPartyStatus status;
    private int rightScroll = 0;
    private int maxRows = 0;
    private GuiTextField fieldName;
    private List<UUID> memList = new ArrayList<UUID>();

    public GuiManageParty(GuiScreen parent, IParty party) {
        super(parent, I18n.func_135052_a((String)"betterquesting.title.party", (Object[])new Object[]{party.getName()}));
        this.party = party;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.party == null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiNoParty(this.parent));
            return;
        }
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        this.status = NameCache.INSTANCE.isOP(playerID) ? EnumPartyStatus.OWNER : this.party.getStatus(playerID);
        this.heart = new ItemStack(BetterQuesting.extraLife);
        this.lives = LifeDatabase.INSTANCE.getLives(playerID);
        this.memList = this.party.getMembers();
        this.setTitle(I18n.func_135052_a((String)"betterquesting.title.party", (Object[])new Object[]{this.party.getName()}));
        this.rightScroll = 0;
        this.maxRows = (this.sizeY - 72) / 20;
        this.field_146292_n.add(new GuiButtonThemed(1, this.guiLeft + this.sizeX / 4 - 75, this.field_146295_m / 2 + 40, 70, 20, I18n.func_135052_a((String)"betterquesting.btn.party_leave", (Object[])new Object[0]), true));
        GuiButtonThemed lifeBtn = new GuiButtonThemed(3, this.guiLeft + this.sizeX / 4 - 75, this.field_146295_m / 2, 150, 20, I18n.func_135052_a((String)"betterquesting.btn.party_share_lives", (Object[])new Object[0]) + ": " + this.party.getProperties().getProperty(NativeProps.PARTY_LIVES), true);
        lifeBtn.field_146124_l = this.status.ordinal() >= 3;
        this.field_146292_n.add(lifeBtn);
        GuiButtonThemed invBtn = new GuiButtonThemed(4, this.guiLeft + this.sizeX / 4 + 5, this.field_146295_m / 2 + 40, 70, 20, I18n.func_135052_a((String)"betterquesting.btn.party_invite", (Object[])new Object[0]), true);
        invBtn.field_146124_l = this.status.ordinal() >= 2;
        this.field_146292_n.add(invBtn);
        this.fieldName = new GuiTextField(0, this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 4 - 74, this.field_146295_m / 2 - 59, 148, 18);
        this.fieldName.func_146180_a(this.party.getName());
        this.fieldName.func_146184_c(this.status.ordinal() >= 3);
        for (int i = 0; i < this.maxRows; ++i) {
            GuiButtonThemed btn = new GuiButtonThemed(this.field_146292_n.size() + 1, this.guiLeft + this.sizeX - 74, this.guiTop + 48 + i * 20, 50, 20, I18n.func_135052_a((String)"betterquesting.btn.party_kick", (Object[])new Object[0]), true);
            this.field_146292_n.add(btn);
        }
        this.RefreshColumns();
    }

    @Override
    public void refreshGui() {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        this.party = PartyManager.INSTANCE.getUserParty(playerID);
        this.func_73866_w_();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        int s;
        super.func_73863_a(mx, my, partialTick);
        if (QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue()) {
            RenderUtils.RenderItemStack(this.field_146297_k, this.heart, this.guiLeft + 16, this.guiTop + this.sizeY - 32, "");
            this.field_146297_k.field_71466_p.func_78276_b("x " + this.lives, this.guiLeft + 36, this.guiTop + this.sizeY - 28, this.getTextColor());
        }
        String memTitle = TextFormatting.UNDERLINE + I18n.func_135052_a((String)"betterquesting.gui.party_members", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_175065_a(memTitle, (float)(this.guiLeft + this.sizeX / 4 * 3 - this.field_146297_k.field_71466_p.func_78256_a(memTitle) / 2), (float)(this.guiTop + 32), this.getTextColor(), false);
        int dotL = this.field_146297_k.field_71466_p.func_78256_a("...");
        for (int i = 0; i < this.memList.size(); ++i) {
            int n = i + this.rightScroll;
            if (n < 0 || n >= this.memList.size() || i >= this.maxRows) continue;
            String name = NameCache.INSTANCE.getName(this.memList.get(n));
            if (this.field_146297_k.field_71466_p.func_78256_a(name) > this.sizeX / 2 - 32 - 58) {
                name = this.field_146297_k.field_71466_p.func_78269_a(name, this.sizeX / 2 - 32 - 58 - dotL) + "...";
            }
            this.field_146297_k.field_71466_p.func_175065_a(name, (float)(this.guiLeft + this.sizeX - 82 - this.field_146297_k.field_71466_p.func_78256_a(name)), (float)(this.guiTop + 48 + i * 20 + 4), this.getTextColor(), false);
        }
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48, 248, 0, 8, 20);
        for (s = 20; s < (this.maxRows - 1) * 20; s += 20) {
            this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + s, 248, 20, 8, 20);
        }
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + s, 248, 40, 8, 20);
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + (int)Math.max(0.0f, (float)s * (float)this.rightScroll / (float)(this.memList.size() - this.maxRows)), 248, 60, 8, 20);
        this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.name", (Object[])new Object[0]), (float)(this.guiLeft + this.sizeX / 4 - 75), (float)(this.field_146295_m / 2 - 70), this.getTextColor(), false);
        this.fieldName.func_146194_f();
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("action", EnumPacketAction.KICK.ordinal());
            tags.func_74768_a("partyID", PartyManager.INSTANCE.getKey(this.party).intValue());
            tags.func_74778_a("target", QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g).toString());
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
        } else if (button.field_146127_k == 3 && this.status.ordinal() >= 3) {
            this.party.getProperties().setProperty(NativeProps.PARTY_LIVES, this.party.getProperties().getProperty(NativeProps.PARTY_LIVES) == false);
            this.SendChanges();
        } else if (button.field_146127_k == 4 && this.status.ordinal() >= 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPartyInvite((GuiScreen)this, this.party));
        } else if (button.field_146127_k > 4) {
            int n1 = button.field_146127_k - 5;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.rightScroll;
            if (n2 == 0 && n3 >= 0 && n3 < this.memList.size()) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74768_a("action", EnumPacketAction.KICK.ordinal());
                tags.func_74768_a("partyID", PartyManager.INSTANCE.getKey(this.party).intValue());
                tags.func_74778_a("target", this.memList.get(n3).toString());
                PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
            }
        }
    }

    @Override
    protected void func_73869_a(char character, int keyCode) throws IOException {
        super.func_73869_a(character, keyCode);
        this.fieldName.func_146201_a(character, keyCode);
    }

    protected void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        if (this.status.ordinal() >= 3) {
            this.fieldName.func_146192_a(mx, my, click);
            if (!this.fieldName.func_146206_l() && !this.fieldName.func_146179_b().equals(this.party.getName())) {
                this.party.getProperties().setProperty(NativeProps.NAME, this.fieldName.func_146179_b());
                this.SendChanges();
            }
        } else {
            this.fieldName.func_146195_b(false);
        }
    }

    @Override
    public void mouseScroll(int mx, int my, int scroll) {
        super.mouseScroll(mx, my, scroll);
        if (scroll != 0 && this.isWithin(mx, my, this.guiLeft + this.sizeX / 2, this.guiTop, this.sizeX / 2, this.sizeY)) {
            this.rightScroll = Math.max(0, MathHelper.func_76125_a((int)(this.rightScroll + scroll), (int)0, (int)(this.memList.size() - this.maxRows)));
            this.RefreshColumns();
        }
    }

    public void SendChanges() {
        if (this.status != EnumPartyStatus.OWNER && !NameCache.INSTANCE.isOP(QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g))) {
            return;
        }
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tags.func_74768_a("partyID", PartyManager.INSTANCE.getKey(this.party).intValue());
        JsonObject base = new JsonObject();
        base.add("party", (JsonElement)this.party.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
    }

    public void RefreshColumns() {
        this.rightScroll = Math.max(0, MathHelper.func_76125_a((int)this.rightScroll, (int)0, (int)(this.memList.size() - this.maxRows)));
        List btnList = this.field_146292_n;
        for (int i = 5; i < btnList.size(); ++i) {
            GuiButton btn = (GuiButton)btnList.get(i);
            int n1 = btn.field_146127_k - 5;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.rightScroll;
            if (n2 != 0) continue;
            if (n3 >= 0 && n3 < this.memList.size()) {
                btn.field_146125_m = true;
                btn.field_146124_l = this.status.ordinal() >= 2;
                continue;
            }
            btn.field_146124_l = false;
            btn.field_146125_m = false;
        }
    }
}

