/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.party;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.party.GuiManageParty;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.QuestSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiNoParty
extends GuiScreenThemed
implements INeedsRefresh {
    ItemStack heart;
    int lives = 1;
    int rightScroll = 0;
    int maxRows = 0;
    List<IParty> invites = new ArrayList<IParty>();
    GuiTextField fieldName;
    GuiButton btnCreate;

    public GuiNoParty(GuiScreen parent) {
        super(parent, "betterquesting.title.party_none");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        IParty party = PartyManager.INSTANCE.getUserParty(playerID);
        if (party != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiManageParty(this.parent, party));
            return;
        }
        this.heart = new ItemStack(BetterQuesting.extraLife);
        this.lives = LifeDatabase.INSTANCE.getLives(playerID);
        this.invites.clear();
        for (int i : PartyManager.INSTANCE.getPartyInvites(playerID)) {
            this.invites.add(PartyManager.INSTANCE.getValue(i));
        }
        this.rightScroll = 0;
        this.maxRows = (this.sizeY - 72) / 20;
        this.btnCreate = new GuiButtonThemed(1, this.guiLeft + this.sizeX / 4 - 75, this.field_146295_m / 2 + 0, 150, 20, I18n.func_135052_a((String)"betterquesting.btn.party_new", (Object[])new Object[0]), true);
        this.field_146292_n.add(this.btnCreate);
        this.fieldName = new GuiTextField(0, this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 4 - 74, this.field_146295_m / 2 - 19, 148, 18);
        this.fieldName.func_146180_a("New Party");
        for (int i = 0; i < this.maxRows; ++i) {
            GuiButtonThemed btn = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + this.sizeX - 74, this.guiTop + 48 + i * 20, 50, 20, I18n.func_135052_a((String)"betterquesting.btn.party_join", (Object[])new Object[0]), true);
            this.field_146292_n.add(btn);
        }
        this.RefreshColumns();
    }

    @Override
    public void refreshGui() {
        this.func_73866_w_();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        int s;
        super.func_73863_a(mx, my, partialTick);
        if (QuestSettings.INSTANCE.canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g)) {
            RenderUtils.RenderItemStack(this.field_146297_k, this.heart, this.guiLeft + 16, this.guiTop + this.sizeY - 32, "");
            this.field_146297_k.field_71466_p.func_78276_b("x " + this.lives, this.guiLeft + 36, this.guiTop + this.sizeY - 28, this.getTextColor());
        }
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48, 248, 0, 8, 20);
        for (s = 20; s < (this.maxRows - 1) * 20; s += 20) {
            this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + s, 248, 20, 8, 20);
        }
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + s, 248, 40, 8, 20);
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + (int)Math.max(0.0f, (float)s * (float)this.rightScroll / (float)(this.invites.size() - this.maxRows)), 248, 60, 8, 20);
        String memTitle = TextFormatting.UNDERLINE + I18n.func_135052_a((String)"betterquesting.gui.party_invites", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_175065_a(memTitle, (float)(this.guiLeft + this.sizeX / 4 * 3 - this.field_146297_k.field_71466_p.func_78256_a(memTitle) / 2), (float)(this.guiTop + 32), this.getTextColor(), false);
        int dotL = this.field_146297_k.field_71466_p.func_78256_a("...");
        for (int i = 0; i < this.invites.size(); ++i) {
            int n = i + this.rightScroll;
            IParty party = this.invites.get(i);
            if (n < 0 || n >= this.invites.size() || i >= this.maxRows) continue;
            String name = party.getName();
            if (this.field_146297_k.field_71466_p.func_78256_a(name) > this.sizeX / 2 - 32 - 58) {
                name = this.field_146297_k.field_71466_p.func_78269_a(name, this.sizeX / 2 - 32 - 58 - dotL) + "...";
            }
            this.field_146297_k.field_71466_p.func_175065_a(name, (float)(this.guiLeft + this.sizeX - 82 - this.field_146297_k.field_71466_p.func_78256_a(name)), (float)(this.guiTop + 48 + i * 20 + 4), this.getTextColor(), false);
        }
        this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.name", (Object[])new Object[0]), (float)(this.guiLeft + this.sizeX / 4 - 75), (float)(this.field_146295_m / 2 - 30), this.getTextColor(), false);
        this.fieldName.func_146194_f();
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("action", EnumPacketAction.ADD.ordinal());
            tags.func_74778_a("Party", this.fieldName.func_146179_b());
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
        } else if (button.field_146127_k > 1) {
            int n1 = button.field_146127_k - 2;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.rightScroll;
            if (n2 == 0 && n3 >= 0 && n3 < this.invites.size()) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74768_a("action", EnumPacketAction.JOIN.ordinal());
                tags.func_74768_a("partyID", PartyManager.INSTANCE.getKey(this.invites.get(n3)).intValue());
                PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
            }
        }
    }

    @Override
    protected void func_73869_a(char character, int keyCode) throws IOException {
        super.func_73869_a(character, keyCode);
        this.fieldName.func_146201_a(character, keyCode);
        this.btnCreate.field_146124_l = this.fieldName.func_146179_b().length() >= 0;
    }

    protected void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        this.fieldName.func_146192_a(mx, my, click);
    }

    @Override
    public void mouseScroll(int mx, int my, int scroll) {
        super.mouseScroll(mx, my, scroll);
        if (scroll != 0 && this.isWithin(mx, my, this.guiLeft + this.sizeX / 2, this.guiTop, this.sizeX / 2, this.sizeY)) {
            this.rightScroll = Math.max(0, MathHelper.func_76125_a((int)(this.rightScroll + scroll), (int)0, (int)(this.invites.size() - this.maxRows)));
            this.RefreshColumns();
        }
    }

    public void RefreshColumns() {
        this.rightScroll = Math.max(0, MathHelper.func_76125_a((int)this.rightScroll, (int)0, (int)(this.invites.size() - this.maxRows)));
        List btnList = this.field_146292_n;
        for (int i = 2; i < btnList.size(); ++i) {
            GuiButton btn = (GuiButton)btnList.get(i);
            int n1 = btn.field_146127_k - 2;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.rightScroll;
            if (n2 != 0) continue;
            if (n3 >= 0 && n3 < this.invites.size()) {
                btn.field_146124_l = true;
                btn.field_146125_m = true;
                continue;
            }
            btn.field_146124_l = false;
            btn.field_146125_m = false;
        }
    }
}

