/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.party;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.party.IParty;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.NameCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class GuiPartyInvite
extends GuiScreenThemed
implements INeedsRefresh {
    private final int partyID;
    private IParty party;
    private int listScroll = 0;
    private int maxRows = 0;
    private final List<String> playerList = new ArrayList<String>();
    private GuiBigTextField txtManual;
    private GuiButtonThemed btnManual;

    public GuiPartyInvite(GuiScreen parent, IParty party) {
        super(parent, "betterquesting.title.party_invite");
        this.party = party;
        this.partyID = PartyManager.INSTANCE.getKey(party);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.maxRows = (this.sizeY - 92) / 20;
        NetHandlerPlayClient nethandlerplayclient = this.field_146297_k.field_71439_g.field_71174_a;
        this.playerList.clear();
        this.playerList.addAll(NameCache.INSTANCE.getAllNames());
        for (NetworkPlayerInfo info : nethandlerplayclient.func_175106_d()) {
            if (this.playerList.contains(info.func_178845_a().getName())) continue;
            this.playerList.add(info.func_178845_a().getName());
        }
        this.txtManual = new GuiBigTextField(this.field_146289_q, this.guiLeft + this.sizeX / 2 - 149, this.guiTop + 33, 198, 18);
        this.txtManual.setWatermark("Username");
        this.btnManual = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + this.sizeX / 2 + 50, this.guiTop + 32, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.party_invite", (Object[])new Object[0]), true);
        this.field_146292_n.add(this.btnManual);
        for (int i = 0; i < this.maxRows * 3; ++i) {
            GuiButtonThemed btn = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + this.sizeX / 2 - 150 + i % 3 * 100, this.guiTop + 68 + i / 3 * 20, 100, 20, "Username", true);
            this.field_146292_n.add(btn);
        }
        this.RefreshColumns();
    }

    @Override
    public void refreshGui() {
        this.party = PartyManager.INSTANCE.getValue(this.partyID);
        NetHandlerPlayClient nethandlerplayclient = this.field_146297_k.field_71439_g.field_71174_a;
        this.playerList.clear();
        this.playerList.addAll(NameCache.INSTANCE.getAllNames());
        for (NetworkPlayerInfo info : nethandlerplayclient.func_175106_d()) {
            if (this.playerList.contains(info.func_178845_a().getName())) continue;
            this.playerList.add(info.func_178845_a().getName());
        }
        this.RefreshColumns();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        int s;
        super.func_73863_a(mx, my, partialTick);
        if (this.txtManual != null) {
            this.txtManual.drawTextBox(mx, my, partialTick);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        this.func_73729_b(this.guiLeft + this.sizeX / 2 + 150, this.guiTop + 68, 248, 0, 8, 20);
        for (s = 20; s < (this.maxRows - 1) * 20; s += 20) {
            this.func_73729_b(this.guiLeft + this.sizeX / 2 + 150, this.guiTop + 68 + s, 248, 20, 8, 20);
        }
        this.func_73729_b(this.guiLeft + this.sizeX / 2 + 150, this.guiTop + 68 + s, 248, 40, 8, 20);
        this.func_73729_b(this.guiLeft + this.sizeX / 2 + 150, this.guiTop + 68 + (int)Math.max(0.0f, (float)s * (float)this.listScroll / (float)(this.playerList.size() - this.maxRows * 3)), 248, 60, 8, 20);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("action", EnumPacketAction.INVITE.ordinal());
            tags.func_74768_a("partyID", PartyManager.INSTANCE.getKey(this.party).intValue());
            tags.func_74778_a("target", this.txtManual.func_146179_b());
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
        } else if (button.field_146127_k > 1) {
            int n1 = button.field_146127_k - 2;
            int n2 = n1 / (this.maxRows * 3);
            int n3 = n1 % (this.maxRows * 3) + this.listScroll;
            if (n2 == 0 && n3 >= 0 && n3 < this.playerList.size()) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74768_a("action", EnumPacketAction.INVITE.ordinal());
                tags.func_74768_a("partyID", PartyManager.INSTANCE.getKey(this.party).intValue());
                tags.func_74778_a("target", button.field_146126_j);
                PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
            }
        }
    }

    public void func_73864_a(int mx, int my, int type) throws IOException {
        super.func_73864_a(mx, my, type);
        if (this.txtManual != null) {
            this.txtManual.func_146192_a(mx, my, type);
        }
    }

    @Override
    public void mouseScroll(int mx, int my, int scroll) {
        super.mouseScroll(mx, my, scroll);
        if (scroll != 0 && this.isWithin(mx, my, this.guiLeft, this.guiTop, this.sizeX, this.sizeY)) {
            this.listScroll = Math.max(0, MathHelper.func_76125_a((int)(this.listScroll + scroll * 3), (int)0, (int)(this.playerList.size() - this.maxRows * 3)));
            this.RefreshColumns();
        }
    }

    @Override
    public void func_73869_a(char character, int num) throws IOException {
        super.func_73869_a(character, num);
        if (this.txtManual != null) {
            this.txtManual.func_146201_a(character, num);
            this.btnManual.field_146124_l = this.txtManual.func_146179_b() != null && this.txtManual.func_146179_b().length() > 0;
        } else {
            this.btnManual.field_146124_l = false;
        }
    }

    public void RefreshColumns() {
        this.listScroll = Math.max(0, MathHelper.func_76125_a((int)this.listScroll, (int)0, (int)(this.playerList.size() - this.maxRows * 3)));
        List btnList = this.field_146292_n;
        for (int i = 2; i < btnList.size(); ++i) {
            GuiButton btn = (GuiButton)btnList.get(i);
            int n1 = btn.field_146127_k - 2;
            int n2 = n1 / (this.maxRows * 3);
            int n3 = n1 % (this.maxRows * 3) + this.listScroll;
            if (n2 != 0) continue;
            if (n3 >= 0 && n3 < this.playerList.size()) {
                btn.field_146124_l = true;
                btn.field_146125_m = true;
                btn.field_146126_j = this.playerList.get(n3);
                continue;
            }
            btn.field_146125_m = true;
            btn.field_146124_l = false;
            btn.field_146126_j = "-";
        }
    }
}

