/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.importers;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.utils.JsonHelper;
import betterquesting.questing.QuestLine;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class ImportedQuestLines
implements IQuestLineDatabase {
    private final HashMap<Integer, IQuestLine> questLines = new HashMap();
    private final List<Integer> lineOrder = new ArrayList<Integer>();

    @Override
    public Integer nextKey() {
        int id = 0;
        while (this.questLines.containsKey(id)) {
            ++id;
        }
        return id;
    }

    @Override
    public int getOrderIndex(int lineID) {
        if (!this.questLines.containsKey(lineID)) {
            return -1;
        }
        if (!this.lineOrder.contains(lineID)) {
            this.lineOrder.add(lineID);
        }
        return this.lineOrder.indexOf(lineID);
    }

    @Override
    public void setOrderIndex(int lineID, int index) {
        this.lineOrder.remove((Object)lineID);
        this.lineOrder.add(index, lineID);
    }

    @Override
    public boolean add(IQuestLine value, Integer key) {
        if (key < 0 || value == null || this.questLines.containsValue(value) || this.questLines.containsKey(key)) {
            return false;
        }
        this.questLines.put(key, value);
        return true;
    }

    @Override
    public boolean removeKey(Integer key) {
        return this.questLines.remove(key) != null;
    }

    @Override
    public boolean removeValue(IQuestLine value) {
        return this.removeKey(this.getKey(value));
    }

    @Override
    public IQuestLine getValue(Integer key) {
        return this.questLines.get(key);
    }

    @Override
    public Integer getKey(IQuestLine value) {
        for (Map.Entry<Integer, IQuestLine> entry : this.questLines.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.questLines.size();
    }

    @Override
    public void reset() {
        this.questLines.clear();
    }

    @Override
    public List<IQuestLine> getAllValues() {
        return new ArrayList<IQuestLine>(this.questLines.values());
    }

    @Override
    public List<Integer> getAllKeys() {
        return new ArrayList<Integer>(this.questLines.keySet());
    }

    @Override
    public JsonArray writeToJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (Map.Entry<Integer, IQuestLine> entry : this.questLines.entrySet()) {
            if (entry.getValue() == null) continue;
            int id = entry.getKey();
            JsonObject jObj = entry.getValue().writeToJson(new JsonObject(), saveType);
            jObj.addProperty("lineID", (Number)id);
            jObj.addProperty("order", (Number)this.getOrderIndex(id));
            json.add((JsonElement)jObj);
        }
        return json;
    }

    @Override
    public void readFromJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.questLines.clear();
        HashMap<Integer, Integer> orderMap = new HashMap<Integer, Integer>();
        for (JsonElement entry : json) {
            if (entry == null || !entry.isJsonObject()) continue;
            JsonObject jql = entry.getAsJsonObject();
            int id = JsonHelper.GetNumber(jql, "lineID", -1).intValue();
            int order = JsonHelper.GetNumber(jql, "order", -1).intValue();
            QuestLine line = new QuestLine();
            line.readFromJson(entry.getAsJsonObject(), saveType);
            if (id >= 0) {
                this.questLines.put(id, line);
            }
            if (order < 0) continue;
            orderMap.put(order, id);
        }
        ArrayList orderKeys = new ArrayList(orderMap.keySet());
        Collections.sort(orderKeys);
        this.lineOrder.clear();
        Iterator iterator = orderKeys.iterator();
        while (iterator.hasNext()) {
            int o = (Integer)iterator.next();
            this.lineOrder.add((Integer)orderMap.get(o));
        }
    }

    @Override
    public QuestingPacket getSyncPacket() {
        return null;
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
    }

    @Override
    public void removeQuest(int questID) {
        for (IQuestLine ql : this.getAllValues()) {
            ql.removeKey(questID);
        }
    }

    @Override
    public IQuestLine createNew() {
        QuestLine ql = new QuestLine();
        ql.setParentDatabase(this);
        return ql;
    }
}

