/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.importers;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.utils.JsonHelper;
import betterquesting.questing.QuestInstance;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class ImportedQuests
implements IQuestDatabase {
    private final HashMap<Integer, IQuest> database = new HashMap();

    @Override
    public Integer nextKey() {
        int id = 0;
        while (this.database.containsKey(id)) {
            ++id;
        }
        return id;
    }

    @Override
    public boolean add(IQuest value, Integer key) {
        if (key < 0 || value == null || this.database.containsKey(key) || this.database.containsValue(value)) {
            return false;
        }
        value.setParentDatabase(this);
        this.database.put(key, value);
        return true;
    }

    @Override
    public boolean removeKey(Integer key) {
        return this.database.remove(key) != null;
    }

    @Override
    public boolean removeValue(IQuest value) {
        return this.database.remove(this.getKey(value)) != null;
    }

    @Override
    public IQuest getValue(Integer key) {
        return this.database.get(key);
    }

    @Override
    public Integer getKey(IQuest value) {
        for (Map.Entry<Integer, IQuest> entry : this.database.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.database.size();
    }

    @Override
    public void reset() {
        this.database.clear();
    }

    @Override
    public List<IQuest> getAllValues() {
        return new ArrayList<IQuest>(this.database.values());
    }

    @Override
    public List<Integer> getAllKeys() {
        return new ArrayList<Integer>(this.database.keySet());
    }

    @Override
    public JsonArray writeToJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (Map.Entry<Integer, IQuest> entry : this.database.entrySet()) {
            JsonObject jq = new JsonObject();
            entry.getValue().writeToJson(jq, saveType);
            jq.addProperty("questID", (Number)entry.getKey());
            json.add((JsonElement)jq);
        }
        return json;
    }

    @Override
    public void readFromJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.database.clear();
        for (JsonElement entry : json) {
            int qID;
            if (entry == null || !entry.isJsonObject() || (qID = JsonHelper.GetNumber(entry.getAsJsonObject(), "questID", -1).intValue()) < 0) continue;
            IQuest quest = this.getValue(qID);
            quest = quest != null ? quest : this.createNew();
            quest.readFromJson(entry.getAsJsonObject(), EnumSaveType.CONFIG);
            this.database.put(qID, quest);
        }
    }

    @Override
    public QuestingPacket getSyncPacket() {
        return null;
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
    }

    @Override
    public IQuest createNew() {
        QuestInstance q = new QuestInstance();
        q.setParentDatabase(this);
        return q;
    }
}

