/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.gui.controls.GuiButtonQuestInstance;
import betterquesting.api.client.gui.misc.IGuiQuestLine;
import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.NBTConverter;
import betterquesting.client.toolbox.ToolboxGuiMain;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.QuestLineEntry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ToolboxToolCopy
implements IToolboxTool {
    IGuiQuestLine gui = null;
    GuiButtonQuestInstance btnQuest = null;

    @Override
    public void initTool(IGuiQuestLine gui) {
        this.gui = gui;
        this.btnQuest = null;
    }

    @Override
    public void disableTool() {
        if (this.btnQuest != null) {
            this.btnQuest = null;
        }
    }

    @Override
    public void drawTool(int mx, int my, float partialTick) {
        if (this.btnQuest == null) {
            return;
        }
        int snap = ToolboxGuiMain.getSnapValue();
        int modX = (mx % snap + snap) % snap;
        int modY = (my % snap + snap) % snap;
        this.btnQuest.field_146128_h = mx -= modX;
        this.btnQuest.field_146129_i = my -= modY;
        this.btnQuest.func_146112_a(Minecraft.func_71410_x(), mx, my);
        ToolboxGuiMain.drawGrid(this.gui);
    }

    @Override
    public void onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.btnQuest != null) {
            this.btnQuest = null;
        } else if (click != 0) {
            return;
        }
        int snap = ToolboxGuiMain.getSnapValue();
        int modX = (mx % snap + snap) % snap;
        int modY = (my % snap + snap) % snap;
        mx -= modX;
        my -= modY;
        if (this.btnQuest == null) {
            GuiButtonQuestInstance tmpBtn = this.gui.getQuestLine().getButtonAt(mx, my);
            if (tmpBtn != null) {
                QuestInstance tmpQ = new QuestInstance();
                tmpQ.readFromJson(tmpBtn.getQuest().writeToJson(new JsonObject(), EnumSaveType.CONFIG), EnumSaveType.CONFIG);
                this.btnQuest = new GuiButtonQuestInstance(0, mx, my, tmpBtn.field_146120_f, tmpBtn.field_146121_g, tmpQ);
            }
        } else {
            IQuest quest = this.btnQuest.getQuest();
            IQuestLine qLine = this.gui.getQuestLine().getQuestLine();
            int qID = QuestDatabase.INSTANCE.nextKey();
            int lID = QuestLineDatabase.INSTANCE.getKey(qLine);
            QuestLineEntry qe = new QuestLineEntry(mx, my, Math.max(this.btnQuest.field_146120_f, this.btnQuest.field_146121_g));
            qLine.add(qe, qID);
            this.btnQuest = null;
            NBTTagCompound tag1 = new NBTTagCompound();
            JsonObject base1 = new JsonObject();
            base1.add("config", (JsonElement)quest.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
            tag1.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base1, new NBTTagCompound()));
            tag1.func_74768_a("action", EnumPacketAction.ADD.ordinal());
            tag1.func_74768_a("questID", qID);
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tag1));
            NBTTagCompound tag2 = new NBTTagCompound();
            JsonObject base2 = new JsonObject();
            base2.add("line", (JsonElement)qLine.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
            tag2.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base2, new NBTTagCompound()));
            tag2.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
            tag2.func_74768_a("lineID", lID);
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tag2));
        }
    }

    @Override
    public void onMouseScroll(int mx, int my, int scroll) {
    }

    @Override
    public void onKeyPressed(char c, int keyCode) {
    }

    @Override
    public boolean allowTooltips() {
        return this.btnQuest == null;
    }

    @Override
    public boolean allowScrolling(int click) {
        return this.btnQuest == null || click == 2;
    }

    @Override
    public boolean allowZoom() {
        return true;
    }

    @Override
    public boolean clampScrolling() {
        return this.btnQuest == null;
    }
}

