/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.controls.GuiButtonQuestInstance;
import betterquesting.api.client.gui.misc.IGuiQuestLine;
import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.NBTConverter;
import betterquesting.client.toolbox.ToolboxGuiMain;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ToolboxToolGrab
extends GuiElement
implements IToolboxTool {
    IGuiQuestLine gui;
    int grabID = -1;
    GuiButtonQuestInstance grabbed;

    @Override
    public void initTool(IGuiQuestLine gui) {
        this.gui = gui;
        this.grabbed = null;
        this.grabID = -1;
    }

    @Override
    public void disableTool() {
        IQuestLineEntry qle;
        if (this.grabbed != null && (qle = (IQuestLineEntry)this.gui.getQuestLine().getQuestLine().getValue(this.grabID)) != null) {
            this.grabbed.field_146128_h = qle.getPosX();
            this.grabbed.field_146129_i = qle.getPosY();
        }
        this.grabbed = null;
        this.grabID = -1;
    }

    @Override
    public void drawTool(int mx, int my, float partialTick) {
        if (this.grabbed != null) {
            int snap = ToolboxGuiMain.getSnapValue();
            this.grabbed.field_146128_h = mx;
            this.grabbed.field_146129_i = my;
            int modX = (this.grabbed.field_146128_h % snap + snap) % snap;
            int modY = (this.grabbed.field_146129_i % snap + snap) % snap;
            this.grabbed.field_146128_h -= modX;
            this.grabbed.field_146129_i -= modY;
        }
        ToolboxGuiMain.drawGrid(this.gui);
    }

    @Override
    public void onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.grabbed != null) {
            IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getQuestLine().getValue(this.grabID);
            if (qle != null) {
                this.grabbed.field_146128_h = qle.getPosX();
                this.grabbed.field_146129_i = qle.getPosY();
            }
            this.grabbed = null;
            return;
        }
        if (click != 0) {
            return;
        }
        if (this.grabbed == null) {
            this.grabbed = this.gui.getQuestLine().getButtonAt(mx, my);
            this.grabID = this.grabbed == null ? -1 : QuestDatabase.INSTANCE.getKey(this.grabbed.getQuest());
        } else {
            IQuestLine qLine = this.gui.getQuestLine().getQuestLine();
            int lID = QuestLineDatabase.INSTANCE.getKey(qLine);
            IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getQuestLine().getValue(this.grabID);
            if (qle != null) {
                qle.setPosition(this.grabbed.field_146128_h, this.grabbed.field_146129_i);
                NBTTagCompound tag2 = new NBTTagCompound();
                JsonObject base2 = new JsonObject();
                base2.add("line", (JsonElement)qLine.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
                tag2.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base2, new NBTTagCompound()));
                tag2.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
                tag2.func_74768_a("lineID", lID);
                PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tag2));
            }
            this.grabbed = null;
            this.grabID = -1;
        }
    }

    @Override
    public void onMouseScroll(int mx, int my, int scroll) {
    }

    @Override
    public void onKeyPressed(char c, int keyCode) {
    }

    @Override
    public boolean allowTooltips() {
        return this.grabbed == null;
    }

    @Override
    public boolean allowScrolling(int click) {
        return this.grabbed == null || click == 2;
    }

    @Override
    public boolean allowZoom() {
        return true;
    }

    @Override
    public boolean clampScrolling() {
        return false;
    }
}

