/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.gui.controls.GuiButtonQuestInstance;
import betterquesting.api.client.gui.misc.IGuiQuestLine;
import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.NBTConverter;
import betterquesting.client.toolbox.ToolboxGuiMain;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.QuestLineEntry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ToolboxToolNew
implements IToolboxTool {
    IGuiQuestLine gui = null;
    GuiButtonQuestInstance nQuest;

    @Override
    public void initTool(IGuiQuestLine gui) {
        this.gui = gui;
        this.nQuest = new GuiButtonQuestInstance(0, 0, 0, 24, 24, new QuestInstance());
    }

    @Override
    public void drawTool(int mx, int my, float partialTick) {
        if (this.nQuest == null) {
            return;
        }
        int snap = ToolboxGuiMain.getSnapValue();
        int modX = (mx % snap + snap) % snap;
        int modY = (my % snap + snap) % snap;
        this.nQuest.field_146128_h = mx -= modX;
        this.nQuest.field_146129_i = my -= modY;
        this.nQuest.func_146112_a(Minecraft.func_71410_x(), mx, my);
        ToolboxGuiMain.drawGrid(this.gui);
    }

    @Override
    public void disableTool() {
        if (this.nQuest != null) {
            this.gui.getQuestLine().getButtonTree().remove((Object)this.nQuest);
            this.nQuest = null;
        }
    }

    @Override
    public void onMouseClick(int mx, int my, int click) {
        if (click != 0) {
            return;
        }
        int snap = ToolboxGuiMain.getSnapValue();
        int modX = (mx % snap + snap) % snap;
        int modY = (my % snap + snap) % snap;
        IQuestLine qLine = this.gui.getQuestLine().getQuestLine();
        QuestInstance quest = new QuestInstance();
        int qID = QuestDatabase.INSTANCE.nextKey();
        int lID = QuestLineDatabase.INSTANCE.getKey(qLine);
        QuestLineEntry qe = new QuestLineEntry(mx -= modX, my -= modY, 24);
        qLine.add(qe, qID);
        NBTTagCompound tag1 = new NBTTagCompound();
        JsonObject base1 = new JsonObject();
        base1.add("config", (JsonElement)quest.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        tag1.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base1, new NBTTagCompound()));
        tag1.func_74768_a("action", EnumPacketAction.ADD.ordinal());
        tag1.func_74768_a("questID", qID);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tag1));
        NBTTagCompound tag2 = new NBTTagCompound();
        JsonObject base2 = new JsonObject();
        base2.add("line", (JsonElement)qLine.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        tag2.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base2, new NBTTagCompound()));
        tag2.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tag2.func_74768_a("lineID", lID);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tag2));
    }

    @Override
    public void onMouseScroll(int mx, int my, int scroll) {
    }

    @Override
    public void onKeyPressed(char c, int keyCode) {
    }

    @Override
    public boolean allowTooltips() {
        return false;
    }

    @Override
    public boolean allowScrolling(int click) {
        return click == 2;
    }

    @Override
    public boolean allowZoom() {
        return true;
    }

    @Override
    public boolean clampScrolling() {
        return false;
    }
}

