/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands;

import betterquesting.api.api.QuestingAPI;
import betterquesting.storage.NameCache;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public abstract class QuestCommandBase {
    public abstract String getCommand();

    public String getUsageSuffix() {
        return "";
    }

    public boolean validArgs(String[] args) {
        return args.length == 1;
    }

    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        return new ArrayList<String>();
    }

    public abstract void runCommand(MinecraftServer var1, CommandBase var2, ICommandSender var3, String[] var4) throws CommandException;

    public final WrongUsageException getException(CommandBase command) {
        String message = command.func_71517_b() + " " + this.getCommand();
        if (this.getUsageSuffix().length() > 0) {
            message = message + " " + this.getUsageSuffix();
        }
        return new WrongUsageException(message, new Object[0]);
    }

    public UUID findPlayerID(MinecraftServer server, String name) {
        UUID playerID = null;
        EntityPlayerMP player = server.func_184103_al().func_152612_a(name);
        if (player == null) {
            try {
                playerID = UUID.fromString(name);
            }
            catch (Exception e) {
                playerID = NameCache.INSTANCE.getUUID(name);
            }
        } else {
            playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        }
        return playerID;
    }

    public boolean isArgUsername(String[] args, int index) {
        return false;
    }
}

