/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.commands.QuestCommandBase;
import betterquesting.network.PacketSender;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class QuestCommandDefaults
extends QuestCommandBase {
    @Override
    public String getUsageSuffix() {
        return "[save|load|set] [file_name]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 2 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"save", "load", "set"});
        }
        if (args.length == 3) {
            list.add("DefaultQuests");
        }
        return list;
    }

    @Override
    public String getCommand() {
        return "default";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) throws CommandException {
        File qFile = args.length == 3 && !args[2].equalsIgnoreCase("DefaultQuests") ? new File(BQ_Settings.defaultDir, "saved_quests/" + args[2] + ".json") : new File(BQ_Settings.defaultDir, "DefaultQuests.json");
        if (args[1].equalsIgnoreCase("save")) {
            JsonObject base = new JsonObject();
            base.add("questSettings", (JsonElement)QuestSettings.INSTANCE.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
            base.add("questDatabase", (JsonElement)QuestDatabase.INSTANCE.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
            base.add("questLines", (JsonElement)QuestLineDatabase.INSTANCE.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
            base.addProperty("format", "1.0.0");
            JsonHelper.WriteToFile(qFile, base);
            if (args.length == 3 && !args[2].equalsIgnoreCase("DefaultQuests")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.save2", new Object[]{args[2] + ".json"}));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.save", new Object[0]));
            }
        } else if (args[1].equalsIgnoreCase("load")) {
            if (qFile.exists()) {
                JsonArray jsonP = QuestDatabase.INSTANCE.writeToJson(new JsonArray(), EnumSaveType.PROGRESS);
                JsonObject j1 = JsonHelper.ReadFromFile(qFile);
                QuestSettings.INSTANCE.readFromJson(JsonHelper.GetObject(j1, "questSettings"), EnumSaveType.CONFIG);
                QuestDatabase.INSTANCE.readFromJson(JsonHelper.GetArray(j1, "questDatabase"), EnumSaveType.CONFIG);
                QuestLineDatabase.INSTANCE.readFromJson(JsonHelper.GetArray(j1, "questLines"), EnumSaveType.CONFIG);
                QuestDatabase.INSTANCE.readFromJson(jsonP, EnumSaveType.PROGRESS);
                if (args.length == 3 && !args[2].equalsIgnoreCase("DefaultQuests")) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.load2", new Object[]{args[2] + ".json"}));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.load", new Object[0]));
                }
                PacketSender.INSTANCE.sendToAll(QuestDatabase.INSTANCE.getSyncPacket());
                PacketSender.INSTANCE.sendToAll(QuestLineDatabase.INSTANCE.getSyncPacket());
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.none", new Object[0]));
            }
        } else if (args[1].equalsIgnoreCase("set") && args.length == 3) {
            if (qFile.exists() && !args[2].equalsIgnoreCase("DefaultQuests")) {
                File defFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
                if (defFile.exists()) {
                    defFile.delete();
                }
                JsonHelper.CopyPaste(qFile, defFile);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.set", new Object[]{args[2]}));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.none", new Object[0]));
            }
        } else {
            throw this.getException(command);
        }
    }
}

