/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.core;

import betterquesting.api.placeholders.EntityPlaceholder;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.placeholders.ItemPlaceholder;
import betterquesting.blocks.BlockSubmitStation;
import betterquesting.blocks.TileSubmitStation;
import betterquesting.client.CreativeTabQuesting;
import betterquesting.commands.BQ_CommandAdmin;
import betterquesting.commands.BQ_CommandUser;
import betterquesting.core.ExpansionLoader;
import betterquesting.core.proxies.CommonProxy;
import betterquesting.handlers.ConfigHandler;
import betterquesting.items.ItemExtraLife;
import betterquesting.items.ItemGuideBook;
import betterquesting.network.PacketQuesting;
import betterquesting.network.PacketTypeRegistry;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterquesting", version="2.3.231", name="BetterQuesting", guiFactory="betterquesting.handlers.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class BetterQuesting {
    public static final String MODID = "betterquesting";
    public static final String VERSION = "2.3.231";
    public static final String BRANCH = "";
    public static final String HASH = "";
    public static final String NAME = "BetterQuesting";
    public static final String PROXY = "betterquesting.core.proxies";
    public static final String CHANNEL = "BQ_NET_CHAN";
    public static final String FORMAT = "1.0.0";
    @Mod.Instance(value="betterquesting")
    public static BetterQuesting instance;
    @SidedProxy(clientSide="betterquesting.core.proxies.ClientProxy", serverSide="betterquesting.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static Logger logger;
    public static CreativeTabs tabQuesting;
    public static Item extraLife;
    public static Item guideBook;
    public static Block submitStation;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL);
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
        ExpansionLoader.INSTANCE.loadExpansions(event.getAsmData());
        if (PacketTypeRegistry.INSTANCE == null) {
            logger.log(Level.ERROR, "Unabled to instatiate packet registry");
        }
        this.network.registerMessage(PacketQuesting.HandleClient.class, PacketQuesting.class, 0, Side.CLIENT);
        this.network.registerMessage(PacketQuesting.HandleServer.class, PacketQuesting.class, 0, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FluidRegistry.registerFluid((Fluid)FluidPlaceholder.fluidPlaceholder);
        this.registerItem(ItemPlaceholder.placeholder, "placeholder");
        this.registerItem(extraLife, "extra_life");
        this.registerItem(guideBook, "guide_book");
        this.registerBlock(submitStation, "submit_station");
        GameRegistry.registerTileEntity(TileSubmitStation.class, (String)"submit_station");
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(submitStation), (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack(Blocks.field_150359_w), new ItemStack((Block)Blocks.field_150486_ae)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 1, 0), (Object[])new Object[]{new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 1, 0), (Object[])new Object[]{new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 1, 0), (Object[])new Object[]{new ItemStack(extraLife, 1, 1), new ItemStack(extraLife, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 2, 1), (Object[])new Object[]{new ItemStack(extraLife, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 1, 1), (Object[])new Object[]{new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 2, 2), (Object[])new Object[]{new ItemStack(extraLife, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(submitStation), (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack((Block)Blocks.field_150486_ae), new ItemStack(Blocks.field_150359_w)});
        EntityRegistry.registerModEntity(EntityPlaceholder.class, (String)"placeholder", (int)0, (Object)this, (int)16, (int)1, (boolean)false);
        proxy.registerRenderers();
    }

    public void registerBlock(Block b, String name) {
        ResourceLocation res = new ResourceLocation("betterquesting:" + name);
        GameRegistry.register((IForgeRegistryEntry)b, (ResourceLocation)res);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(b).setRegistryName(res));
    }

    public void registerItem(Item i, String name) {
        ResourceLocation res = new ResourceLocation("betterquesting:" + name);
        GameRegistry.register((IForgeRegistryEntry)i.setRegistryName(res));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.registerExpansions();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager manager = (ServerCommandManager)command;
        manager.func_71560_a((ICommand)new BQ_CommandAdmin());
        manager.func_71560_a((ICommand)new BQ_CommandUser());
    }

    static {
        tabQuesting = new CreativeTabQuesting();
        extraLife = new ItemExtraLife();
        guideBook = new ItemGuideBook();
        submitStation = new BlockSubmitStation();
    }
}

