/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.questing.tasks.ITickableTask;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.QuestCache;
import betterquesting.client.BQ_Keybindings;
import betterquesting.client.gui.GuiHome;
import betterquesting.client.gui.GuiQuestLinesMain;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.ConfigHandler;
import betterquesting.legacy.ILegacyLoader;
import betterquesting.legacy.LegacyLoaderRegistry;
import betterquesting.network.PacketSender;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class EventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (BQ_Keybindings.openQuests.func_151468_f()) {
            if (BQ_Settings.useBookmark && GuiQuestLinesMain.bookmarked != null) {
                mc.func_147108_a((GuiScreen)GuiQuestLinesMain.bookmarked);
            } else {
                mc.func_147108_a((GuiScreen)new GuiHome(mc.field_71462_r));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            UUID uuid = QuestingAPI.getQuestingUUID(player);
            ArrayList<IQuest> syncList = new ArrayList<IQuest>();
            ArrayList<QuestInstance> updateList = new ArrayList<QuestInstance>();
            for (Map.Entry<ITask, IQuest> entry : QuestCache.INSTANCE.getActiveTasks(uuid).entrySet()) {
                ITask task = entry.getKey();
                IQuest quest = entry.getValue();
                if (task.isComplete(uuid)) continue;
                task.update(player, quest);
                if (task instanceof ITickableTask) {
                    ((ITickableTask)((Object)task)).updateTask(player, quest);
                }
                if (!task.isComplete(uuid)) continue;
                if (!syncList.contains(quest)) {
                    syncList.add(quest);
                }
                if (updateList.contains(quest) || !(quest instanceof QuestInstance)) continue;
                updateList.add((QuestInstance)quest);
            }
            if (player.field_70173_aa % 20 == 0) {
                for (IQuest iQuest : QuestCache.INSTANCE.getActiveQuests(uuid)) {
                    iQuest.update(player);
                    if (!iQuest.isComplete(uuid) || syncList.contains(iQuest)) continue;
                    syncList.add(iQuest);
                    updateList.remove(iQuest);
                }
                QuestCache.INSTANCE.updateCache(player);
            } else {
                Iterator iterator = syncList.iterator();
                while (iterator.hasNext()) {
                    IQuest iQuest = (IQuest)iterator.next();
                    iQuest.update(player);
                    if (!iQuest.isComplete(uuid) || iQuest.canSubmit(player)) continue;
                    iterator.remove();
                    updateList.remove(iQuest);
                }
            }
            for (IQuest iQuest : syncList) {
                PacketSender.INSTANCE.sendToAll(iQuest.getSyncPacket());
            }
            for (QuestInstance questInstance : updateList) {
                questInstance.postPresetNotice(player, 1);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterquesting")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && BQ_Settings.curWorldDir != null && event.getWorld().field_73011_w.getDimension() == 0) {
            JsonObject jsonCon = new JsonObject();
            jsonCon.add("questSettings", (JsonElement)QuestSettings.INSTANCE.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
            jsonCon.add("questDatabase", (JsonElement)QuestDatabase.INSTANCE.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
            jsonCon.add("questLines", (JsonElement)QuestLineDatabase.INSTANCE.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
            jsonCon.addProperty("format", "1.0.0");
            JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "QuestDatabase.json"), jsonCon);
            JsonObject jsonProg = new JsonObject();
            jsonProg.add("questProgress", (JsonElement)QuestDatabase.INSTANCE.writeToJson(new JsonArray(), EnumSaveType.PROGRESS));
            JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "QuestProgress.json"), jsonProg);
            JsonObject jsonP = new JsonObject();
            jsonP.add("parties", (JsonElement)PartyManager.INSTANCE.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
            JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "QuestingParties.json"), jsonP);
            JsonObject jsonN = new JsonObject();
            jsonN.add("nameCache", (JsonElement)NameCache.INSTANCE.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
            JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "NameCache.json"), jsonN);
            JsonObject jsonL = new JsonObject();
            jsonL.add("lifeDatabase", (JsonElement)LifeDatabase.INSTANCE.writeToJson(new JsonObject(), EnumSaveType.PROGRESS));
            JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "LifeDatabase.json"), jsonL);
            MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Save());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && !event.getWorld().func_73046_m().func_71278_l()) {
            BQ_Settings.curWorldDir = null;
            QuestSettings.INSTANCE.reset();
            QuestDatabase.INSTANCE.reset();
            QuestLineDatabase.INSTANCE.reset();
            LifeDatabase.INSTANCE.reset();
            NameCache.INSTANCE.reset();
            QuestCache.INSTANCE.reset();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        String fVer;
        ILegacyLoader loader;
        File readDir;
        if (event.getWorld().field_72995_K || BQ_Settings.curWorldDir != null) {
            return;
        }
        QuestSettings.INSTANCE.reset();
        QuestDatabase.INSTANCE.reset();
        QuestLineDatabase.INSTANCE.reset();
        LifeDatabase.INSTANCE.reset();
        NameCache.INSTANCE.reset();
        if (BetterQuesting.proxy.isClient()) {
            GuiQuestLinesMain.bookmarked = null;
        }
        MinecraftServer server = event.getWorld().func_73046_m();
        if (BetterQuesting.proxy.isClient()) {
            BQ_Settings.curWorldDir = server.func_71209_f("saves/" + server.func_71270_I() + "/betterquesting");
            readDir = server.func_71209_f("saves/" + server.func_71270_I());
        } else {
            BQ_Settings.curWorldDir = server.func_71209_f(server.func_71270_I() + "/betterquesting");
            readDir = server.func_71209_f(server.func_71270_I());
        }
        boolean rename = false;
        File legFile = new File(readDir, "QuestDatabase.json");
        if (legFile.exists()) {
            rename = true;
        } else {
            readDir = BQ_Settings.curWorldDir;
        }
        File f1 = new File(readDir, "QuestDatabase.json");
        JsonObject j1 = new JsonObject();
        if (f1.exists()) {
            j1 = JsonHelper.ReadFromFile(f1);
            if (rename) {
                JsonHelper.CopyPaste(f1, new File(readDir, "QuestDatabase_Legacy.json"));
                f1.delete();
            }
        } else {
            f1 = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
            if (f1.exists()) {
                j1 = JsonHelper.ReadFromFile(f1);
            }
        }
        if ((loader = LegacyLoaderRegistry.getLoader(fVer = JsonHelper.GetString(j1, "format", "0.0.0"))) == null) {
            QuestSettings.INSTANCE.readFromJson(JsonHelper.GetObject(j1, "questSettings"), EnumSaveType.CONFIG);
            QuestDatabase.INSTANCE.readFromJson(JsonHelper.GetArray(j1, "questDatabase"), EnumSaveType.CONFIG);
            QuestLineDatabase.INSTANCE.readFromJson(JsonHelper.GetArray(j1, "questLines"), EnumSaveType.CONFIG);
        } else {
            loader.readFromJson((JsonElement)j1, EnumSaveType.CONFIG);
        }
        File f2 = new File(readDir, "QuestProgress.json");
        JsonObject j2 = new JsonObject();
        if (f2.exists()) {
            j2 = JsonHelper.ReadFromFile(f2);
            if (rename) {
                JsonHelper.CopyPaste(f2, new File(readDir, "QuestDatabase_Legacy.json"));
                f2.delete();
            }
        }
        if (loader == null) {
            QuestDatabase.INSTANCE.readFromJson(JsonHelper.GetArray(j2, "questProgress"), EnumSaveType.PROGRESS);
        } else {
            loader.readFromJson((JsonElement)j2, EnumSaveType.PROGRESS);
        }
        File f3 = new File(BQ_Settings.curWorldDir, "QuestingParties.json");
        JsonObject j3 = new JsonObject();
        if (f3.exists()) {
            j3 = JsonHelper.ReadFromFile(f3);
        }
        PartyManager.INSTANCE.readFromJson(JsonHelper.GetArray(j3, "parties"), EnumSaveType.CONFIG);
        File f4 = new File(BQ_Settings.curWorldDir, "NameCache.json");
        JsonObject j4 = new JsonObject();
        if (f4.exists()) {
            j4 = JsonHelper.ReadFromFile(f4);
        }
        NameCache.INSTANCE.readFromJson(JsonHelper.GetArray(j4, "nameCache"), EnumSaveType.CONFIG);
        File f5 = new File(BQ_Settings.curWorldDir, "LifeDatabase.json");
        JsonObject j5 = new JsonObject();
        if (f5.exists()) {
            j5 = JsonHelper.ReadFromFile(f5);
        }
        LifeDatabase.INSTANCE.readFromJson(JsonHelper.GetObject(j5, "lifeDatabase"), EnumSaveType.CONFIG);
        LifeDatabase.INSTANCE.readFromJson(JsonHelper.GetObject(j5, "lifeDatabase"), EnumSaveType.PROGRESS);
        BetterQuesting.logger.log(Level.INFO, "Loaded " + QuestDatabase.INSTANCE.size() + " quests");
        BetterQuesting.logger.log(Level.INFO, "Loaded " + QuestLineDatabase.INSTANCE.size() + " quest lines");
        BetterQuesting.logger.log(Level.INFO, "Loaded " + PartyManager.INSTANCE.size() + " parties");
        BetterQuesting.logger.log(Level.INFO, "Loaded " + NameCache.INSTANCE.size() + " names");
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Load());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
            NameCache.INSTANCE.updateNames(event.player.func_184102_h());
            PacketSender.INSTANCE.sendToPlayer(QuestSettings.INSTANCE.getSyncPacket(), mpPlayer);
            PacketSender.INSTANCE.sendToPlayer(QuestDatabase.INSTANCE.getSyncPacket(), mpPlayer);
            PacketSender.INSTANCE.sendToPlayer(QuestLineDatabase.INSTANCE.getSyncPacket(), mpPlayer);
            PacketSender.INSTANCE.sendToPlayer(LifeDatabase.INSTANCE.getSyncPacket(), mpPlayer);
            PacketSender.INSTANCE.sendToPlayer(PartyManager.INSTANCE.getSyncPacket(), mpPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue() && event.player instanceof EntityPlayerMP && !((EntityPlayerMP)event.player).field_71136_j) {
            int lives;
            EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
            IParty party = PartyManager.INSTANCE.getUserParty(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer));
            int n = lives = party == null || party.getProperties().getProperty(NativeProps.PARTY_LIVES) == false ? LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer)) : LifeDatabase.INSTANCE.getLives(party);
            if (lives <= 0) {
                MinecraftServer server = mpPlayer.func_184102_h();
                if (server == null) {
                    return;
                }
                mpPlayer.func_71033_a(GameType.SPECTATOR);
                mpPlayer.func_71121_q().func_82736_K().func_82764_b("spectatorsGenerateChunks", "false");
            } else if (lives == 1) {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString("This is your last life!"));
            } else {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString(lives + " lives remaining!"));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || !QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue()) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)event.getEntityLiving());
            IParty party = PartyManager.INSTANCE.getUserParty(uuid);
            if (party == null || !party.getProperties().getProperty(NativeProps.PARTY_LIVES).booleanValue()) {
                int lives = LifeDatabase.INSTANCE.getLives(uuid);
                LifeDatabase.INSTANCE.setLives(uuid, lives - 1);
            } else {
                int lives = LifeDatabase.INSTANCE.getLives(party);
                LifeDatabase.INSTANCE.setLives(party, lives - 1);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            event.getMap().func_174942_a(FluidPlaceholder.fluidPlaceholder.getStill());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDataUpdated(DatabaseEvent.Update event) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof INeedsRefresh) {
            ((INeedsRefresh)screen).refreshGui();
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (event.getCommand().func_71517_b().equalsIgnoreCase("op") || event.getCommand().func_71517_b().equalsIgnoreCase("deop"))) {
            NameCache.INSTANCE.updateNames(server);
        }
    }
}

