/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.misc;

import betterquesting.api.utils.JsonHelper;
import com.google.gson.JsonObject;
import java.util.UUID;

public class UserEntry {
    private UUID uuid;
    private long timestamp = 0L;
    private boolean claimed = false;

    public UserEntry(UUID uuid, long timestamp) {
        this(uuid);
        this.timestamp = timestamp;
    }

    public UserEntry(UUID uuid) {
        this.uuid = uuid;
    }

    public void setClaimed(boolean state, long time) {
        this.claimed = state;
        this.timestamp = time;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean hasClaimed() {
        return this.claimed;
    }

    public JsonObject writeToJson(JsonObject json) {
        json.addProperty("uuid", this.uuid.toString());
        json.addProperty("timestamp", (Number)this.timestamp);
        json.addProperty("claimed", Boolean.valueOf(this.claimed));
        return json;
    }

    public void readFromJson(JsonObject json) {
        this.uuid = UUID.fromString(JsonHelper.GetString(json, "uuid", ""));
        this.timestamp = JsonHelper.GetNumber(json, "timestamp", 0).longValue();
        this.claimed = JsonHelper.GetBoolean(json, "claimed", false);
    }
}

