/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketHandler;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketAssembly;
import betterquesting.network.PacketTypeRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class PacketQuesting
implements IMessage {
    protected NBTTagCompound tags = new NBTTagCompound();

    public PacketQuesting() {
    }

    protected PacketQuesting(NBTTagCompound tags) {
        this.tags = tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    public static class HandleClient
    implements IMessageHandler<PacketQuesting, IMessage> {
        public IMessage onMessage(PacketQuesting packet, MessageContext ctx) {
            if (packet == null || packet.tags == null) {
                BetterQuesting.logger.log(Level.ERROR, "A critical NPE error occured during while handling a BetterQuesting packet client side", (Throwable)new NullPointerException());
                return null;
            }
            final NBTTagCompound message = PacketAssembly.INSTANCE.assemblePacket(null, packet.tags);
            if (message == null) {
                return null;
            }
            if (!message.func_74764_b("ID")) {
                BetterQuesting.logger.log(Level.WARN, "Recieved a packet server side without an ID");
                return null;
            }
            final IPacketHandler handler = PacketTypeRegistry.INSTANCE.getPacketHandler(new ResourceLocation(message.func_74779_i("ID")));
            if (handler == null) {
                BetterQuesting.logger.log(Level.WARN, "Recieved a packet server side with an invalid ID: " + message.func_74779_i("ID"));
                return null;
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    handler.handleClient(message);
                }
            });
            return null;
        }
    }

    public static class HandleServer
    implements IMessageHandler<PacketQuesting, IMessage> {
        public IMessage onMessage(PacketQuesting packet, MessageContext ctx) {
            if (packet == null || packet.tags == null) {
                BetterQuesting.logger.log(Level.ERROR, "A critical NPE error occured during while handling a BetterQuesting packet server side", (Throwable)new NullPointerException());
                return null;
            }
            final EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            final NBTTagCompound message = PacketAssembly.INSTANCE.assemblePacket(sender == null ? null : QuestingAPI.getQuestingUUID((EntityPlayer)sender), packet.tags);
            if (message == null) {
                return null;
            }
            if (!message.func_74764_b("ID")) {
                BetterQuesting.logger.log(Level.WARN, "Recieved a packet server side without an ID");
                return null;
            }
            final IPacketHandler handler = PacketTypeRegistry.INSTANCE.getPacketHandler(new ResourceLocation(message.func_74779_i("ID")));
            if (handler == null) {
                BetterQuesting.logger.log(Level.WARN, "Recieved a packet server side with an invalid ID: " + message.func_74779_i("ID"));
                return null;
            }
            if (sender != null) {
                sender.func_184102_h().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        handler.handleServer(message, sender);
                    }
                });
            }
            return null;
        }
    }
}

