/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.network.IPacketHandler;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyInstance;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.NameCache;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class PktHandlerPartyAction
implements IPacketHandler {
    @Override
    public ResourceLocation getRegistryName() {
        return PacketTypeNative.PARTY_EDIT.GetLocation();
    }

    @Override
    public void handleServer(NBTTagCompound data, EntityPlayerMP sender) {
        int aID;
        if (sender == null) {
            return;
        }
        boolean isOp = sender.field_70170_p.func_73046_m().func_184103_al().func_152596_g(sender.func_146103_bH());
        int n = aID = !data.func_74764_b("action") ? -1 : data.func_74762_e("action");
        if (aID < 0 || aID >= EnumPacketAction.values().length) {
            return;
        }
        EnumPacketAction action = EnumPacketAction.values()[aID];
        int partyID = !data.func_74764_b("partyID") ? -1 : data.func_74762_e("partyID");
        UUID tarUser = null;
        IParty tarParty = null;
        EnumPartyStatus status = null;
        UUID senderID = QuestingAPI.getQuestingUUID((EntityPlayer)sender);
        if (isOp) {
            tarParty = PartyManager.INSTANCE.getValue(partyID);
            status = EnumPartyStatus.OWNER;
        } else {
            tarParty = action == EnumPacketAction.JOIN ? PartyManager.INSTANCE.getValue(partyID) : PartyManager.INSTANCE.getUserParty(senderID);
            if (tarParty != null) {
                status = tarParty.getStatus(senderID);
            }
        }
        try {
            tarUser = UUID.fromString(data.func_74779_i("target"));
        }
        catch (Exception e) {
            tarUser = NameCache.INSTANCE.getUUID(data.func_74779_i("target"));
        }
        if (action == EnumPacketAction.ADD && tarParty == null) {
            String name = data.func_74779_i("name");
            name = name.length() > 0 ? name : "New Party";
            PartyInstance nParty = new PartyInstance();
            nParty.getProperties().setProperty(NativeProps.NAME, name);
            nParty.inviteUser(senderID);
            PartyManager.INSTANCE.add(nParty, PartyManager.INSTANCE.nextKey());
            PacketSender.INSTANCE.sendToAll(PartyManager.INSTANCE.getSyncPacket());
            return;
        }
        if (action == EnumPacketAction.REMOVE && tarParty != null && status == EnumPartyStatus.OWNER) {
            PartyManager.INSTANCE.removeKey(partyID);
            PacketSender.INSTANCE.sendToAll(PartyManager.INSTANCE.getSyncPacket());
            return;
        }
        if (action == EnumPacketAction.KICK && tarUser != null && tarParty != null && status != null && (status.ordinal() >= 2 || tarUser == senderID)) {
            tarParty.kickUser(tarUser);
            PacketSender.INSTANCE.sendToAll(tarParty.getSyncPacket());
            return;
        }
        if (action == EnumPacketAction.EDIT && tarParty != null && status == EnumPartyStatus.OWNER) {
            tarParty.readPacket(data);
            PacketSender.INSTANCE.sendToAll(tarParty.getSyncPacket());
            return;
        }
        if (action == EnumPacketAction.JOIN && tarParty != null && (isOp || status == EnumPartyStatus.INVITE)) {
            if (isOp) {
                tarParty.inviteUser(senderID);
            }
            tarParty.setStatus(senderID, EnumPartyStatus.MEMBER);
            PacketSender.INSTANCE.sendToAll(tarParty.getSyncPacket());
            return;
        }
        if (action == EnumPacketAction.INVITE && tarParty != null && tarUser != null && status.ordinal() >= 2) {
            tarParty.inviteUser(tarUser);
            PacketSender.INSTANCE.sendToAll(tarParty.getSyncPacket());
            return;
        }
    }

    @Override
    public void handleClient(NBTTagCompound data) {
    }
}

