/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.IPacketHandler;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.Level;

public class PktHandlerQuestEdit
implements IPacketHandler {
    @Override
    public ResourceLocation getRegistryName() {
        return PacketTypeNative.QUEST_EDIT.GetLocation();
    }

    @Override
    public void handleServer(NBTTagCompound data, EntityPlayerMP sender) {
        if (sender == null) {
            return;
        }
        boolean isOP = sender.field_70170_p.func_73046_m().func_184103_al().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to edit quest without OP permissions!");
            sender.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be OP to edit quests!"));
            return;
        }
        int aID = !data.func_74764_b("action") ? -1 : data.func_74762_e("action");
        int qID = !data.func_74764_b("questID") ? -1 : data.func_74762_e("questID");
        IQuest quest = QuestDatabase.INSTANCE.getValue(qID);
        EnumPacketAction action = null;
        if (aID < 0 || aID >= EnumPacketAction.values().length) {
            return;
        }
        action = EnumPacketAction.values()[aID];
        if (action == EnumPacketAction.EDIT && quest != null) {
            quest.readPacket(data);
            PacketSender.INSTANCE.sendToAll(quest.getSyncPacket());
            return;
        }
        if (action == EnumPacketAction.REMOVE) {
            if (quest == null || qID < 0) {
                BetterQuesting.logger.log(Level.ERROR, sender.func_70005_c_() + " tried to delete non-existent quest with ID:" + qID);
                return;
            }
            BetterQuesting.logger.log(Level.INFO, "Player " + sender.func_70005_c_() + " deleted quest " + quest.getUnlocalisedName());
            QuestDatabase.INSTANCE.removeKey(qID);
            PacketSender.INSTANCE.sendToAll(QuestDatabase.INSTANCE.getSyncPacket());
            return;
        }
        if (action == EnumPacketAction.SET && quest != null) {
            if (data.func_74767_n("state")) {
                UUID senderID = QuestingAPI.getQuestingUUID((EntityPlayer)sender);
                quest.setComplete(senderID, 0L);
                int done = 0;
                if (!quest.getProperties().getProperty(NativeProps.LOGIC_TASK).getResult(done, quest.getTasks().size())) {
                    for (ITask task : quest.getTasks().getAllValues()) {
                        task.setComplete(senderID);
                        if (!quest.getProperties().getProperty(NativeProps.LOGIC_TASK).getResult(++done, quest.getTasks().size())) continue;
                        break;
                    }
                }
            } else {
                quest.resetAll(true);
            }
            PacketSender.INSTANCE.sendToAll(quest.getSyncPacket());
            return;
        }
        if (action == EnumPacketAction.ADD) {
            QuestInstance nq = new QuestInstance();
            int nID = QuestDatabase.INSTANCE.nextKey();
            if (data.func_74764_b("data") && data.func_74764_b("questID")) {
                nID = data.func_74762_e("questID");
                JsonObject base = NBTConverter.NBTtoJSON_Compound(data.func_74775_l("data"), new JsonObject());
                nq.readFromJson(JsonHelper.GetObject(base, "config"), EnumSaveType.CONFIG);
            }
            QuestDatabase.INSTANCE.add(nq, nID);
            PacketSender.INSTANCE.sendToAll(nq.getSyncPacket());
            return;
        }
    }

    @Override
    public void handleClient(NBTTagCompound data) {
    }
}

