/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.IPacketHandler;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.storage.QuestSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;

public class PktHandlerSettings
implements IPacketHandler {
    @Override
    public ResourceLocation getRegistryName() {
        return PacketTypeNative.SETTINGS.GetLocation();
    }

    @Override
    public void handleServer(NBTTagCompound tag, EntityPlayerMP sender) {
        if (sender == null) {
            return;
        }
        boolean isOP = sender.field_70170_p.func_73046_m().func_184103_al().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to edit settings without OP permissions!");
            sender.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be OP to edit quests!"));
            return;
        }
        QuestSettings.INSTANCE.readPacket(tag);
        PacketSender.INSTANCE.sendToAll(QuestSettings.INSTANCE.getSyncPacket());
    }

    @Override
    public void handleClient(NBTTagCompound tag) {
        QuestSettings.INSTANCE.readPacket(tag);
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update());
    }
}

