/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestInstance;
import betterquesting.questing.QuestLineDatabase;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class QuestDatabase
implements IQuestDatabase {
    public static final QuestDatabase INSTANCE = new QuestDatabase();
    private final ConcurrentHashMap<Integer, IQuest> database = new ConcurrentHashMap();

    private QuestDatabase() {
    }

    @Override
    public IQuest createNew() {
        QuestInstance q = new QuestInstance();
        q.setParentDatabase(this);
        return q;
    }

    @Override
    public Integer nextKey() {
        int id = 0;
        while (this.database.containsKey(id)) {
            ++id;
        }
        return id;
    }

    @Override
    public boolean add(IQuest obj, Integer id) {
        if (id < 0 || obj == null || this.database.containsKey(id) || this.database.containsValue(obj)) {
            return false;
        }
        obj.setParentDatabase(this);
        this.database.put(id, obj);
        return true;
    }

    @Override
    public boolean removeKey(Integer id) {
        IQuest remQ = this.database.remove(id);
        if (remQ == null) {
            return false;
        }
        for (IQuest quest : this.getAllValues()) {
            quest.getPrerequisites().remove(remQ);
        }
        QuestLineDatabase.INSTANCE.removeQuest(id);
        return true;
    }

    @Override
    public boolean removeValue(IQuest quest) {
        return this.removeKey(this.getKey(quest));
    }

    @Override
    public IQuest getValue(Integer id) {
        return this.database.get(id);
    }

    @Override
    public Integer getKey(IQuest quest) {
        for (Map.Entry<Integer, IQuest> entry : this.database.entrySet()) {
            if (entry.getValue() != quest) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public List<IQuest> getAllValues() {
        return new ArrayList<IQuest>(this.database.values());
    }

    @Override
    public List<Integer> getAllKeys() {
        return new ArrayList<Integer>(this.database.keySet());
    }

    @Override
    public int size() {
        return this.database.size();
    }

    @Override
    public void reset() {
        this.database.clear();
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject base = new JsonObject();
        base.add("config", (JsonElement)this.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
        base.add("progress", (JsonElement)this.writeToJson(new JsonArray(), EnumSaveType.PROGRESS));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        return new QuestingPacket(PacketTypeNative.QUEST_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        JsonObject base = NBTConverter.NBTtoJSON_Compound(payload.func_74775_l("data"), new JsonObject());
        this.readFromJson(JsonHelper.GetArray(base, "config"), EnumSaveType.CONFIG);
        this.readFromJson(JsonHelper.GetArray(base, "progress"), EnumSaveType.PROGRESS);
    }

    @Override
    public JsonArray writeToJson(JsonArray json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.writeToJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.writeToJson_Progress(json);
                break;
            }
        }
        return json;
    }

    @Override
    public void readFromJson(JsonArray json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.readFromJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.readFromJson_Progress(json);
                break;
            }
        }
    }

    private JsonArray writeToJson_Config(JsonArray json) {
        for (Map.Entry<Integer, IQuest> entry : this.database.entrySet()) {
            JsonObject jq = new JsonObject();
            entry.getValue().writeToJson(jq, EnumSaveType.CONFIG);
            jq.addProperty("questID", (Number)entry.getKey());
            json.add((JsonElement)jq);
        }
        return json;
    }

    private void readFromJson_Config(JsonArray json) {
        this.database.clear();
        for (JsonElement entry : json) {
            int qID;
            if (entry == null || !entry.isJsonObject() || (qID = JsonHelper.GetNumber(entry.getAsJsonObject(), "questID", -1).intValue()) < 0) continue;
            IQuest quest = this.getValue(qID);
            quest = quest != null ? quest : this.createNew();
            quest.readFromJson(entry.getAsJsonObject(), EnumSaveType.CONFIG);
            this.database.put(qID, quest);
        }
    }

    private JsonArray writeToJson_Progress(JsonArray json) {
        for (Map.Entry<Integer, IQuest> entry : this.database.entrySet()) {
            JsonObject jq = new JsonObject();
            entry.getValue().writeToJson(jq, EnumSaveType.PROGRESS);
            jq.addProperty("questID", (Number)entry.getKey());
            json.add((JsonElement)jq);
        }
        return json;
    }

    private void readFromJson_Progress(JsonArray json) {
        for (JsonElement entry : json) {
            IQuest quest;
            int qID;
            if (entry == null || !entry.isJsonObject() || (qID = JsonHelper.GetNumber(entry.getAsJsonObject(), "questID", -1).intValue()) < 0 || (quest = this.getValue(qID)) == null) continue;
            quest.readFromJson(entry.getAsJsonObject(), EnumSaveType.PROGRESS);
        }
    }
}

