/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.IRegStorageBase;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.core.BetterQuesting;
import betterquesting.misc.UserEntry;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.questing.rewards.RewardStorage;
import betterquesting.questing.tasks.TaskStorage;
import betterquesting.storage.PropertyContainer;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;

public class QuestInstance
implements IQuest {
    private final TaskStorage tasks = new TaskStorage();
    private final RewardStorage rewards = new RewardStorage();
    private final ArrayList<UserEntry> completeUsers = new ArrayList();
    private final ArrayList<IQuest> preRequisites = new ArrayList();
    private PropertyContainer qInfo = new PropertyContainer();
    private IQuestDatabase parentDB = QuestingAPI.getAPI(ApiReference.QUEST_DB);

    public QuestInstance() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Quest");
        this.setupValue(NativeProps.DESC, "No Description");
        this.setupValue(NativeProps.ICON, new BigItemStack(Items.field_151156_bN));
        this.setupValue(NativeProps.SOUND_COMPLETE);
        this.setupValue(NativeProps.SOUND_UPDATE);
        this.setupValue(NativeProps.LOGIC_QUEST, EnumLogic.AND);
        this.setupValue(NativeProps.LOGIC_TASK, EnumLogic.AND);
        this.setupValue(NativeProps.REPEAT_TIME, -1);
        this.setupValue(NativeProps.LOCKED_PROGRESS, false);
        this.setupValue(NativeProps.AUTO_CLAIM, false);
        this.setupValue(NativeProps.SILENT, false);
        this.setupValue(NativeProps.MAIN, false);
        this.setupValue(NativeProps.PARTY_LOOT, false);
        this.setupValue(NativeProps.GLOBAL_SHARE, false);
        this.setupValue(NativeProps.SIMULTANEOUS, false);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.qInfo.setProperty(prop, this.qInfo.getProperty(prop, def));
    }

    @Override
    public void setParentDatabase(IQuestDatabase questDB) {
        this.parentDB = questDB;
    }

    @Override
    public String getUnlocalisedName() {
        String def = "New Quest";
        if (!this.qInfo.hasProperty(NativeProps.NAME)) {
            this.qInfo.setProperty(NativeProps.NAME, def);
            return def;
        }
        return this.qInfo.getProperty(NativeProps.NAME, def);
    }

    @Override
    public String getUnlocalisedDescription() {
        String def = "No Description";
        if (!this.qInfo.hasProperty(NativeProps.DESC)) {
            this.qInfo.setProperty(NativeProps.DESC, def);
            return def;
        }
        return this.qInfo.getProperty(NativeProps.DESC, def);
    }

    @Override
    public BigItemStack getItemIcon() {
        BigItemStack def = new BigItemStack(Items.field_151156_bN);
        if (!this.qInfo.hasProperty(NativeProps.ICON)) {
            this.qInfo.setProperty(NativeProps.ICON, def);
            return def;
        }
        return this.qInfo.getProperty(NativeProps.ICON, def);
    }

    @Override
    public IPropertyContainer getProperties() {
        return this.qInfo;
    }

    @Override
    public void update(EntityPlayer player) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (this.isComplete(playerID)) {
            UserEntry entry = this.GetUserEntry(playerID);
            if (!this.hasClaimed(playerID)) {
                if (this.canClaim(player)) {
                    if (this.qInfo.getProperty(NativeProps.AUTO_CLAIM).booleanValue() && player.field_70173_aa % 20 == 0) {
                        this.claimReward(player);
                    }
                    return;
                }
                if (this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() < 0 || this.rewards.size() <= 0) {
                    return;
                }
            } else {
                if (this.rewards.size() > 0 && this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() >= 0 && player.field_70170_p.func_82737_E() - entry.getTimestamp() >= (long)this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue()) {
                    if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
                        this.resetAll(false);
                    } else {
                        this.resetUser(playerID, false);
                    }
                    if (!QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() && !this.qInfo.getProperty(NativeProps.SILENT).booleanValue()) {
                        this.postPresetNotice(player, 1);
                    }
                    PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
                    return;
                }
                return;
            }
        }
        if (this.isUnlocked(playerID) || this.qInfo.getProperty(NativeProps.LOCKED_PROGRESS).booleanValue()) {
            int done = 0;
            for (ITask tsk : this.tasks.getAllValues()) {
                if (!tsk.isComplete(playerID)) continue;
                IParty party = PartyManager.INSTANCE.getUserParty(playerID);
                if (party != null) {
                    for (UUID mem : party.getMembers()) {
                        tsk.setComplete(mem);
                    }
                }
                ++done;
            }
            if (!this.isUnlocked(playerID)) {
                return;
            }
            if ((this.tasks.size() > 0 || !QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) && this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size())) {
                this.setComplete(playerID, player.field_70170_p.func_82737_E());
                PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
                if (!QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() && !this.qInfo.getProperty(NativeProps.SILENT).booleanValue()) {
                    this.postPresetNotice(player, 2);
                }
            } else if (done > 0 && this.qInfo.getProperty(NativeProps.SIMULTANEOUS).booleanValue()) {
                this.resetUser(playerID, false);
                PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
            }
        }
    }

    @Override
    public void detect(EntityPlayer player) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (this.isComplete(playerID) && (this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() < 0 || this.rewards.size() <= 0)) {
            return;
        }
        if (!this.canSubmit(player)) {
            return;
        }
        if (this.isUnlocked(playerID) || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            int done = 0;
            boolean update = false;
            for (ITask tsk : this.tasks.getAllValues()) {
                if (!tsk.isComplete(playerID)) {
                    tsk.detect(player, this);
                    if (!tsk.isComplete(playerID)) continue;
                    IParty party = PartyManager.INSTANCE.getUserParty(playerID);
                    if (party != null) {
                        for (UUID mem : party.getMembers()) {
                            tsk.setComplete(mem);
                        }
                    }
                    ++done;
                    update = true;
                    continue;
                }
                ++done;
            }
            if ((this.tasks.size() > 0 || !QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) && this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size())) {
                this.setComplete(playerID, player.field_70170_p.func_82737_E());
                if (!QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() && !this.qInfo.getProperty(NativeProps.SILENT).booleanValue()) {
                    this.postPresetNotice(player, 2);
                }
            } else if (update && this.qInfo.getProperty(NativeProps.SIMULTANEOUS).booleanValue()) {
                this.resetUser(playerID, false);
                PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
            } else if (update && !QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() && !this.qInfo.getProperty(NativeProps.SILENT).booleanValue()) {
                this.postPresetNotice(player, 1);
            }
            PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
        }
    }

    public void postPresetNotice(EntityPlayer player, int preset) {
        switch (preset) {
            case 0: {
                this.postNotice(player, "betterquesting.notice.unlock", this.getUnlocalisedName(), this.qInfo.getProperty(NativeProps.SOUND_UNLOCK), this.getItemIcon());
                break;
            }
            case 1: {
                this.postNotice(player, "betterquesting.notice.update", this.getUnlocalisedName(), this.qInfo.getProperty(NativeProps.SOUND_UPDATE), this.getItemIcon());
                break;
            }
            case 2: {
                this.postNotice(player, "betterquesting.notice.complete", this.getUnlocalisedName(), this.qInfo.getProperty(NativeProps.SOUND_COMPLETE), this.getItemIcon());
            }
        }
    }

    public void postNotice(EntityPlayer player, String mainTxt, String subTxt, String sound, BigItemStack icon) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Main", mainTxt);
        tags.func_74778_a("Sub", subTxt);
        tags.func_74778_a("Sound", sound);
        tags.func_74782_a("Icon", (NBTBase)icon.writeToNBT(new NBTTagCompound()));
        QuestingPacket payload = new QuestingPacket(PacketTypeNative.NOTIFICATION.GetLocation(), tags);
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            PacketSender.INSTANCE.sendToAll(payload);
        } else if (player instanceof EntityPlayerMP) {
            List<EntityPlayerMP> tarList = this.getPartyPlayers((EntityPlayerMP)player);
            for (EntityPlayerMP p : tarList) {
                PacketSender.INSTANCE.sendToPlayer(payload, p);
            }
        }
    }

    private List<EntityPlayerMP> getPartyPlayers(EntityPlayerMP player) {
        ArrayList<EntityPlayerMP> list = new ArrayList<EntityPlayerMP>();
        IParty party = PartyManager.INSTANCE.getUserParty(QuestingAPI.getQuestingUUID((EntityPlayer)player));
        if (party == null) {
            list.add(player);
            return list;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (UUID mem : party.getMembers()) {
            for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                if (p == null || !QuestingAPI.getQuestingUUID((EntityPlayer)p).equals(mem)) continue;
                list.add(p);
            }
        }
        return list;
    }

    @Override
    public boolean hasClaimed(UUID uuid) {
        UserEntry entry;
        if (this.rewards.size() <= 0) {
            return true;
        }
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            if (this.GetParticipation(uuid) < this.qInfo.getProperty(NativeProps.PARTICIPATION).floatValue()) {
                return true;
            }
            if (!this.qInfo.getProperty(NativeProps.GLOBAL_SHARE).booleanValue()) {
                for (UserEntry entry2 : this.completeUsers) {
                    if (!entry2.hasClaimed()) continue;
                    return true;
                }
                return false;
            }
        }
        if ((entry = this.GetUserEntry(uuid)) == null) {
            return false;
        }
        return entry.hasClaimed();
    }

    @Override
    public boolean canClaim(EntityPlayer player) {
        UserEntry entry = this.GetUserEntry(QuestingAPI.getQuestingUUID(player));
        if (entry == null || this.hasClaimed(QuestingAPI.getQuestingUUID(player))) {
            return false;
        }
        if (this.canSubmit(player)) {
            return false;
        }
        for (IReward rew : this.rewards.getAllValues()) {
            if (rew.canClaim(player, this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void claimReward(EntityPlayer player) {
        for (IReward rew : this.rewards.getAllValues()) {
            rew.claimReward(player, this);
        }
        UUID pID = QuestingAPI.getQuestingUUID(player);
        IParty party = PartyManager.INSTANCE.getUserParty(pID);
        if (party != null && this.qInfo.getProperty(NativeProps.PARTY_LOOT).booleanValue()) {
            for (UUID mem : party.getMembers()) {
                EnumPartyStatus pStat = party.getStatus(mem);
                if (pStat == null || pStat == EnumPartyStatus.INVITE) continue;
                UserEntry entry = this.GetUserEntry(mem);
                if (entry == null) {
                    entry = new UserEntry(mem);
                    this.completeUsers.add(entry);
                }
                entry.setClaimed(true, player.field_70170_p.func_82737_E());
            }
        } else {
            UserEntry entry = this.GetUserEntry(pID);
            if (entry == null) {
                entry = new UserEntry(pID);
                this.completeUsers.add(entry);
            }
            entry.setClaimed(true, player.field_70170_p.func_82737_E());
        }
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public boolean canSubmit(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        UserEntry entry = this.GetUserEntry(playerID);
        if (entry == null) {
            return true;
        }
        if (!entry.hasClaimed() && this.getProperties().getProperty(NativeProps.REPEAT_TIME).intValue() >= 0) {
            int done = 0;
            for (ITask tsk : this.tasks.getAllValues()) {
                if (!tsk.isComplete(playerID)) continue;
                ++done;
            }
            return !this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size());
        }
        return false;
    }

    private float GetParticipation(UUID uuid) {
        if (this.tasks.size() <= 0) {
            return 0.0f;
        }
        float total = 0.0f;
        for (ITask t : this.tasks.getAllValues()) {
            if (!(t instanceof IProgression)) continue;
            total += ((IProgression)((Object)t)).getParticipation(uuid);
        }
        return total / (float)this.tasks.size();
    }

    @Override
    public List<String> getTooltip(EntityPlayer player) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            return this.getAdvancedTooltip(player);
        }
        return this.getStandardTooltip(player);
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getStandardTooltip(EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)this.getUnlocalisedName(), (Object[])new Object[0]));
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (this.isComplete(playerID)) {
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"betterquesting.tooltip.complete", (Object[])new Object[0]));
            if (!this.hasClaimed(playerID)) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.rewards_pending", (Object[])new Object[0]));
            } else if (this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() > 0) {
                long time = this.getRepeatSeconds(player);
                DecimalFormat df = new DecimalFormat("00");
                String timeTxt = "";
                if (time >= 3600L) {
                    timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
                } else if (time >= 60L) {
                    timeTxt = timeTxt + time / 60L + "m ";
                }
                timeTxt = timeTxt + df.format(time % 60L) + "s";
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.repeat", (Object[])new Object[]{timeTxt}));
            }
        } else if (!this.isUnlocked(playerID)) {
            list.add(TextFormatting.RED + "" + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"betterquesting.tooltip.requires", (Object[])new Object[0]) + " (" + this.qInfo.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase() + ")");
            for (IQuest req : this.preRequisites) {
                if (req.isComplete(playerID)) continue;
                list.add(TextFormatting.RED + "- " + I18n.func_135052_a((String)req.getUnlocalisedName(), (Object[])new Object[0]));
            }
        } else {
            int n = 0;
            for (ITask task : this.tasks.getAllValues()) {
                if (!task.isComplete(playerID)) continue;
                ++n;
            }
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.tasks_complete", (Object[])new Object[]{n, this.tasks.size()}));
        }
        list.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.shift_advanced", (Object[])new Object[0]));
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getAdvancedTooltip(EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)this.getUnlocalisedName(), (Object[])new Object[0]) + " #" + this.parentDB.getKey(this));
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.main_quest", (Object[])new Object[]{this.qInfo.getProperty(NativeProps.MAIN)}));
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.global_quest", (Object[])new Object[]{this.qInfo.getProperty(NativeProps.GLOBAL)}));
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.global_share", (Object[])new Object[]{this.qInfo.getProperty(NativeProps.GLOBAL_SHARE)}));
        }
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.task_logic", (Object[])new Object[]{this.qInfo.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase()}));
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.simultaneous", (Object[])new Object[]{this.qInfo.getProperty(NativeProps.SIMULTANEOUS)}));
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.auto_claim", (Object[])new Object[]{this.qInfo.getProperty(NativeProps.AUTO_CLAIM)}));
        if (this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() >= 0) {
            long time = this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() / 20;
            DecimalFormat df = new DecimalFormat("00");
            String timeTxt = "";
            if (time >= 3600L) {
                timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
            } else if (time >= 60L) {
                timeTxt = timeTxt + time / 60L + "m ";
            }
            timeTxt = timeTxt + df.format(time % 60L) + "s";
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.repeat", (Object[])new Object[]{timeTxt}));
        } else {
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"betterquesting.tooltip.repeat", (Object[])new Object[]{false}));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public long getRepeatSeconds(EntityPlayer player) {
        if (this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() < 0) {
            return -1L;
        }
        UserEntry ue = this.GetUserEntry(QuestingAPI.getQuestingUUID(player));
        if (ue == null) {
            return 0L;
        }
        return ((long)this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() - (player.field_70170_p.func_82737_E() - ue.getTimestamp())) / 20L;
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject base = new JsonObject();
        base.add("config", (JsonElement)this.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        base.add("progress", (JsonElement)this.writeToJson(new JsonObject(), EnumSaveType.PROGRESS));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        tags.func_74768_a("questID", ((Integer)this.parentDB.getKey(this)).intValue());
        return new QuestingPacket(PacketTypeNative.QUEST_SYNC.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        JsonObject base = NBTConverter.NBTtoJSON_Compound(payload.func_74775_l("data"), new JsonObject());
        this.readFromJson(JsonHelper.GetObject(base, "config"), EnumSaveType.CONFIG);
        this.readFromJson(JsonHelper.GetObject(base, "progress"), EnumSaveType.PROGRESS);
    }

    @Override
    public boolean isUnlocked(UUID uuid) {
        int A = 0;
        int B = this.preRequisites.size();
        if (B <= 0) {
            return true;
        }
        for (IQuest quest : this.preRequisites) {
            if (quest == null || !quest.isComplete(uuid)) continue;
            ++A;
        }
        return this.qInfo.getProperty(NativeProps.LOGIC_QUEST).getResult(A, B);
    }

    @Override
    public void setComplete(UUID uuid, long timestamp) {
        IParty party = PartyManager.INSTANCE.getUserParty(uuid);
        if (party == null) {
            UserEntry entry = this.GetUserEntry(uuid);
            if (entry != null) {
                entry.setClaimed(false, timestamp);
            } else {
                this.completeUsers.add(new UserEntry(uuid, timestamp));
            }
        } else {
            for (UUID mem : party.getMembers()) {
                UserEntry entry = this.GetUserEntry(mem);
                if (entry != null) {
                    entry.setClaimed(false, timestamp);
                    continue;
                }
                this.completeUsers.add(new UserEntry(mem, timestamp));
            }
        }
    }

    @Override
    public boolean isComplete(UUID uuid) {
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            return this.completeUsers.size() > 0;
        }
        return this.GetUserEntry(uuid) != null;
    }

    private void RemoveUserEntry(UUID ... uuid) {
        boolean flag = false;
        block0: for (int i = this.completeUsers.size() - 1; i >= 0; --i) {
            UserEntry entry = this.completeUsers.get(i);
            for (UUID id : uuid) {
                if (!entry.getUUID().equals(id)) continue;
                this.completeUsers.remove(i);
                flag = true;
                continue block0;
            }
        }
        if (flag) {
            PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
        }
    }

    @Override
    public EnumQuestState getState(UUID uuid) {
        if (this.isComplete(uuid)) {
            if (this.hasClaimed(uuid)) {
                return EnumQuestState.COMPLETED;
            }
            return EnumQuestState.UNCLAIMED;
        }
        if (this.isUnlocked(uuid)) {
            return EnumQuestState.UNLOCKED;
        }
        return EnumQuestState.LOCKED;
    }

    private UserEntry GetUserEntry(UUID uuid) {
        for (UserEntry entry : this.completeUsers) {
            if (!entry.getUUID().equals(uuid)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void resetUser(UUID uuid, boolean fullReset) {
        if (fullReset) {
            this.RemoveUserEntry(uuid);
        } else {
            UserEntry entry = this.GetUserEntry(uuid);
            if (entry != null) {
                entry.setClaimed(false, 0L);
            }
        }
        for (ITask t : this.tasks.getAllValues()) {
            t.resetUser(uuid);
        }
    }

    @Override
    public void resetAll(boolean fullReset) {
        if (fullReset) {
            this.completeUsers.clear();
        } else {
            for (UserEntry entry : this.completeUsers) {
                entry.setClaimed(false, 0L);
            }
        }
        for (ITask t : this.tasks.getAllValues()) {
            t.resetAll();
        }
    }

    @Override
    public IRegStorageBase<Integer, ITask> getTasks() {
        return this.tasks;
    }

    @Override
    public IRegStorageBase<Integer, IReward> getRewards() {
        return this.rewards;
    }

    @Override
    public List<IQuest> getPrerequisites() {
        return this.preRequisites;
    }

    @Override
    public JsonObject writeToJson(JsonObject json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.writeToJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.writeToJson_Progress(json);
                break;
            }
        }
        return json;
    }

    @Override
    public void readFromJson(JsonObject json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.readFromJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.readFromJson_Progress(json);
                break;
            }
        }
    }

    private JsonObject writeToJson_Config(JsonObject jObj) {
        jObj.add("properties", (JsonElement)this.qInfo.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        jObj.add("tasks", (JsonElement)this.tasks.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
        jObj.add("rewards", (JsonElement)this.rewards.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
        JsonArray reqJson = new JsonArray();
        for (IQuest quest : this.preRequisites) {
            int prID = (Integer)this.parentDB.getKey(quest);
            if (prID < 0) continue;
            reqJson.add((JsonElement)new JsonPrimitive((Number)prID));
        }
        jObj.add("preRequisites", (JsonElement)reqJson);
        return jObj;
    }

    private void readFromJson_Config(JsonObject jObj) {
        this.qInfo.readFromJson(JsonHelper.GetObject(jObj, "properties"), EnumSaveType.CONFIG);
        this.tasks.readFromJson(JsonHelper.GetArray(jObj, "tasks"), EnumSaveType.CONFIG);
        this.rewards.readFromJson(JsonHelper.GetArray(jObj, "rewards"), EnumSaveType.CONFIG);
        this.preRequisites.clear();
        for (JsonElement entry : JsonHelper.GetArray(jObj, "preRequisites")) {
            int prID;
            if (entry == null || !entry.isJsonPrimitive() || !entry.getAsJsonPrimitive().isNumber() || (prID = entry.getAsInt()) < 0) continue;
            IQuest tmp = (IQuest)this.parentDB.getValue(prID);
            if (tmp == null) {
                tmp = this.parentDB.createNew();
                this.parentDB.add(tmp, prID);
            }
            this.preRequisites.add(tmp);
        }
        this.setupProps();
    }

    private JsonObject writeToJson_Progress(JsonObject json) {
        JsonArray comJson = new JsonArray();
        for (UserEntry entry : this.completeUsers) {
            comJson.add((JsonElement)entry.writeToJson(new JsonObject()));
        }
        json.add("completed", (JsonElement)comJson);
        JsonArray tskJson = this.tasks.writeToJson(new JsonArray(), EnumSaveType.PROGRESS);
        json.add("tasks", (JsonElement)tskJson);
        return json;
    }

    private void readFromJson_Progress(JsonObject json) {
        this.completeUsers.clear();
        for (JsonElement entry : JsonHelper.GetArray(json, "completed")) {
            if (entry == null || !entry.isJsonObject()) continue;
            try {
                UUID uuid = UUID.fromString(JsonHelper.GetString(entry.getAsJsonObject(), "uuid", ""));
                UserEntry user = new UserEntry(uuid);
                user.readFromJson(entry.getAsJsonObject());
                this.completeUsers.add(user);
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for quest", (Throwable)e);
            }
        }
        this.tasks.readFromJson(JsonHelper.GetArray(json, "tasks"), EnumSaveType.PROGRESS);
    }
}

