/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestLineEntry;
import betterquesting.storage.PropertyContainer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class QuestLine
implements IQuestLine {
    private IPropertyContainer info = new PropertyContainer();
    private final HashMap<Integer, IQuestLineEntry> questList = new HashMap();
    private IQuestLineDatabase parentDB = QuestingAPI.getAPI(ApiReference.LINE_DB);

    public QuestLine() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Quest Line");
        this.setupValue(NativeProps.DESC, "No Description");
        this.setupValue(NativeProps.BG_IMAGE);
        this.setupValue(NativeProps.BG_SIZE);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.info.setProperty(prop, this.info.getProperty(prop, def));
    }

    @Override
    public void setParentDatabase(IQuestLineDatabase lineDB) {
        this.parentDB = lineDB;
    }

    @Override
    public String getUnlocalisedName() {
        String def = "New Quest Line";
        if (!this.info.hasProperty(NativeProps.NAME)) {
            this.info.setProperty(NativeProps.NAME, def);
            return def;
        }
        return this.info.getProperty(NativeProps.NAME, def);
    }

    @Override
    public String getUnlocalisedDescription() {
        String def = "No Description";
        if (!this.info.hasProperty(NativeProps.DESC)) {
            this.info.setProperty(NativeProps.DESC, def);
            return def;
        }
        return this.info.getProperty(NativeProps.DESC, def);
    }

    @Override
    public IQuestLineEntry createNewEntry() {
        return new QuestLineEntry(0, 0, 24);
    }

    @Override
    public IPropertyContainer getProperties() {
        return this.info;
    }

    @Override
    public int getQuestAt(int x, int y) {
        for (Map.Entry<Integer, IQuestLineEntry> entry : this.questList.entrySet()) {
            int i1 = entry.getValue().getPosX();
            int j1 = entry.getValue().getPosY();
            int i2 = i1 + entry.getValue().getSize();
            int j2 = j1 + entry.getValue().getSize();
            if (x < i1 || x >= i2 || y < j1 || y >= j2) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    @Deprecated
    public Integer nextKey() {
        return -1;
    }

    @Override
    public boolean add(IQuestLineEntry entry, Integer questID) {
        if (questID < 0 || entry == null || this.questList.containsKey(questID) || this.questList.containsValue(entry)) {
            return false;
        }
        this.questList.put(questID, entry);
        return true;
    }

    @Override
    public boolean removeKey(Integer questID) {
        return this.questList.remove(questID) != null;
    }

    @Override
    public boolean removeValue(IQuestLineEntry entry) {
        return this.removeKey(this.getKey(entry));
    }

    @Override
    public IQuestLineEntry getValue(Integer questID) {
        return this.questList.get(questID);
    }

    @Override
    public Integer getKey(IQuestLineEntry entry) {
        for (Map.Entry<Integer, IQuestLineEntry> list : this.questList.entrySet()) {
            if (list.getValue() != entry) continue;
            return list.getKey();
        }
        return -1;
    }

    @Override
    public List<IQuestLineEntry> getAllValues() {
        return new ArrayList<IQuestLineEntry>(this.questList.values());
    }

    @Override
    public List<Integer> getAllKeys() {
        return new ArrayList<Integer>(this.questList.keySet());
    }

    @Override
    public int size() {
        return this.questList.size();
    }

    @Override
    public void reset() {
        this.questList.clear();
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject base = new JsonObject();
        base.add("line", (JsonElement)this.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        tags.func_74768_a("lineID", ((Integer)this.parentDB.getKey(this)).intValue());
        return new QuestingPacket(PacketTypeNative.LINE_SYNC.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        JsonObject base = NBTConverter.NBTtoJSON_Compound(payload.func_74775_l("data"), new JsonObject());
        this.readFromJson(JsonHelper.GetObject(base, "line"), EnumSaveType.CONFIG);
    }

    @Override
    public JsonObject writeToJson(JsonObject json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        json.add("properties", (JsonElement)this.info.writeToJson(new JsonObject(), saveType));
        JsonArray jArr = new JsonArray();
        for (Map.Entry<Integer, IQuestLineEntry> entry : this.questList.entrySet()) {
            JsonObject qle = entry.getValue().writeToJson(new JsonObject(), saveType);
            qle.addProperty("id", (Number)entry.getKey());
            jArr.add((JsonElement)qle);
        }
        json.add("quests", (JsonElement)jArr);
        return json;
    }

    @Override
    public void readFromJson(JsonObject json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.info.readFromJson(JsonHelper.GetObject(json, "properties"), saveType);
        this.questList.clear();
        for (JsonElement entry : JsonHelper.GetArray(json, "quests")) {
            JsonObject jl;
            int id;
            if (entry == null) continue;
            if (entry.isJsonPrimitive() && entry.getAsJsonPrimitive().isNumber()) {
                this.questList.put(entry.getAsInt(), new QuestLineEntry(0, 0));
                continue;
            }
            if (!entry.isJsonObject() || (id = JsonHelper.GetNumber(jl = entry.getAsJsonObject(), "id", -1).intValue()) < 0) continue;
            this.questList.put(id, new QuestLineEntry(jl));
        }
        this.setupProps();
    }
}

