/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.misc.QuestLineSortByKey;
import betterquesting.misc.QuestLineSortByValue;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestLine;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class QuestLineDatabase
implements IQuestLineDatabase {
    public static final QuestLineDatabase INSTANCE = new QuestLineDatabase();
    private final ConcurrentHashMap<Integer, IQuestLine> questLines = new ConcurrentHashMap();
    private final List<Integer> lineOrder = new ArrayList<Integer>();

    private QuestLineDatabase() {
    }

    @Override
    public int getOrderIndex(int lineID) {
        if (!this.questLines.containsKey(lineID)) {
            return -1;
        }
        if (!this.lineOrder.contains(lineID)) {
            this.lineOrder.add(lineID);
        }
        return this.lineOrder.indexOf(lineID);
    }

    @Override
    public void setOrderIndex(int lineID, int index) {
        this.lineOrder.remove((Object)lineID);
        this.lineOrder.add(index, lineID);
    }

    @Override
    public IQuestLine createNew() {
        return new QuestLine();
    }

    @Override
    public void removeQuest(int questID) {
        for (IQuestLine ql : this.getAllValues()) {
            ql.removeKey(questID);
        }
    }

    @Override
    public Integer nextKey() {
        int id = 0;
        while (this.questLines.containsKey(id)) {
            ++id;
        }
        return id;
    }

    @Override
    public boolean add(IQuestLine questLine, Integer id) {
        if (id < 0 || questLine == null || this.questLines.containsValue(questLine) || this.questLines.containsKey(id)) {
            return false;
        }
        this.questLines.put(id, questLine);
        return true;
    }

    @Override
    public boolean removeKey(Integer lineId) {
        return this.questLines.remove(lineId) != null;
    }

    @Override
    public boolean removeValue(IQuestLine quest) {
        return this.removeKey(this.getKey(quest));
    }

    @Override
    public Integer getKey(IQuestLine questLine) {
        for (Map.Entry<Integer, IQuestLine> entry : this.questLines.entrySet()) {
            if (entry.getValue() != questLine) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public IQuestLine getValue(Integer lineId) {
        return lineId < 0 ? null : this.questLines.get(lineId);
    }

    @Override
    public List<IQuestLine> getAllValues() {
        ArrayList<IQuestLine> list = new ArrayList<IQuestLine>(this.questLines.values());
        Collections.sort(list, new QuestLineSortByValue(this));
        return list;
    }

    @Override
    public List<Integer> getAllKeys() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.questLines.keySet());
        Collections.sort(list, new QuestLineSortByKey(this));
        return list;
    }

    @Override
    public int size() {
        return this.questLines.size();
    }

    @Override
    public void reset() {
        this.questLines.clear();
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject base = new JsonObject();
        base.add("questLines", (JsonElement)this.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        return new QuestingPacket(PacketTypeNative.LINE_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        JsonObject base = NBTConverter.NBTtoJSON_Compound(payload.func_74775_l("data"), new JsonObject());
        this.readFromJson(JsonHelper.GetArray(base, "questLines"), EnumSaveType.CONFIG);
    }

    @Override
    public JsonArray writeToJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (Map.Entry<Integer, IQuestLine> entry : this.questLines.entrySet()) {
            if (entry.getValue() == null) continue;
            int id = entry.getKey();
            JsonObject jObj = entry.getValue().writeToJson(new JsonObject(), saveType);
            jObj.addProperty("lineID", (Number)id);
            jObj.addProperty("order", (Number)this.getOrderIndex(id));
            json.add((JsonElement)jObj);
        }
        return json;
    }

    @Override
    public void readFromJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.questLines.clear();
        ArrayList<QuestLine> unassigned = new ArrayList<QuestLine>();
        HashMap<Integer, Integer> orderMap = new HashMap<Integer, Integer>();
        for (JsonElement iterator : json) {
            if (iterator == null || !iterator.isJsonObject()) continue;
            JsonObject jql = iterator.getAsJsonObject();
            int id = JsonHelper.GetNumber(jql, "lineID", -1).intValue();
            int order = JsonHelper.GetNumber(jql, "order", -1).intValue();
            QuestLine line = new QuestLine();
            line.readFromJson(iterator.getAsJsonObject(), saveType);
            if (id >= 0) {
                this.questLines.put(id, line);
            } else {
                unassigned.add(line);
            }
            if (order < 0) continue;
            orderMap.put(order, id);
        }
        for (IQuestLine iQuestLine : unassigned) {
            this.questLines.put(this.nextKey(), iQuestLine);
        }
        ArrayList orderKeys = new ArrayList(orderMap.keySet());
        Collections.sort(orderKeys);
        this.lineOrder.clear();
        Iterator iterator = orderKeys.iterator();
        while (iterator.hasNext()) {
            int o = (Integer)iterator.next();
            this.lineOrder.add((Integer)orderMap.get(o));
        }
    }
}

