/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.JsonHelper;
import com.google.gson.JsonObject;

public class QuestLineEntry
implements IQuestLineEntry {
    private int size = 0;
    private int posX = 0;
    private int posY = 0;

    public QuestLineEntry(JsonObject json) {
        this.readFromJson(json, EnumSaveType.CONFIG);
    }

    public QuestLineEntry(int x, int y) {
        this(x, y, 24);
    }

    public QuestLineEntry(int x, int y, int size) {
        this.size = size;
        this.posX = x;
        this.posY = y;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosY() {
        return this.posY;
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public JsonObject writeToJson(JsonObject json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        json.addProperty("size", (Number)this.size);
        json.addProperty("x", (Number)this.posX);
        json.addProperty("y", (Number)this.posY);
        return json;
    }

    @Override
    public void readFromJson(JsonObject json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.size = JsonHelper.GetNumber(json, "size", 24).intValue();
        this.posX = JsonHelper.GetNumber(json, "x", 0).intValue();
        this.posY = JsonHelper.GetNumber(json, "y", 0).intValue();
    }
}

