/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.PropertyContainer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PartyInstance
implements IParty {
    private HashMap<UUID, EnumPartyStatus> members = new HashMap();
    private PropertyContainer pInfo = new PropertyContainer();

    public PartyInstance() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Party");
        this.setupValue(NativeProps.PARTY_LIVES);
        this.setupValue(NativeProps.PARTY_LOOT);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.pInfo.setProperty(prop, this.pInfo.getProperty(prop, def));
    }

    @Override
    public String getName() {
        return this.pInfo.getProperty(NativeProps.NAME, "New Party");
    }

    @Override
    @Deprecated
    public boolean getShareLives() {
        return this.pInfo.getProperty(NativeProps.PARTY_LIVES, false);
    }

    @Override
    @Deprecated
    public boolean getShareReward() {
        return false;
    }

    @Override
    public IPropertyContainer getProperties() {
        return this.pInfo;
    }

    @Override
    public void inviteUser(UUID uuid) {
        if (uuid == null || this.members.containsKey(uuid)) {
            return;
        }
        if (this.members.size() == 0) {
            this.members.put(uuid, EnumPartyStatus.OWNER);
        } else {
            this.members.put(uuid, EnumPartyStatus.INVITE);
        }
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public void kickUser(UUID uuid) {
        if (!this.members.containsKey(uuid)) {
            return;
        }
        EnumPartyStatus old = this.members.get(uuid);
        this.members.remove(uuid);
        if (this.members.size() <= 0) {
            PartyManager.INSTANCE.removeValue(this);
            PacketSender.INSTANCE.sendToAll(PartyManager.INSTANCE.getSyncPacket());
        } else if (old == EnumPartyStatus.OWNER) {
            this.hostMigrate();
        }
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public void setStatus(UUID uuid, EnumPartyStatus priv) {
        if (!this.members.containsKey(uuid)) {
            return;
        }
        EnumPartyStatus old = this.members.get(uuid);
        if (old == priv) {
            return;
        }
        this.members.put(uuid, priv);
        if (priv == EnumPartyStatus.OWNER) {
            for (UUID mem : this.getMembers()) {
                if (mem == uuid || this.members.get(mem) != EnumPartyStatus.OWNER) continue;
                this.members.put(mem, EnumPartyStatus.ADMIN);
                break;
            }
        } else if (old == EnumPartyStatus.OWNER) {
            UUID migrate = null;
            for (UUID mem : this.getMembers()) {
                if (mem == uuid) continue;
                if (this.members.get(mem) == EnumPartyStatus.ADMIN) {
                    migrate = mem;
                    break;
                }
                if (migrate != null) continue;
                migrate = mem;
            }
            if (migrate == null) {
                this.members.put(uuid, old);
                return;
            }
            this.members.put(migrate, EnumPartyStatus.OWNER);
        }
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public EnumPartyStatus getStatus(UUID uuid) {
        return this.members.get(uuid);
    }

    @Override
    public List<UUID> getMembers() {
        return new ArrayList<UUID>(this.members.keySet());
    }

    private void hostMigrate() {
        List<UUID> tmp = this.getMembers();
        for (UUID uuid : tmp) {
            if (this.members.get(uuid) != EnumPartyStatus.OWNER) continue;
            return;
        }
        UUID migrate = null;
        for (UUID mem : this.getMembers()) {
            if (this.members.get(mem) == EnumPartyStatus.ADMIN) {
                migrate = mem;
                break;
            }
            if (migrate != null) continue;
            migrate = mem;
        }
        if (migrate != null) {
            this.members.put(migrate, EnumPartyStatus.OWNER);
        }
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject base = new JsonObject();
        base.add("party", (JsonElement)this.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        tags.func_74768_a("partyID", PartyManager.INSTANCE.getKey(this).intValue());
        return new QuestingPacket(PacketTypeNative.PARTY_SYNC.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        JsonObject base = NBTConverter.NBTtoJSON_Compound(payload.func_74775_l("data"), new JsonObject());
        this.readFromJson(JsonHelper.GetObject(base, "party"), EnumSaveType.CONFIG);
    }

    @Override
    public JsonObject writeToJson(JsonObject json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        JsonArray memJson = new JsonArray();
        for (Map.Entry<UUID, EnumPartyStatus> mem : this.members.entrySet()) {
            JsonObject jm = new JsonObject();
            jm.addProperty("uuid", mem.getKey().toString());
            jm.addProperty("status", mem.getValue().toString());
            memJson.add((JsonElement)jm);
        }
        json.add("members", (JsonElement)memJson);
        json.add("properties", (JsonElement)this.pInfo.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        return json;
    }

    @Override
    public void readFromJson(JsonObject jObj, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        if (jObj.has("properties")) {
            this.pInfo.readFromJson(JsonHelper.GetObject(jObj, "properties"), EnumSaveType.CONFIG);
        } else {
            this.pInfo.readFromJson(new JsonObject(), EnumSaveType.CONFIG);
            this.pInfo.setProperty(NativeProps.NAME, JsonHelper.GetString(jObj, "name", "New Party"));
            this.pInfo.setProperty(NativeProps.PARTY_LIVES, JsonHelper.GetBoolean(jObj, "lifeShare", false));
            this.pInfo.setProperty(NativeProps.PARTY_LOOT, JsonHelper.GetBoolean(jObj, "lootShare", false));
            this.pInfo.setProperty(NativeProps.LIVES, JsonHelper.GetNumber(jObj, "lives", 1).intValue());
        }
        this.members.clear();
        for (JsonElement entry : JsonHelper.GetArray(jObj, "members")) {
            if (entry == null || !entry.isJsonObject()) continue;
            JsonObject jMem = entry.getAsJsonObject();
            UUID uuid = null;
            EnumPartyStatus priv = EnumPartyStatus.INVITE;
            try {
                uuid = UUID.fromString(JsonHelper.GetString(jMem, "uuid", ""));
            }
            catch (Exception e) {
                uuid = null;
            }
            try {
                priv = EnumPartyStatus.valueOf(JsonHelper.GetString(jMem, "status", EnumPartyStatus.INVITE.toString()));
                priv = priv != null ? priv : EnumPartyStatus.INVITE;
            }
            catch (Exception e) {
                priv = EnumPartyStatus.INVITE;
            }
            if (uuid == null) continue;
            this.members.put(uuid, priv);
        }
        this.setupProps();
    }

    @Override
    @Deprecated
    public void setName(String name) {
        this.pInfo.setProperty(NativeProps.NAME, name);
    }

    @Override
    @Deprecated
    public void setShareLives(boolean state) {
        this.pInfo.setProperty(NativeProps.PARTY_LIVES, state);
    }

    @Override
    @Deprecated
    public void setShareReward(boolean state) {
        this.pInfo.setProperty(NativeProps.PARTY_LOOT, state);
    }
}

