/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyInstance;
import betterquesting.storage.NameCache;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class PartyManager
implements IPartyDatabase {
    public static final PartyManager INSTANCE = new PartyManager();
    private final ConcurrentHashMap<Integer, IParty> partyList = new ConcurrentHashMap();

    private PartyManager() {
    }

    @Override
    public IParty getUserParty(UUID uuid) {
        for (IParty p : this.getAllValues()) {
            EnumPartyStatus status = p.getStatus(uuid);
            if (status == null || status == EnumPartyStatus.INVITE) continue;
            return p;
        }
        return null;
    }

    @Override
    public List<Integer> getPartyInvites(UUID uuid) {
        ArrayList<Integer> invites = new ArrayList<Integer>();
        boolean isOp = NameCache.INSTANCE.isOP(uuid);
        for (Map.Entry<Integer, IParty> entry : this.partyList.entrySet()) {
            if (!isOp && entry.getValue().getStatus(uuid) != EnumPartyStatus.INVITE) continue;
            invites.add(entry.getKey());
        }
        return invites;
    }

    @Override
    public Integer nextKey() {
        int i = 0;
        while (this.partyList.containsKey(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public boolean add(IParty party, Integer id) {
        if (party == null || id < 0 || this.partyList.containsKey(id) || this.partyList.containsValue(party)) {
            return false;
        }
        this.partyList.put(id, party);
        return true;
    }

    @Override
    public boolean removeKey(Integer id) {
        return this.partyList.remove(id) != null;
    }

    @Override
    public boolean removeValue(IParty party) {
        return this.removeKey(this.getKey(party));
    }

    @Override
    public IParty getValue(Integer id) {
        return this.partyList.get(id);
    }

    @Override
    public Integer getKey(IParty party) {
        for (Map.Entry<Integer, IParty> entry : this.partyList.entrySet()) {
            if (entry.getValue() != party) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.partyList.size();
    }

    @Override
    public void reset() {
        this.partyList.clear();
    }

    @Override
    public List<IParty> getAllValues() {
        return new ArrayList<IParty>(this.partyList.values());
    }

    @Override
    public List<Integer> getAllKeys() {
        return new ArrayList<Integer>(this.partyList.keySet());
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject json = new JsonObject();
        json.add("parties", (JsonElement)this.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound()));
        return new QuestingPacket(PacketTypeNative.PARTY_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        JsonObject json = NBTConverter.NBTtoJSON_Compound(payload.func_74775_l("data"), new JsonObject());
        this.readFromJson(JsonHelper.GetArray(json, "parties"), EnumSaveType.CONFIG);
    }

    @Override
    public JsonArray writeToJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (Map.Entry<Integer, IParty> entry : this.partyList.entrySet()) {
            JsonObject jp = entry.getValue().writeToJson(new JsonObject(), saveType);
            jp.addProperty("partyID", (Number)entry.getKey());
            json.add((JsonElement)jp);
        }
        return json;
    }

    @Override
    public void readFromJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.partyList.clear();
        for (JsonElement element : json) {
            JsonObject jp;
            int partyID;
            if (element == null || !element.isJsonObject() || (partyID = JsonHelper.GetNumber(jp = element.getAsJsonObject(), "partyID", -1).intValue()) < 0) continue;
            PartyInstance party = new PartyInstance();
            party.readFromJson(jp, EnumSaveType.CONFIG);
            if (party.getMembers().size() <= 0) continue;
            this.partyList.put(partyID, party);
        }
    }
}

