/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.rewards;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.IJsonSaveLoad;
import betterquesting.api.placeholders.rewards.RewardPlaceholder;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.storage.IRegStorageBase;
import betterquesting.api.utils.JsonHelper;
import betterquesting.questing.rewards.RewardRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class RewardStorage
implements IRegStorageBase<Integer, IReward>,
IJsonSaveLoad<JsonArray> {
    private final HashMap<Integer, IReward> database = new HashMap();

    @Override
    public Integer nextKey() {
        int id = 0;
        while (this.database.containsKey(id)) {
            ++id;
        }
        return id;
    }

    @Override
    public boolean add(IReward obj, Integer id) {
        if (obj == null || this.database.containsKey(id) || this.database.containsKey(id)) {
            return false;
        }
        this.database.put(id, obj);
        return true;
    }

    @Override
    public boolean removeKey(Integer id) {
        return this.database.remove(id) != null;
    }

    @Override
    public boolean removeValue(IReward reward) {
        return this.removeKey(this.getKey(reward));
    }

    @Override
    public IReward getValue(Integer id) {
        return this.database.get(id);
    }

    @Override
    public Integer getKey(IReward obj) {
        int id = -1;
        for (Map.Entry<Integer, IReward> entry : this.database.entrySet()) {
            if (entry.getValue() != obj) continue;
            return entry.getKey();
        }
        return id;
    }

    @Override
    public List<IReward> getAllValues() {
        return new ArrayList<IReward>(this.database.values());
    }

    @Override
    public List<Integer> getAllKeys() {
        return new ArrayList<Integer>(this.database.keySet());
    }

    @Override
    public int size() {
        return this.database.size();
    }

    @Override
    public void reset() {
        this.database.clear();
    }

    @Override
    public JsonArray writeToJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (Map.Entry<Integer, IReward> rew : this.database.entrySet()) {
            ResourceLocation rewardID = rew.getValue().getFactoryID();
            JsonObject rJson = rew.getValue().writeToJson(new JsonObject(), EnumSaveType.CONFIG);
            rJson.addProperty("rewardID", rewardID.toString());
            rJson.addProperty("index", (Number)rew.getKey());
            json.add((JsonElement)rJson);
        }
        return json;
    }

    @Override
    public void readFromJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.database.clear();
        ArrayList<IReward> unassigned = new ArrayList<IReward>();
        for (JsonElement entry : json) {
            JsonObject jr2;
            ResourceLocation loc2;
            IReward r2;
            if (entry == null || !entry.isJsonObject()) continue;
            JsonObject jsonReward = entry.getAsJsonObject();
            ResourceLocation loc = new ResourceLocation(JsonHelper.GetString(jsonReward, "rewardID", ""));
            int index = JsonHelper.GetNumber(jsonReward, "index", -1).intValue();
            IReward reward = RewardRegistry.INSTANCE.createReward(loc);
            if (reward instanceof RewardPlaceholder && (r2 = RewardRegistry.INSTANCE.createReward(loc2 = new ResourceLocation(JsonHelper.GetString(jr2 = JsonHelper.GetObject(jsonReward, "orig_data"), "rewardID", "")))) != null) {
                jsonReward = jr2;
                reward = r2;
            }
            if (reward != null) {
                reward.readFromJson(jsonReward, EnumSaveType.CONFIG);
                if (index >= 0) {
                    this.add(reward, index);
                    continue;
                }
                unassigned.add(reward);
                continue;
            }
            RewardPlaceholder rph = new RewardPlaceholder();
            rph.setRewardData(jsonReward, EnumSaveType.CONFIG);
            if (index >= 0) {
                this.add(rph, index);
                continue;
            }
            unassigned.add(rph);
        }
        for (IReward r : unassigned) {
            this.add(r, this.nextKey());
        }
    }
}

