/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.IJsonSaveLoad;
import betterquesting.api.placeholders.tasks.FactoryTaskPlaceholder;
import betterquesting.api.placeholders.tasks.TaskPlaceholder;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.IRegStorageBase;
import betterquesting.api.utils.JsonHelper;
import betterquesting.questing.tasks.TaskRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class TaskStorage
implements IRegStorageBase<Integer, ITask>,
IJsonSaveLoad<JsonArray> {
    private final HashMap<Integer, ITask> database = new HashMap();

    @Override
    public Integer nextKey() {
        int id = 0;
        while (this.database.containsKey(id)) {
            ++id;
        }
        return id;
    }

    @Override
    public boolean add(ITask obj, Integer id) {
        if (obj == null || this.database.containsKey(id) || this.database.containsKey(id)) {
            return false;
        }
        this.database.put(id, obj);
        return true;
    }

    @Override
    public boolean removeKey(Integer id) {
        return this.database.remove(id) != null;
    }

    @Override
    public boolean removeValue(ITask task) {
        return this.removeKey(this.getKey(task));
    }

    @Override
    public ITask getValue(Integer id) {
        return this.database.get(id);
    }

    @Override
    public Integer getKey(ITask obj) {
        int id = -1;
        for (Map.Entry<Integer, ITask> entry : this.database.entrySet()) {
            if (entry.getValue() != obj) continue;
            return entry.getKey();
        }
        return id;
    }

    @Override
    public List<ITask> getAllValues() {
        return new ArrayList<ITask>(this.database.values());
    }

    @Override
    public List<Integer> getAllKeys() {
        return new ArrayList<Integer>(this.database.keySet());
    }

    @Override
    public int size() {
        return this.database.size();
    }

    @Override
    public void reset() {
        this.database.clear();
    }

    @Override
    public JsonArray writeToJson(JsonArray json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.writeToJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.writeToJson_Progress(json);
                break;
            }
        }
        return json;
    }

    @Override
    public void readFromJson(JsonArray json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.readFromJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.readFromJson_Progress(json);
                break;
            }
        }
    }

    private JsonArray writeToJson_Config(JsonArray json) {
        for (Map.Entry<Integer, ITask> entry : this.database.entrySet()) {
            ResourceLocation taskID = entry.getValue().getFactoryID();
            JsonObject qJson = entry.getValue().writeToJson(new JsonObject(), EnumSaveType.CONFIG);
            qJson.addProperty("taskID", taskID.toString());
            qJson.addProperty("index", (Number)entry.getKey());
            json.add((JsonElement)qJson);
        }
        return json;
    }

    private void readFromJson_Config(JsonArray json) {
        this.database.clear();
        ArrayList<ITask> unassigned = new ArrayList<ITask>();
        for (JsonElement entry : json) {
            JsonObject jt2;
            ResourceLocation loc2;
            ITask t2;
            if (entry == null || !entry.isJsonObject()) continue;
            JsonObject jsonTask = entry.getAsJsonObject();
            ResourceLocation loc = new ResourceLocation(JsonHelper.GetString(jsonTask, "taskID", ""));
            int index = JsonHelper.GetNumber(jsonTask, "index", -1).intValue();
            ITask task = TaskRegistry.INSTANCE.createTask(loc);
            if (task instanceof TaskPlaceholder && (t2 = TaskRegistry.INSTANCE.createTask(loc2 = new ResourceLocation(JsonHelper.GetString(jt2 = JsonHelper.GetObject(jsonTask, "orig_data"), "taskID", "")))) != null) {
                jsonTask = jt2;
                task = t2;
            }
            if (task != null) {
                task.readFromJson(jsonTask, EnumSaveType.CONFIG);
                if (index >= 0) {
                    this.add(task, index);
                    continue;
                }
                unassigned.add(task);
                continue;
            }
            TaskPlaceholder tph = new TaskPlaceholder();
            tph.setTaskData(jsonTask, EnumSaveType.CONFIG);
            if (index >= 0) {
                this.add(tph, index);
                continue;
            }
            unassigned.add(tph);
        }
        for (ITask t : unassigned) {
            this.add(t, this.nextKey());
        }
    }

    private JsonArray writeToJson_Progress(JsonArray json) {
        for (Map.Entry<Integer, ITask> entry : this.database.entrySet()) {
            ResourceLocation taskID = entry.getValue().getFactoryID();
            JsonObject qJson = entry.getValue().writeToJson(new JsonObject(), EnumSaveType.PROGRESS);
            qJson.addProperty("taskID", taskID.toString());
            qJson.addProperty("index", (Number)entry.getKey());
            json.add((JsonElement)qJson);
        }
        return json;
    }

    private void readFromJson_Progress(JsonArray json) {
        for (int i = 0; i < json.size(); ++i) {
            JsonElement entry = json.get(i);
            if (entry == null || !entry.isJsonObject()) continue;
            JsonObject jsonTask = entry.getAsJsonObject();
            int index = JsonHelper.GetNumber(jsonTask, "index", -1).intValue();
            ResourceLocation loc = new ResourceLocation(JsonHelper.GetString(jsonTask, "taskID", ""));
            ITask task = this.getValue(index);
            if (task instanceof TaskPlaceholder) {
                if (!task.getFactoryID().equals((Object)loc)) {
                    ((TaskPlaceholder)task).setTaskData(jsonTask, EnumSaveType.PROGRESS);
                    continue;
                }
                task.readFromJson(jsonTask, EnumSaveType.PROGRESS);
                continue;
            }
            if (task == null) continue;
            if (task.getFactoryID().equals((Object)loc)) {
                task.readFromJson(jsonTask, EnumSaveType.PROGRESS);
                continue;
            }
            if (!FactoryTaskPlaceholder.INSTANCE.getRegistryName().equals((Object)loc)) continue;
            task.readFromJson(JsonHelper.GetObject(jsonTask, "orig_prog"), EnumSaveType.PROGRESS);
        }
    }
}

