/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.storage.ILifeDatabase;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public final class LifeDatabase
implements ILifeDatabase {
    public static final LifeDatabase INSTANCE = new LifeDatabase();
    private final HashMap<UUID, Integer> playerLives = new HashMap();
    private final HashMap<Integer, Integer> partyLives = new HashMap();

    private LifeDatabase() {
    }

    @Override
    @Deprecated
    public int getDefaultLives() {
        return QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_DEF).intValue();
    }

    @Override
    @Deprecated
    public int getMaxLives() {
        return QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_MAX).intValue();
    }

    @Override
    public int getLives(UUID uuid) {
        if (uuid == null) {
            return 0;
        }
        if (this.playerLives.containsKey(uuid)) {
            return this.playerLives.get(uuid);
        }
        int def = QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_DEF).intValue();
        this.playerLives.put(uuid, def);
        return def;
    }

    @Override
    public void setLives(UUID uuid, int value) {
        if (uuid == null) {
            return;
        }
        this.playerLives.put(uuid, MathHelper.func_76125_a((int)value, (int)0, (int)QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_MAX).intValue()));
    }

    @Override
    public int getLives(IParty party) {
        int id;
        int n = id = party == null ? -1 : PartyManager.INSTANCE.getKey(party);
        if (id < 0) {
            return 0;
        }
        if (this.partyLives.containsKey(id)) {
            return this.partyLives.get(id);
        }
        int def = QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_DEF).intValue();
        this.partyLives.put(id, def);
        return def;
    }

    @Override
    public void setLives(IParty party, int value) {
        int id;
        int n = id = party == null ? -1 : PartyManager.INSTANCE.getKey(party);
        if (id < 0) {
            return;
        }
        this.partyLives.put(id, MathHelper.func_76125_a((int)value, (int)0, (int)QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_MAX).intValue()));
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject base = new JsonObject();
        base.add("config", (JsonElement)this.writeToJson(new JsonObject(), EnumSaveType.CONFIG));
        base.add("lives", (JsonElement)this.writeToJson(new JsonObject(), EnumSaveType.PROGRESS));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(base, new NBTTagCompound()));
        return new QuestingPacket(PacketTypeNative.LIFE_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        JsonObject base = NBTConverter.NBTtoJSON_Compound(payload.func_74775_l("data"), new JsonObject());
        this.readFromJson(JsonHelper.GetObject(base, "config"), EnumSaveType.CONFIG);
        this.readFromJson(JsonHelper.GetObject(base, "lives"), EnumSaveType.PROGRESS);
    }

    @Override
    public JsonObject writeToJson(JsonObject json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.PROGRESS) {
            return json;
        }
        return this.writeToJson_Progress(json);
    }

    @Override
    public void readFromJson(JsonObject json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.readFromJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.readFromJson_Progress(json);
                break;
            }
        }
    }

    private void readFromJson_Config(JsonObject json) {
        if (json.has("defLives")) {
            QuestSettings.INSTANCE.setProperty(NativeProps.LIVES_DEF, JsonHelper.GetNumber(json, "defLives", 3).intValue());
        }
        if (json.has("maxLives")) {
            QuestSettings.INSTANCE.setProperty(NativeProps.LIVES_MAX, JsonHelper.GetNumber(json, "maxLives", 10).intValue());
        }
    }

    private JsonObject writeToJson_Progress(JsonObject json) {
        JsonArray jul = new JsonArray();
        for (Map.Entry<UUID, Integer> entry : this.playerLives.entrySet()) {
            JsonObject j = new JsonObject();
            j.addProperty("uuid", entry.getKey().toString());
            j.addProperty("lives", (Number)entry.getValue());
            jul.add((JsonElement)j);
        }
        json.add("playerLives", (JsonElement)jul);
        JsonArray jpl = new JsonArray();
        for (Map.Entry<Integer, Integer> entry : this.partyLives.entrySet()) {
            JsonObject j = new JsonObject();
            j.addProperty("partyID", (Number)entry.getKey());
            j.addProperty("lives", (Number)entry.getValue());
            jpl.add((JsonElement)j);
        }
        json.add("partyLives", (JsonElement)jpl);
        return json;
    }

    private void readFromJson_Progress(JsonObject json) {
        int lives;
        JsonObject j;
        this.playerLives.clear();
        for (JsonElement entry : JsonHelper.GetArray(json, "playerLives")) {
            if (entry == null || !entry.isJsonObject()) continue;
            j = entry.getAsJsonObject();
            try {
                UUID uuid = UUID.fromString(JsonHelper.GetString(j, "uuid", ""));
                lives = JsonHelper.GetNumber(j, "lives", 3).intValue();
                this.playerLives.put(uuid, lives);
            }
            catch (Exception e) {}
        }
        this.partyLives.clear();
        for (JsonElement entry : JsonHelper.GetArray(json, "partyLives")) {
            if (entry == null || !entry.isJsonObject()) continue;
            j = entry.getAsJsonObject();
            int partyID = JsonHelper.GetNumber(j, "partyID", -1).intValue();
            lives = JsonHelper.GetNumber(j, "lives", 3).intValue();
            if (partyID < 0) continue;
            this.partyLives.put(partyID, lives);
        }
    }

    public void reset() {
        this.playerLives.clear();
        this.partyLives.clear();
    }
}

