/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.storage.INameCache;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public final class NameCache
implements INameCache {
    public static final NameCache INSTANCE = new NameCache();
    private final ConcurrentHashMap<UUID, JsonObject> cache = new ConcurrentHashMap();

    private NameCache() {
    }

    @Override
    public String getName(UUID uuid) {
        if (!this.cache.containsKey(uuid)) {
            return uuid.toString();
        }
        return JsonHelper.GetString(this.cache.get(uuid), "name", "");
    }

    @Override
    public UUID getUUID(String name) {
        for (Map.Entry<UUID, JsonObject> entry : this.cache.entrySet()) {
            if (!JsonHelper.GetString(entry.getValue(), "name", "").equalsIgnoreCase(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean isOP(UUID uuid) {
        if (!this.cache.containsKey(uuid)) {
            return false;
        }
        return JsonHelper.GetBoolean(this.cache.get(uuid), "isOP", false);
    }

    @Override
    public void updateNames(MinecraftServer server) {
        String[] names;
        for (String name : names = server.func_152358_ax().func_152654_a()) {
            GameProfile prof;
            EntityPlayerMP player = server.func_184103_al().func_152612_a(name);
            GameProfile gameProfile = prof = player == null ? null : player.func_146103_bH();
            if (prof == null) continue;
            UUID oldID = this.getUUID(prof.getName());
            while (oldID != null) {
                this.cache.remove(oldID);
                oldID = this.getUUID(prof.getName());
            }
            JsonObject json = new JsonObject();
            json.addProperty("name", prof.getName());
            json.addProperty("isOP", Boolean.valueOf(server.func_184103_al().func_152596_g(prof)));
            this.cache.put(prof.getId(), json);
        }
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        JsonObject json = new JsonObject();
        json.add("cache", (JsonElement)this.writeToJson(new JsonArray(), EnumSaveType.CONFIG));
        tags.func_74782_a("data", (NBTBase)NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound()));
        return new QuestingPacket(PacketTypeNative.NAME_CACHE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        JsonObject base = NBTConverter.NBTtoJSON_Compound(payload.func_74775_l("data"), new JsonObject());
        this.readFromJson(JsonHelper.GetArray(base, "cache"), EnumSaveType.CONFIG);
    }

    @Override
    public JsonArray writeToJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (Map.Entry<UUID, JsonObject> entry : this.cache.entrySet()) {
            JsonObject jn = new JsonObject();
            jn.addProperty("uuid", entry.getKey().toString());
            jn.addProperty("name", JsonHelper.GetString(entry.getValue(), "name", ""));
            jn.addProperty("isOP", Boolean.valueOf(JsonHelper.GetBoolean(entry.getValue(), "isOP", false)));
            json.add((JsonElement)jn);
        }
        return json;
    }

    @Override
    public void readFromJson(JsonArray json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.cache.clear();
        for (JsonElement element : json) {
            if (element == null || !element.isJsonObject()) continue;
            JsonObject jn = element.getAsJsonObject();
            try {
                UUID uuid = UUID.fromString(JsonHelper.GetString(jn, "uuid", ""));
                String name = JsonHelper.GetString(jn, "name", "");
                boolean isOP = JsonHelper.GetBoolean(jn, "isOP", false);
                JsonObject j2 = new JsonObject();
                j2.addProperty("name", name);
                j2.addProperty("isOP", Boolean.valueOf(isOP));
                this.cache.put(uuid, j2);
            }
            catch (Exception e) {}
        }
    }

    public void reset() {
        this.cache.clear();
    }

    @Override
    public List<String> getAllNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonObject json : this.cache.values()) {
            if (json == null || !json.has("name")) continue;
            list.add(JsonHelper.GetString(json, "name", ""));
        }
        return list;
    }
}

